/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: OMRPortLibraryGlobalData
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class OMRPortLibraryGlobalData {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _buffer_listOffset_;
	public static final int _controlOffset_;
	public static final int _corruptedMemoryBlockOffset_;
	public static final int _disableEnsureCap32Offset_;
	public static final int _latestCPUTimeOffset_;
	public static final int _nls_dataOffset_;
	public static final int _oldestCPUTimeOffset_;
	public static final int _platformGlobalsOffset_;
	public static final int _portLibraryMemoryCategoryOffset_;
	public static final int _procSelfMapOffset_;
	public static final int _socketTlsKeyOffset_;
	public static final int _tls_keyOffset_;
	public static final int _tls_mutexOffset_;
	public static final int _unknownMemoryCategoryOffset_;
	public static final int _unusedAllocate32HeapRegionsMemoryCategoryOffset_;
	public static final int _userSpecifiedCPUsOffset_;
	public static final int _vectorRegsSupportOnOffset_;
	public static final int _vmemAdviseOSonFreeOffset_;
	public static final int _vmemEnableMadviseOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_buffer_listOffset_ = 0;
		_controlOffset_ = 0;
		_corruptedMemoryBlockOffset_ = 0;
		_disableEnsureCap32Offset_ = 0;
		_latestCPUTimeOffset_ = 0;
		_nls_dataOffset_ = 0;
		_oldestCPUTimeOffset_ = 0;
		_platformGlobalsOffset_ = 0;
		_portLibraryMemoryCategoryOffset_ = 0;
		_procSelfMapOffset_ = 0;
		_socketTlsKeyOffset_ = 0;
		_tls_keyOffset_ = 0;
		_tls_mutexOffset_ = 0;
		_unknownMemoryCategoryOffset_ = 0;
		_unusedAllocate32HeapRegionsMemoryCategoryOffset_ = 0;
		_userSpecifiedCPUsOffset_ = 0;
		_vectorRegsSupportOnOffset_ = 0;
		_vmemAdviseOSonFreeOffset_ = 0;
		_vmemEnableMadviseOffset_ = 0;
	}

}
