/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: __pthrdscontext
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class __pthrdscontext {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int ___pc_crOffset_;
	public static final int ___pc_ctrOffset_;
	public static final int ___pc_exceptOffset_;
	public static final int ___pc_excp_typeOffset_;
	public static final int ___pc_fpeuOffset_;
	public static final int ___pc_fpinfoOffset_;
	public static final int ___pc_fprOffset_;
	public static final int ___pc_fpscrOffset_;
	public static final int ___pc_fpscr24_31Offset_;
	public static final int ___pc_fpscrxOffset_;
	public static final int ___pc_gprOffset_;
	public static final int ___pc_iarOffset_;
	public static final int ___pc_lrOffset_;
	public static final int ___pc_mqOffset_;
	public static final int ___pc_msrOffset_;
	public static final int ___pc_padOffset_;
	public static final int ___pc_xerOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		___pc_crOffset_ = 0;
		___pc_ctrOffset_ = 0;
		___pc_exceptOffset_ = 0;
		___pc_excp_typeOffset_ = 0;
		___pc_fpeuOffset_ = 0;
		___pc_fpinfoOffset_ = 0;
		___pc_fprOffset_ = 0;
		___pc_fpscrOffset_ = 0;
		___pc_fpscr24_31Offset_ = 0;
		___pc_fpscrxOffset_ = 0;
		___pc_gprOffset_ = 0;
		___pc_iarOffset_ = 0;
		___pc_lrOffset_ = 0;
		___pc_mqOffset_ = 0;
		___pc_msrOffset_ = 0;
		___pc_padOffset_ = 0;
		___pc_xerOffset_ = 0;
	}

}
