/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: tbtable_short
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class tbtable_short {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _cl_dis_inv_s_;
	public static final int _cl_dis_inv_b_;
	public static final int _fixedparms_s_;
	public static final int _fixedparms_b_;
	public static final int _fixup_s_;
	public static final int _fixup_b_;
	public static final int _floatparms_s_;
	public static final int _floatparms_b_;
	public static final int _fp_present_s_;
	public static final int _fp_present_b_;
	public static final int _fpr_saved_s_;
	public static final int _fpr_saved_b_;
	public static final int _globallink_s_;
	public static final int _globallink_b_;
	public static final int _gpr_saved_s_;
	public static final int _gpr_saved_b_;
	public static final int _has_ctl_s_;
	public static final int _has_ctl_b_;
	public static final int _has_tboff_s_;
	public static final int _has_tboff_b_;
	public static final int _has_vec_s_;
	public static final int _has_vec_b_;
	public static final int _int_hndl_s_;
	public static final int _int_hndl_b_;
	public static final int _int_proc_s_;
	public static final int _int_proc_b_;
	public static final int _is_eprol_s_;
	public static final int _is_eprol_b_;
	public static final int _lang_s_;
	public static final int _lang_b_;
	public static final int _log_abort_s_;
	public static final int _log_abort_b_;
	public static final int _longtbtable_s_;
	public static final int _longtbtable_b_;
	public static final int _name_present_s_;
	public static final int _name_present_b_;
	public static final int _parmsonstk_s_;
	public static final int _parmsonstk_b_;
	public static final int _saves_cr_s_;
	public static final int _saves_cr_b_;
	public static final int _saves_lr_s_;
	public static final int _saves_lr_b_;
	public static final int _stores_bc_s_;
	public static final int _stores_bc_b_;
	public static final int _tocless_s_;
	public static final int _tocless_b_;
	public static final int _uses_alloca_s_;
	public static final int _uses_alloca_b_;
	public static final int _version_s_;
	public static final int _version_b_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_cl_dis_inv_s_ = 0;
		_cl_dis_inv_b_ = 0;
		_fixedparms_s_ = 0;
		_fixedparms_b_ = 0;
		_fixup_s_ = 0;
		_fixup_b_ = 0;
		_floatparms_s_ = 0;
		_floatparms_b_ = 0;
		_fp_present_s_ = 0;
		_fp_present_b_ = 0;
		_fpr_saved_s_ = 0;
		_fpr_saved_b_ = 0;
		_globallink_s_ = 0;
		_globallink_b_ = 0;
		_gpr_saved_s_ = 0;
		_gpr_saved_b_ = 0;
		_has_ctl_s_ = 0;
		_has_ctl_b_ = 0;
		_has_tboff_s_ = 0;
		_has_tboff_b_ = 0;
		_has_vec_s_ = 0;
		_has_vec_b_ = 0;
		_int_hndl_s_ = 0;
		_int_hndl_b_ = 0;
		_int_proc_s_ = 0;
		_int_proc_b_ = 0;
		_is_eprol_s_ = 0;
		_is_eprol_b_ = 0;
		_lang_s_ = 0;
		_lang_b_ = 0;
		_log_abort_s_ = 0;
		_log_abort_b_ = 0;
		_longtbtable_s_ = 0;
		_longtbtable_b_ = 0;
		_name_present_s_ = 0;
		_name_present_b_ = 0;
		_parmsonstk_s_ = 0;
		_parmsonstk_b_ = 0;
		_saves_cr_s_ = 0;
		_saves_cr_b_ = 0;
		_saves_lr_s_ = 0;
		_saves_lr_b_ = 0;
		_stores_bc_s_ = 0;
		_stores_bc_b_ = 0;
		_tocless_s_ = 0;
		_tocless_b_ = 0;
		_uses_alloca_s_ = 0;
		_uses_alloca_b_ = 0;
		_version_s_ = 0;
		_version_b_ = 0;
	}

}
