/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: ucred_ext
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class ucred_ext {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _crx_acctidOffset_;
	public static final int _crx_bprivOffset_;
	public static final int _crx_capsOffset_;
	public static final int _crx_effprivOffset_;
	public static final int _crx_eprivOffset_;
	public static final int _crx_flagsOffset_;
	public static final int _crx_gidOffset_;
	public static final int _crx_groupsOffset_;
	public static final int _crx_inhprivOffset_;
	public static final int _crx_iprivOffset_;
	public static final int _crx_limprivOffset_;
	public static final int _crx_luidOffset_;
	public static final int _crx_maxprivOffset_;
	public static final int _crx_mprivOffset_;
	public static final int _crx_ngrpsOffset_;
	public static final int _crx_npagsOffset_;
	public static final int _crx_nrolesOffset_;
	public static final int _crx_padOffset_;
	public static final int _crx_pagidsOffset_;
	public static final int _crx_pagsOffset_;
	public static final int _crx_reserved_1Offset_;
	public static final int _crx_reserved_2Offset_;
	public static final int _crx_reserved_3Offset_;
	public static final int _crx_rgidOffset_;
	public static final int _crx_rolesOffset_;
	public static final int _crx_ruidOffset_;
	public static final int _crx_sgidOffset_;
	public static final int _crx_suidOffset_;
	public static final int _crx_uidOffset_;
	public static final int _crx_usedprivOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_crx_acctidOffset_ = 0;
		_crx_bprivOffset_ = 0;
		_crx_capsOffset_ = 0;
		_crx_effprivOffset_ = 0;
		_crx_eprivOffset_ = 0;
		_crx_flagsOffset_ = 0;
		_crx_gidOffset_ = 0;
		_crx_groupsOffset_ = 0;
		_crx_inhprivOffset_ = 0;
		_crx_iprivOffset_ = 0;
		_crx_limprivOffset_ = 0;
		_crx_luidOffset_ = 0;
		_crx_maxprivOffset_ = 0;
		_crx_mprivOffset_ = 0;
		_crx_ngrpsOffset_ = 0;
		_crx_npagsOffset_ = 0;
		_crx_nrolesOffset_ = 0;
		_crx_padOffset_ = 0;
		_crx_pagidsOffset_ = 0;
		_crx_pagsOffset_ = 0;
		_crx_reserved_1Offset_ = 0;
		_crx_reserved_2Offset_ = 0;
		_crx_reserved_3Offset_ = 0;
		_crx_rgidOffset_ = 0;
		_crx_rolesOffset_ = 0;
		_crx_ruidOffset_ = 0;
		_crx_sgidOffset_ = 0;
		_crx_suidOffset_ = 0;
		_crx_uidOffset_ = 0;
		_crx_usedprivOffset_ = 0;
	}

}
