/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ThreadChainPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ThreadChainPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ThreadChain.class)
public class ThreadChainPointer extends StructurePointer {

	// NULL
	public static final ThreadChainPointer NULL = new ThreadChainPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ThreadChainPointer(long address) {
		super(address);
	}

	public static ThreadChainPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ThreadChainPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ThreadChainPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ThreadChainPointer(address);
	}

	public ThreadChainPointer add(long count) {
		return ThreadChainPointer.cast(address + (ThreadChain.SIZEOF * count));
	}

	public ThreadChainPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ThreadChainPointer addOffset(long offset) {
		return ThreadChainPointer.cast(address + offset);
	}

	public ThreadChainPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ThreadChainPointer sub(long count) {
		return ThreadChainPointer.cast(address - (ThreadChain.SIZEOF * count));
	}

	public ThreadChainPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ThreadChainPointer subOffset(long offset) {
		return ThreadChainPointer.cast(address - offset);
	}

	public ThreadChainPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ThreadChainPointer untag(long mask) {
		return ThreadChainPointer.cast(address & ~mask);
	}

	public ThreadChainPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ThreadChain.SIZEOF;
	}

	// Implementation methods

	// BOOLEAN deadlocked
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_deadlockedOffset_", declaredType="BOOLEAN")
	public UDATA deadlocked() throws CorruptDataException {
		return new U32(getIntAtOffset(ThreadChain._deadlockedOffset_));
	}

	// BOOLEAN deadlocked
	public UDATAPointer deadlockedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ThreadChain._deadlockedOffset_));
	}

	// j9object_t object
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_objectOffset_", declaredType="j9object_t")
	public J9ObjectPointer object() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(ThreadChain._objectOffset_));
	}

	// j9object_t object
	public PointerPointer objectEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadChain._objectOffset_));
	}

	// J9VMThread* owner
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ownerOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer owner() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(ThreadChain._ownerOffset_));
	}

	// J9VMThread* owner
	public PointerPointer ownerEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadChain._ownerOffset_));
	}

	// IDATA owner_index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_owner_indexOffset_", declaredType="IDATA")
	public IDATA owner_index() throws CorruptDataException {
		return getIDATAAtOffset(ThreadChain._owner_indexOffset_);
	}

	// IDATA owner_index
	public IDATAPointer owner_indexEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ThreadChain._owner_indexOffset_));
	}

	// J9VMThread* thread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_threadOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer thread() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(ThreadChain._threadOffset_));
	}

	// J9VMThread* thread
	public PointerPointer threadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadChain._threadOffset_));
	}

	// j9object_t threadobj
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_threadobjOffset_", declaredType="j9object_t")
	public J9ObjectPointer threadobj() throws CorruptDataException {
		return J9ObjectPointer.cast(getPointerAtOffset(ThreadChain._threadobjOffset_));
	}

	// j9object_t threadobj
	public PointerPointer threadobjEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadChain._threadobjOffset_));
	}

	// UDATA visit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_visitOffset_", declaredType="UDATA")
	public UDATA visit() throws CorruptDataException {
		return getUDATAAtOffset(ThreadChain._visitOffset_);
	}

	// UDATA visit
	public UDATAPointer visitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ThreadChain._visitOffset_));
	}

}
