/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: tbtable_shortPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the tbtable_shortPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=tbtable_short.class)
public class tbtable_shortPointer extends StructurePointer {

	// NULL
	public static final tbtable_shortPointer NULL = new tbtable_shortPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected tbtable_shortPointer(long address) {
		super(address);
	}

	public static tbtable_shortPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static tbtable_shortPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static tbtable_shortPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new tbtable_shortPointer(address);
	}

	public tbtable_shortPointer add(long count) {
		return tbtable_shortPointer.cast(address + (tbtable_short.SIZEOF * count));
	}

	public tbtable_shortPointer add(Scalar count) {
		return add(count.longValue());
	}

	public tbtable_shortPointer addOffset(long offset) {
		return tbtable_shortPointer.cast(address + offset);
	}

	public tbtable_shortPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public tbtable_shortPointer sub(long count) {
		return tbtable_shortPointer.cast(address - (tbtable_short.SIZEOF * count));
	}

	public tbtable_shortPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public tbtable_shortPointer subOffset(long offset) {
		return tbtable_shortPointer.cast(address - offset);
	}

	public tbtable_shortPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public tbtable_shortPointer untag(long mask) {
		return tbtable_shortPointer.cast(address & ~mask);
	}

	public tbtable_shortPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return tbtable_short.SIZEOF;
	}

	// Implementation methods

	// U32:3 cl_dis_inv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cl_dis_invOffset_", declaredType="U32:3")
	public UDATA cl_dis_inv() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._cl_dis_inv_s_, tbtable_short._cl_dis_inv_b_);
	}

	// U32:8 fixedparms
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fixedparmsOffset_", declaredType="U32:8")
	public UDATA fixedparms() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._fixedparms_s_, tbtable_short._fixedparms_b_);
	}

	// U32:1 fixup
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fixupOffset_", declaredType="U32:1")
	public UDATA fixup() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._fixup_s_, tbtable_short._fixup_b_);
	}

	// U32:7 floatparms
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_floatparmsOffset_", declaredType="U32:7")
	public UDATA floatparms() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._floatparms_s_, tbtable_short._floatparms_b_);
	}

	// U32:1 fp_present
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fp_presentOffset_", declaredType="U32:1")
	public UDATA fp_present() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._fp_present_s_, tbtable_short._fp_present_b_);
	}

	// U32:6 fpr_saved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpr_savedOffset_", declaredType="U32:6")
	public UDATA fpr_saved() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._fpr_saved_s_, tbtable_short._fpr_saved_b_);
	}

	// U32:1 globallink
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_globallinkOffset_", declaredType="U32:1")
	public UDATA globallink() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._globallink_s_, tbtable_short._globallink_b_);
	}

	// U32:6 gpr_saved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gpr_savedOffset_", declaredType="U32:6")
	public UDATA gpr_saved() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._gpr_saved_s_, tbtable_short._gpr_saved_b_);
	}

	// U32:1 has_ctl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_has_ctlOffset_", declaredType="U32:1")
	public UDATA has_ctl() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._has_ctl_s_, tbtable_short._has_ctl_b_);
	}

	// U32:1 has_tboff
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_has_tboffOffset_", declaredType="U32:1")
	public UDATA has_tboff() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._has_tboff_s_, tbtable_short._has_tboff_b_);
	}

	// U32:1 has_vec
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_has_vecOffset_", declaredType="U32:1")
	public UDATA has_vec() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._has_vec_s_, tbtable_short._has_vec_b_);
	}

	// U32:1 int_hndl
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_int_hndlOffset_", declaredType="U32:1")
	public UDATA int_hndl() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._int_hndl_s_, tbtable_short._int_hndl_b_);
	}

	// U32:1 int_proc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_int_procOffset_", declaredType="U32:1")
	public UDATA int_proc() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._int_proc_s_, tbtable_short._int_proc_b_);
	}

	// U32:1 is_eprol
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_is_eprolOffset_", declaredType="U32:1")
	public UDATA is_eprol() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._is_eprol_s_, tbtable_short._is_eprol_b_);
	}

	// U32:8 lang
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_langOffset_", declaredType="U32:8")
	public UDATA lang() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._lang_s_, tbtable_short._lang_b_);
	}

	// U32:1 log_abort
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_log_abortOffset_", declaredType="U32:1")
	public UDATA log_abort() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._log_abort_s_, tbtable_short._log_abort_b_);
	}

	// U32:1 longtbtable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_longtbtableOffset_", declaredType="U32:1")
	public UDATA longtbtable() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._longtbtable_s_, tbtable_short._longtbtable_b_);
	}

	// U32:1 name_present
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_name_presentOffset_", declaredType="U32:1")
	public UDATA name_present() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._name_present_s_, tbtable_short._name_present_b_);
	}

	// U32:1 parmsonstk
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_parmsonstkOffset_", declaredType="U32:1")
	public UDATA parmsonstk() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._parmsonstk_s_, tbtable_short._parmsonstk_b_);
	}

	// U32:1 saves_cr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_saves_crOffset_", declaredType="U32:1")
	public UDATA saves_cr() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._saves_cr_s_, tbtable_short._saves_cr_b_);
	}

	// U32:1 saves_lr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_saves_lrOffset_", declaredType="U32:1")
	public UDATA saves_lr() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._saves_lr_s_, tbtable_short._saves_lr_b_);
	}

	// U32:1 stores_bc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_stores_bcOffset_", declaredType="U32:1")
	public UDATA stores_bc() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._stores_bc_s_, tbtable_short._stores_bc_b_);
	}

	// U32:1 tocless
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_toclessOffset_", declaredType="U32:1")
	public UDATA tocless() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._tocless_s_, tbtable_short._tocless_b_);
	}

	// U32:1 uses_alloca
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uses_allocaOffset_", declaredType="U32:1")
	public UDATA uses_alloca() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._uses_alloca_s_, tbtable_short._uses_alloca_b_);
	}

	// U32:8 version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_versionOffset_", declaredType="U32:8")
	public UDATA version() throws CorruptDataException {
		return getU32Bitfield(tbtable_short._version_s_, tbtable_short._version_b_);
	}

}
