/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_MetronomeSynchronousGCEndEvent
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_MetronomeSynchronousGCEndEvent {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _anonymousClassesUnloadedOffset_;
	public static final int _classLoadersUnloadedOffset_;
	public static final int _classesUnloadedOffset_;
	public static final int _currentThreadOffset_;
	public static final int _dynamicSoftReferenceThresholdOffset_;
	public static final int _eventidOffset_;
	public static final int _finalizableCountOffset_;
	public static final int _heapFreeOffset_;
	public static final int _immortalFreeOffset_;
	public static final int _objectOverflowCountOffset_;
	public static final int _phantomReferenceClearCountOffset_;
	public static final int _softReferenceClearCountOffset_;
	public static final int _softReferenceThresholdOffset_;
	public static final int _timestampOffset_;
	public static final int _weakReferenceClearCountOffset_;
	public static final int _workPacketOverflowCountOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_anonymousClassesUnloadedOffset_ = 0;
		_classLoadersUnloadedOffset_ = 0;
		_classesUnloadedOffset_ = 0;
		_currentThreadOffset_ = 0;
		_dynamicSoftReferenceThresholdOffset_ = 0;
		_eventidOffset_ = 0;
		_finalizableCountOffset_ = 0;
		_heapFreeOffset_ = 0;
		_immortalFreeOffset_ = 0;
		_objectOverflowCountOffset_ = 0;
		_phantomReferenceClearCountOffset_ = 0;
		_softReferenceClearCountOffset_ = 0;
		_softReferenceThresholdOffset_ = 0;
		_timestampOffset_ = 0;
		_weakReferenceClearCountOffset_ = 0;
		_workPacketOverflowCountOffset_ = 0;
	}

}
