/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: AddressIteratorPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the AddressIteratorPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=AddressIterator.class)
public class AddressIteratorPointer extends StructurePointer {

	// NULL
	public static final AddressIteratorPointer NULL = new AddressIteratorPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected AddressIteratorPointer(long address) {
		super(address);
	}

	public static AddressIteratorPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static AddressIteratorPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static AddressIteratorPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new AddressIteratorPointer(address);
	}

	public AddressIteratorPointer add(long count) {
		return AddressIteratorPointer.cast(address + (AddressIterator.SIZEOF * count));
	}

	public AddressIteratorPointer add(Scalar count) {
		return add(count.longValue());
	}

	public AddressIteratorPointer addOffset(long offset) {
		return AddressIteratorPointer.cast(address + offset);
	}

	public AddressIteratorPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public AddressIteratorPointer sub(long count) {
		return AddressIteratorPointer.cast(address - (AddressIterator.SIZEOF * count));
	}

	public AddressIteratorPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public AddressIteratorPointer subOffset(long offset) {
		return AddressIteratorPointer.cast(address - offset);
	}

	public AddressIteratorPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public AddressIteratorPointer untag(long mask) {
		return AddressIteratorPointer.cast(address & ~mask);
	}

	public AddressIteratorPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return AddressIterator.SIZEOF;
	}

	// Implementation methods

	// U64 alignment
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_alignmentOffset_", declaredType="U64")
	public UDATA alignment() throws CorruptDataException {
		return new U64(getLongAtOffset(AddressIterator._alignmentOffset_));
	}

	// U64 alignment
	public UDATAPointer alignmentEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(AddressIterator._alignmentOffset_));
	}

	// I64 direction
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_directionOffset_", declaredType="I64")
	public IDATA direction() throws CorruptDataException {
		return new I64(getLongAtOffset(AddressIterator._directionOffset_));
	}

	// I64 direction
	public IDATAPointer directionEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(AddressIterator._directionOffset_));
	}

	// ADDRESS maximum
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maximumOffset_", declaredType="ADDRESS")
	public VoidPointer maximum() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(AddressIterator._maximumOffset_));
	}

	// ADDRESS maximum
	public PointerPointer maximumEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(AddressIterator._maximumOffset_));
	}

	// ADDRESS minimum
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_minimumOffset_", declaredType="ADDRESS")
	public VoidPointer minimum() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(AddressIterator._minimumOffset_));
	}

	// ADDRESS minimum
	public PointerPointer minimumEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(AddressIterator._minimumOffset_));
	}

	// ADDRESS next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="ADDRESS")
	public VoidPointer next() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(AddressIterator._nextOffset_));
	}

	// ADDRESS next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(AddressIterator._nextOffset_));
	}

}
