/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_ConcurrentSweepStats
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_ConcurrentSweepStats {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __completeConnectPhaseBytesConnectedOffset_;
	public static final int __completeConnectPhaseTimeEndOffset_;
	public static final int __completeConnectPhaseTimeStartOffset_;
	public static final int __completeSweepPhaseBytesSweptOffset_;
	public static final int __completeSweepPhaseTimeEndOffset_;
	public static final int __completeSweepPhaseTimeStartOffset_;
	public static final int __concurrentCompleteSweepBytesSweptOffset_;
	public static final int __concurrentCompleteSweepTimeEndOffset_;
	public static final int __concurrentCompleteSweepTimeStartOffset_;
	public static final int __minimumFreeEntryBytesConnectedOffset_;
	public static final int __minimumFreeEntryBytesSweptOffset_;
	public static final int __modeOffset_;
	public static final int __totalChunkCountOffset_;
	public static final int __totalChunkSweptCountOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__completeConnectPhaseBytesConnectedOffset_ = 0;
		__completeConnectPhaseTimeEndOffset_ = 0;
		__completeConnectPhaseTimeStartOffset_ = 0;
		__completeSweepPhaseBytesSweptOffset_ = 0;
		__completeSweepPhaseTimeEndOffset_ = 0;
		__completeSweepPhaseTimeStartOffset_ = 0;
		__concurrentCompleteSweepBytesSweptOffset_ = 0;
		__concurrentCompleteSweepTimeEndOffset_ = 0;
		__concurrentCompleteSweepTimeStartOffset_ = 0;
		__minimumFreeEntryBytesConnectedOffset_ = 0;
		__minimumFreeEntryBytesSweptOffset_ = 0;
		__modeOffset_ = 0;
		__totalChunkCountOffset_ = 0;
		__totalChunkSweptCountOffset_ = 0;
	}

}
