/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2020 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fa extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_SK = "\u0627\u0633\u0644\u0648\u0627\u06a9\u06cc";
        final String metaValue_ae = "\u0627\u0648\u0633\u062a\u0627\u06cc\u06cc";
        final String metaValue_ar = "\u0639\u0631\u0628\u06cc";
        final String metaValue_bn = "\u0628\u0646\u06af\u0627\u0644\u06cc";
        final String metaValue_bo = "\u062a\u0628\u062a\u06cc";
        final String metaValue_el = "\u06cc\u0648\u0646\u0627\u0646\u06cc";
        final String metaValue_gu = "\u06af\u062c\u0631\u0627\u062a\u06cc";
        final String metaValue_he = "\u0639\u0628\u0631\u06cc";
        final String metaValue_hy = "\u0627\u0631\u0645\u0646\u06cc";
        final String metaValue_ja = "\u0698\u0627\u067e\u0646\u06cc";
        final String metaValue_jv = "\u062c\u0627\u0648\u0647\u200c\u0627\u06cc";
        final String metaValue_ka = "\u06af\u0631\u062c\u06cc";
        final String metaValue_km = "\u062e\u0645\u0631\u06cc";
        final String metaValue_kn = "\u06a9\u0627\u0646\u0627\u0631\u0627";
        final String metaValue_ko = "\u06a9\u0631\u0647\u200c\u0627\u06cc";
        final String metaValue_la = "\u0644\u0627\u062a\u06cc\u0646";
        final String metaValue_lo = "\u0644\u0627\u0626\u0648\u0633\u06cc";
        final String metaValue_ml = "\u0645\u0627\u0644\u0627\u06cc\u0627\u0644\u0627\u0645\u06cc";
        final String metaValue_mn = "\u0645\u063a\u0648\u0644\u06cc";
        final String metaValue_si = "\u0633\u06cc\u0646\u0647\u0627\u0644\u06cc";
        final String metaValue_ta = "\u062a\u0627\u0645\u06cc\u0644\u06cc";
        final String metaValue_te = "\u062a\u0644\u0648\u06af\u0648\u06cc\u06cc";
        final String metaValue_th = "\u062a\u0627\u06cc\u0644\u0646\u062f\u06cc";
        final String metaValue_tl = "\u062a\u0627\u06af\u0627\u0644\u0648\u06af\u06cc";
        final String metaValue_ban = "\u0628\u0627\u0644\u06cc\u0627\u06cc\u06cc";
        final String metaValue_bug = "\u0628\u0648\u06af\u06cc\u0627\u06cc\u06cc";
        final String metaValue_cop = "\u0642\u0628\u0637\u06cc";
        final String metaValue_got = "\u06af\u0648\u062a\u06cc";
        final String metaValue_men = "\u0645\u0646\u062f\u0647\u200c\u0627\u06cc";
        final String metaValue_peo = "\u0641\u0627\u0631\u0633\u06cc \u0628\u0627\u0633\u062a\u0627\u0646";
        final String metaValue_phn = "\u0641\u0646\u06cc\u0642\u06cc";
        final String metaValue_syr = "\u0633\u0631\u06cc\u0627\u0646\u06cc";
        final String metaValue_uga = "\u0627\u0648\u06af\u0627\u0631\u06cc\u062a\u06cc";
        final String metaValue_vai = "\u0648\u06cc\u0627\u06cc\u06cc";
        final Object[][] data = new Object[][] {
            { "ksh", "\u06a9\u0648\u0644\u0634" },
            { "Ogam", "\u0627\u0648\u06af\u0627\u0645\u06cc" },
            { "mwl", "\u0645\u06cc\u0631\u0627\u0646\u062f\u06cc" },
            { "Zsym", "\u0639\u0644\u0627\u0626\u0645" },
            { "mwr", "\u0645\u0627\u0631\u0648\u0627\u0631\u06cc" },
            { "Tagb", "\u062a\u06af\u0628\u0646\u0648\u0627\u06cc\u06cc" },
            { "Zsye", "\u0627\u0645\u0648\u062c\u06cc" },
            { "ccp", "\u0686\u0627\u06a9\u0645\u0627" },
            { "egy", "\u0645\u0635\u0631\u06cc \u06a9\u0647\u0646" },
            { "raj", "\u0631\u0627\u062c\u0633\u062a\u0627\u0646\u06cc" },
            { "tem", "\u062a\u0645\u0646\u0647\u200c\u0627\u06cc" },
            { "teo", "\u062a\u0633\u0648\u06cc\u06cc" },
            { "rap", "\u0631\u0627\u067e\u0627\u0646\u0648\u06cc\u06cc" },
            { "ter", "\u062a\u0631\u0646\u0648" },
            { "AC", "\u062c\u0632\u0627\u06cc\u0631 \u0622\u0633\u0646\u0633\u06cc\u0648\u0646" },
            { "rar", "\u0631\u0627\u0631\u0648\u062a\u0648\u0646\u06af\u0627\u06cc\u06cc" },
            { "tet", "\u062a\u062a\u0648\u0645\u06cc" },
            { "AD", "\u0622\u0646\u062f\u0648\u0631\u0627" },
            { "AE", "\u0627\u0645\u0627\u0631\u0627\u062a \u0645\u062a\u062d\u062f\u0647\u0654 \u0639\u0631\u0628\u06cc" },
            { "nl_BE", "\u0641\u0644\u0645\u0646\u06af\u06cc" },
            { "AF", "\u0627\u0641\u063a\u0627\u0646\u0633\u062a\u0627\u0646" },
            { "AG", "\u0622\u0646\u062a\u06cc\u06af\u0648\u0627 \u0648 \u0628\u0627\u0631\u0628\u0648\u062f\u0627" },
            { "type.ca.ethiopic", "\u062a\u0642\u0648\u06cc\u0645 \u0627\u062a\u06cc\u0648\u067e\u06cc\u0627\u06cc\u06cc" },
            { "glk", "\u06af\u06cc\u0644\u06a9\u06cc" },
            { "AI", "\u0622\u0646\u06af\u0648\u06cc\u0644\u0627" },
            { "key.tz", "\u0645\u0646\u0637\u0642\u0647\u0654 \u0632\u0645\u0627\u0646\u06cc" },
            { "AL", "\u0622\u0644\u0628\u0627\u0646\u06cc" },
            { "AM", "\u0627\u0631\u0645\u0646\u0633\u062a\u0627\u0646" },
            { "Teng", "\u062a\u0646\u06af\u0648\u0627\u0631" },
            { "AO", "\u0622\u0646\u06af\u0648\u0644\u0627" },
            { "AQ", "\u062c\u0646\u0648\u0628\u06af\u0627\u0646" },
            { "AR", "\u0622\u0631\u0698\u0627\u0646\u062a\u06cc\u0646" },
            { "Prti", "\u067e\u0627\u0631\u062a\u06cc \u06a9\u062a\u06cc\u0628\u0647\u200c\u0627\u06cc" },
            { "AS", "\u0633\u0627\u0645\u0648\u0622\u06cc \u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "AT", "\u0627\u062a\u0631\u06cc\u0634" },
            { "AU", "\u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627" },
            { "AW", "\u0622\u0631\u0648\u0628\u0627" },
            { "en_US", "\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc \u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "AX", "\u062c\u0632\u0627\u06cc\u0631 \u0622\u0644\u0627\u0646\u062f" },
            { "AZ", "\u062c\u0645\u0647\u0648\u0631\u06cc \u0622\u0630\u0631\u0628\u0627\u06cc\u062c\u0627\u0646" },
            { "%%AREVELA", "\u0627\u0631\u0645\u0646\u06cc \u0634\u0631\u0642\u06cc" },
            { "BA", "\u0628\u0648\u0633\u0646\u06cc \u0648 \u0647\u0631\u0632\u06af\u0648\u06cc\u0646" },
            { "BB", "\u0628\u0627\u0631\u0628\u0627\u062f\u0648\u0633" },
            { "ceb", "\u0633\u0628\u0648\u06cc\u06cc" },
            { "BD", "\u0628\u0646\u06af\u0644\u0627\u062f\u0634" },
            { "kum", "\u06a9\u0648\u0645\u06cc\u06a9\u06cc" },
            { "BE", "\u0628\u0644\u0698\u06cc\u06a9" },
            { "gmh", "\u0622\u0644\u0645\u0627\u0646\u06cc \u0645\u0639\u06cc\u0627\u0631 \u0645\u06cc\u0627\u0646\u0647" },
            { "BF", "\u0628\u0648\u0631\u06a9\u06cc\u0646\u0627\u0641\u0627\u0633\u0648" },
            { "BG", "\u0628\u0644\u063a\u0627\u0631\u0633\u062a\u0627\u0646" },
            { "BH", "\u0628\u062d\u0631\u06cc\u0646" },
            { "BI", "\u0628\u0648\u0631\u0648\u0646\u062f\u06cc" },
            { "BJ", "\u0628\u0646\u06cc\u0646" },
            { "BL", "\u0633\u0646 \u0628\u0627\u0631\u062a\u0644\u0645\u06cc" },
            { "BM", "\u0628\u0631\u0645\u0648\u062f\u0627" },
            { "kut", "\u06a9\u0648\u062a\u0646\u06cc" },
            { "myv", "\u0627\u0631\u0632\u06cc\u0627\u06cc\u06cc" },
            { "BN", "\u0628\u0631\u0648\u0646\u0626\u06cc" },
            { "BO", "\u0628\u0648\u0644\u06cc\u0648\u06cc" },
            { "BQ", "\u062c\u0632\u0627\u06cc\u0631 \u06a9\u0627\u0631\u0627\u0626\u06cc\u0628 \u0647\u0644\u0646\u062f" },
            { "BR", "\u0628\u0631\u0632\u06cc\u0644" },
            { "BS", "\u0628\u0627\u0647\u0627\u0645\u0627" },
            { "xog", "\u0633\u0648\u06af\u0627\u06cc\u06cc" },
            { "BT", "\u0628\u0648\u062a\u0627\u0646" },
            { "BV", "\u062c\u0632\u06cc\u0631\u0647\u0654 \u0628\u0648\u0648\u0647" },
            { "BW", "\u0628\u0648\u062a\u0633\u0648\u0627\u0646\u0627" },
            { "BY", "\u0628\u0644\u0627\u0631\u0648\u0633" },
            { "BZ", "\u0628\u0644\u06cc\u0632" },
            { "Visp", "\u06af\u0641\u062a\u0627\u0631 \u0642\u0627\u0628\u0644 \u0645\u0634\u0627\u0647\u062f\u0647" },
            { "type.ca.persian", "\u062a\u0642\u0648\u06cc\u0645 \u0647\u062c\u0631\u06cc \u0634\u0645\u0633\u06cc" },
            { "type.nu.hebr", "\u0627\u0639\u062f\u0627\u062f \u0639\u0628\u0631\u06cc" },
            { "CA", "\u06a9\u0627\u0646\u0627\u062f\u0627" },
            { "CC", "\u062c\u0632\u0627\u06cc\u0631 \u06a9\u0648\u06a9\u0648\u0633" },
            { "mzn", "\u0645\u0627\u0632\u0646\u062f\u0631\u0627\u0646\u06cc" },
            { "CD", "\u06a9\u0646\u06af\u0648 - \u06a9\u06cc\u0646\u0634\u0627\u0633\u0627" },
            { "CF", "\u062c\u0645\u0647\u0648\u0631\u06cc \u0627\u0641\u0631\u06cc\u0642\u0627\u06cc \u0645\u0631\u06a9\u0632\u06cc" },
            { "CG", "\u06a9\u0646\u06af\u0648 - \u0628\u0631\u0627\u0632\u0648\u06cc\u0644" },
            { "CH", "\u0633\u0648\u0626\u06cc\u0633" },
            { "CI", "\u0633\u0627\u062d\u0644 \u0639\u0627\u062c" },
            { "CK", "\u062c\u0632\u0627\u06cc\u0631 \u06a9\u0648\u06a9" },
            { "CL", "\u0634\u06cc\u0644\u06cc" },
            { "Kthi", "\u06a9\u062b\u06cc" },
            { "CM", "\u06a9\u0627\u0645\u0631\u0648\u0646" },
            { "CN", "\u0686\u06cc\u0646" },
            { "CO", "\u06a9\u0644\u0645\u0628\u06cc\u0627" },
            { "CP", "\u062c\u0632\u0627\u06cc\u0631 \u06a9\u0644\u06cc\u067e\u0631\u062a\u0648\u0646" },
            { "CR", "\u06a9\u0627\u0633\u062a\u0627\u0631\u06cc\u06a9\u0627" },
            { "CU", "\u06a9\u0648\u0628\u0627" },
            { "CV", "\u06a9\u06cc\u067e\u200c\u0648\u0631\u062f" },
            { "CW", "\u06a9\u0648\u0631\u0627\u0633\u0627\u0626\u0648" },
            { "CX", "\u062c\u0632\u06cc\u0631\u0647\u0654 \u06a9\u0631\u06cc\u0633\u0645\u0633" },
            { "CY", "\u0642\u0628\u0631\u0633" },
            { "type.nu.bali", "\u0627\u0631\u0642\u0627\u0645 \u0628\u0627\u0644\u06cc\u0627\u06cc\u06cc" },
            { "CZ", "\u0686\u06a9" },
            { "eka", "\u0627\u06a9\u0627\u062c\u0648\u06a9" },
            { "DE", "\u0622\u0644\u0645\u0627\u0646" },
            { "goh", "\u0622\u0644\u0645\u0627\u0646\u06cc \u0639\u0644\u06cc\u0627\u06cc \u0628\u0627\u0633\u062a\u0627\u0646" },
            { "ace", "\u0622\u0686\u0626\u06cc" },
            { "cgg", "\u0686\u06cc\u06af\u0627" },
            { "DG", "\u062f\u06cc\u0647\u200c\u06af\u0648 \u06af\u0627\u0631\u0633\u06cc\u0627" },
            { "type.nu.deva", "\u0627\u0631\u0642\u0627\u0645 \u062f\u0648\u0646\u0627\u06af\u0631\u06cc" },
            { "DJ", "\u062c\u06cc\u0628\u0648\u062a\u06cc" },
            { "DK", "\u062f\u0627\u0646\u0645\u0627\u0631\u06a9" },
            { "ach", "\u0622\u0686\u0648\u0644\u06cc\u0627\u06cc\u06cc" },
            { "gon", "\u06af\u0648\u0646\u062f\u06cc" },
            { "Brai", "\u0628\u0631\u06cc\u0644" },
            { "Brah", "\u0628\u0631\u0627\u0647\u0645\u06cc" },
            { "DM", "\u062f\u0648\u0645\u06cc\u0646\u06cc\u06a9\u0627" },
            { "type.nu.armnlow", "\u0627\u0639\u062f\u0627\u062f \u0627\u0631\u0645\u0646\u06cc \u0628\u0627 \u062d\u0631\u0648\u0641 \u06a9\u0648\u0686\u06a9" },
            { "DO", "\u062c\u0645\u0647\u0648\u0631\u06cc \u062f\u0648\u0645\u06cc\u0646\u06cc\u06a9\u0646" },
            { "gor", "\u06af\u0648\u0631\u0648\u0646\u062a\u0627\u0644\u0648" },
            { "got", metaValue_got },
            { "Mtei", "\u0645\u0627\u06cc\u06a9 \u0645\u06cc\u062a\u06cc" },
            { "zun", "\u0632\u0648\u0646\u06cc\u0627\u06cc\u06cc" },
            { "tig", "\u062a\u06cc\u06af\u0631\u0647\u200c\u0627\u06cc" },
            { "DZ", "\u0627\u0644\u062c\u0632\u0627\u06cc\u0631" },
            { "pag", "\u067e\u0627\u0646\u06af\u0627\u0633\u06cc\u0646\u0627\u0646\u06cc" },
            { "type.d0.hwidth", "\u0646\u06cc\u0645\u200c\u0639\u0631\u0636" },
            { "pal", "\u067e\u0647\u0644\u0648\u06cc" },
            { "EA", "\u0633\u0628\u062a\u0647 \u0648 \u0645\u0644\u06cc\u0644\u0647" },
            { "chb", "\u0686\u06cc\u0628\u0686\u0627" },
            { "pam", "\u067e\u0627\u0645\u067e\u0627\u0646\u06af\u0627\u06cc\u06cc" },
            { "EC", "\u0627\u06a9\u0648\u0627\u062f\u0648\u0631" },
            { "pap", "\u067e\u0627\u067e\u06cc\u0627\u0645\u0646\u062a\u0648" },
            { "ada", "\u0622\u062f\u0627\u0646\u06af\u0645\u0647\u200c\u0627\u06cc" },
            { "EE", "\u0627\u0633\u062a\u0648\u0646\u06cc" },
            { "tiv", "\u062a\u06cc\u0648\u06cc" },
            { "EG", "\u0645\u0635\u0631" },
            { "EH", "\u0635\u062d\u0631\u0627\u06cc \u063a\u0631\u0628\u06cc" },
            { "chg", "\u062c\u063a\u062a\u0627\u06cc\u06cc" },
            { "pau", "\u067e\u0627\u0644\u0627\u0626\u0648\u06cc\u06cc" },
            { "chk", "\u0686\u0648\u06a9\u06cc" },
            { "chm", "\u0645\u0627\u0631\u06cc\u0627\u06cc\u06cc" },
            { "chp", "\u0686\u06cc\u067e\u0647\u200c\u0648\u06cc\u0647\u200c\u0627\u06cc" },
            { "cho", "\u0686\u0648\u06a9\u062a\u0648\u06cc\u06cc" },
            { "type.nu.mathbold", "\u0627\u0631\u0642\u0627\u0645 \u0631\u06cc\u0627\u0636\u06cc \u0633\u06cc\u0627\u0647" },
            { "chr", "\u0686\u0631\u0648\u06a9\u06cc" },
            { "ER", "\u0627\u0631\u06cc\u062a\u0631\u0647" },
            { "ES", "\u0627\u0633\u067e\u0627\u0646\u06cc\u0627" },
            { "ET", "\u0627\u062a\u06cc\u0648\u067e\u06cc" },
            { "EU", "\u0627\u062a\u062d\u0627\u062f\u06cc\u0647\u0654 \u0627\u0631\u0648\u067e\u0627" },
            { "elx", "\u0639\u06cc\u0644\u0627\u0645\u06cc" },
            { "type.ca.gregorian", "\u062a\u0642\u0648\u06cc\u0645 \u0645\u06cc\u0644\u0627\u062f\u06cc" },
            { "EZ", "\u0645\u0646\u0637\u0642\u0647\u0654 \u06cc\u0648\u0631\u0648" },
            { "chy", "\u0634\u0627\u06cc\u0627\u0646\u06cc" },
            { "type.nu.gujr", "\u0627\u0631\u0642\u0627\u0645 \u06af\u062c\u0631\u0627\u062a\u06cc" },
            { "Inds", "\u0627\u06cc\u0646\u062f\u0648\u0633" },
            { "ady", "\u0622\u062f\u06cc\u062c\u06cc\u0627\u06cc\u06cc" },
            { "aeb", "\u0639\u0631\u0628\u06cc \u062a\u0648\u0646\u0633\u06cc" },
            { "FI", "\u0641\u0646\u0644\u0627\u0646\u062f" },
            { "FJ", "\u0641\u06cc\u062c\u06cc" },
            { "FK", "\u062c\u0632\u0627\u06cc\u0631 \u0641\u0627\u0644\u06a9\u0644\u0646\u062f" },
            { "FM", "\u0645\u06cc\u06a9\u0631\u0648\u0646\u0632\u06cc" },
            { "key.va", "\u0645\u062a\u063a\u06cc\u0631 \u0645\u062d\u0644\u06cc" },
            { "FO", "\u062c\u0632\u0627\u06cc\u0631 \u0641\u0627\u0631\u0648" },
            { "Taml", metaValue_ta },
            { "FR", "\u0641\u0631\u0627\u0646\u0633\u0647" },
            { "grb", "\u06af\u0631\u06cc\u0628\u0648\u06cc\u06cc" },
            { "type.ca.indian", "\u062a\u0642\u0648\u06cc\u0645 \u0645\u0644\u06cc \u0647\u0646\u062f" },
            { "grc", "\u06cc\u0648\u0646\u0627\u0646\u06cc \u06a9\u0647\u0646" },
            { "GA", "\u06af\u0627\u0628\u0646" },
            { "vot", "\u0648\u062a\u06cc" },
            { "GB", "\u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627" },
            { "pcm", "\u0646\u06cc\u0645\u200c\u0632\u0628\u0627\u0646 \u0646\u06cc\u062c\u0631\u06cc\u0647\u200c\u0627\u06cc" },
            { "GD", "\u06af\u0631\u0646\u0627\u062f\u0627" },
            { "GE", "\u06af\u0631\u062c\u0633\u062a\u0627\u0646" },
            { "GF", "\u06af\u0648\u06cc\u0627\u0646 \u0641\u0631\u0627\u0646\u0633\u0647" },
            { "GG", "\u06af\u0631\u0646\u0632\u06cc" },
            { "GH", "\u063a\u0646\u0627" },
            { "GI", "\u062c\u0628\u0644\u200c\u0627\u0644\u0637\u0627\u0631\u0642" },
            { "afh", "\u0622\u0641\u0631\u06cc\u0647\u06cc\u0644\u06cc" },
            { "GL", "\u06af\u0631\u06cc\u0646\u0644\u0646\u062f" },
            { "enm", "\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc \u0645\u06cc\u0627\u0646\u0647" },
            { "GM", "\u06af\u0627\u0645\u0628\u06cc\u0627" },
            { "GN", "\u06af\u06cc\u0646\u0647" },
            { "GP", "\u06af\u0648\u0627\u062f\u0644\u0648\u067e" },
            { "GQ", "\u06af\u06cc\u0646\u0647\u0654 \u0627\u0633\u062a\u0648\u0627\u06cc\u06cc" },
            { "GR", "\u06cc\u0648\u0646\u0627\u0646" },
            { "GS", "\u062c\u0648\u0631\u062c\u06cc\u0627\u06cc \u062c\u0646\u0648\u0628\u06cc \u0648 \u062c\u0632\u0627\u06cc\u0631 \u0633\u0627\u0646\u062f\u0648\u06cc\u0686 \u062c\u0646\u0648\u0628\u06cc" },
            { "GT", "\u06af\u0648\u0627\u062a\u0645\u0627\u0644\u0627" },
            { "GU", "\u06af\u0648\u0627\u0645" },
            { "pdc", "\u0622\u0644\u0645\u0627\u0646\u06cc \u067e\u0646\u0633\u06cc\u0644\u0648\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "GW", "\u06af\u06cc\u0646\u0647\u0654 \u0628\u06cc\u0633\u0627\u0626\u0648" },
            { "tli", "\u062a\u0644\u06cc\u0646\u200c\u06af\u06cc\u062a\u06cc" },
            { "tlh", "\u06a9\u0644\u06cc\u0646\u06af\u0648\u0646" },
            { "GY", "\u06af\u0648\u06cc\u0627\u0646" },
            { "ckb", "\u06a9\u0631\u062f\u06cc \u0645\u0631\u06a9\u0632\u06cc" },
            { "zxx", "\u0628\u062f\u0648\u0646 \u0645\u062d\u062a\u0648\u0627\u06cc \u0632\u0628\u0627\u0646\u06cc" },
            { "de_AT", "\u0622\u0644\u0645\u0627\u0646\u06cc \u0627\u062a\u0631\u06cc\u0634" },
            { "Vaii", metaValue_vai },
            { "HK", "\u0647\u0646\u06af\u200c\u06a9\u0646\u06af\u060c \u0645\u0646\u0637\u0642\u0647\u0654 \u0648\u06cc\u0698\u0647\u0654 \u0627\u062f\u0627\u0631\u06cc \u0686\u06cc\u0646" },
            { "HM", "\u0647\u0631\u062f \u0648 \u062c\u0632\u0627\u06cc\u0631 \u0645\u06a9\u200c\u062f\u0648\u0646\u0627\u0644\u062f" },
            { "HN", "\u0647\u0646\u062f\u0648\u0631\u0627\u0633" },
            { "HR", "\u06a9\u0631\u0648\u0627\u0633\u06cc" },
            { "agq", "\u0622\u06af\u06cc\u0645" },
            { "gsw", "\u0622\u0644\u0645\u0627\u0646\u06cc \u0633\u0648\u0626\u06cc\u0633\u06cc" },
            { "type.ca.islamic-umalqura", "\u062a\u0642\u0648\u06cc\u0645 \u0647\u062c\u0631\u06cc \u0642\u0645\u0631\u06cc \u0627\u0645\u200c\u0627\u0644\u0642\u0631\u06cc" },
            { "HT", "\u0647\u0627\u0626\u06cc\u062a\u06cc" },
            { "HU", "\u0645\u062c\u0627\u0631\u0633\u062a\u0627\u0646" },
            { "tmh", "\u062a\u0627\u0645\u0627\u0634\u0642\u06cc" },
            { "IC", "\u062c\u0632\u0627\u06cc\u0631 \u0642\u0646\u0627\u0631\u06cc" },
            { "peo", metaValue_peo },
            { "ID", "\u0627\u0646\u062f\u0648\u0646\u0632\u06cc" },
            { "IE", "\u0627\u06cc\u0631\u0644\u0646\u062f" },
            { "nap", "\u0646\u0627\u067e\u0644\u06cc" },
            { "naq", "\u0646\u0627\u0645\u0627\u06cc\u06cc" },
            { "zza", "\u0632\u0627\u0632\u0627\u06cc\u06cc" },
            { "IL", "\u0627\u0633\u0631\u0627\u0626\u06cc\u0644" },
            { "Nbat", "\u0646\u0628\u0637\u06cc" },
            { "IM", "\u062c\u0632\u06cc\u0631\u0647\u0654 \u0645\u0646" },
            { "IN", "\u0647\u0646\u062f" },
            { "type.co.eor", "\u0642\u0648\u0627\u0646\u06cc\u0646 \u062a\u0631\u062a\u06cc\u0628 \u0627\u0631\u0648\u067e\u0627\u06cc\u06cc" },
            { "IO", "\u0642\u0644\u0645\u0631\u0648 \u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627 \u062f\u0631 \u0627\u0642\u06cc\u0627\u0646\u0648\u0633 \u0647\u0646\u062f" },
            { "IQ", "\u0639\u0631\u0627\u0642" },
            { "IR", "\u0627\u06cc\u0631\u0627\u0646" },
            { "IS", "\u0627\u06cc\u0633\u0644\u0646\u062f" },
            { "IT", "\u0627\u06cc\u062a\u0627\u0644\u06cc\u0627" },
            { "Zmth", "\u0639\u0644\u0627\u0626\u0645 \u0631\u06cc\u0627\u0636\u06cc" },
            { "type.nu.thai", "\u0627\u0631\u0642\u0627\u0645 \u062a\u0627\u06cc\u0644\u0646\u062f\u06cc" },
            { "%%POSIX", "\u06a9\u0627\u0645\u067e\u06cc\u0648\u062a\u0631\u06cc" },
            { "type.nu.beng", "\u0627\u0631\u0642\u0627\u0645 \u0628\u0646\u06af\u0627\u0644\u06cc" },
            { "type.nu.cyrl", "\u0627\u0631\u0642\u0627\u0645 \u0633\u06cc\u0631\u06cc\u0644\u06cc\u06a9" },
            { "JE", "\u062c\u0631\u0632\u06cc" },
            { "type.ca.islamic", "\u062a\u0642\u0648\u06cc\u0645 \u0647\u062c\u0631\u06cc \u0642\u0645\u0631\u06cc" },
            { "Beng", metaValue_bn },
            { "JM", "\u062c\u0627\u0645\u0627\u0626\u06cc\u06a9\u0627" },
            { "JO", "\u0627\u0631\u062f\u0646" },
            { "JP", "\u0698\u0627\u067e\u0646" },
            { "ain", "\u0622\u06cc\u0646\u0648\u06cc\u06cc" },
            { "guz", "\u06af\u0648\u0633\u06cc" },
            { "tog", "\u062a\u0648\u0646\u06af\u0627\u06cc\u06cc \u0646\u06cc\u0627\u0633\u0627" },
            { "type.nu.knda", "\u0627\u0631\u0642\u0627\u0645 \u06a9\u0627\u0646\u0627\u062f\u0647\u200c\u0627\u06cc" },
            { "Kali", "\u06a9\u0627\u06cc\u0627\u0644\u06cc" },
            { "de_CH", "\u0622\u0644\u0645\u0627\u0646\u06cc \u0645\u0639\u06cc\u0627\u0631 \u0633\u0648\u0626\u06cc\u0633" },
            { "type.co.phonetic", "\u0645\u0631\u062a\u0628 \u06a9\u0631\u062f\u0646 \u0628\u0631 \u0627\u0633\u0627\u0633 \u0622\u0648\u0627\u06cc\u06cc" },
            { "type.ca.buddhist", "\u062a\u0642\u0648\u06cc\u0645 \u0628\u0648\u062f\u0627\u06cc\u06cc" },
            { "KE", "\u06a9\u0646\u06cc\u0627" },
            { "419", "\u0627\u0645\u0631\u06cc\u06a9\u0627\u06cc \u0644\u0627\u062a\u06cc\u0646" },
            { "KG", "\u0642\u0631\u0642\u06cc\u0632\u0633\u062a\u0627\u0646" },
            { "KH", "\u06a9\u0627\u0645\u0628\u0648\u062c" },
            { "KI", "\u06a9\u06cc\u0631\u06cc\u0628\u0627\u062a\u06cc" },
            { "KM", "\u06a9\u0648\u0645\u0648\u0631" },
            { "Knda", metaValue_kn },
            { "KN", "\u0633\u0646\u062a \u06a9\u06cc\u062a\u0633 \u0648 \u0646\u0648\u06cc\u0633" },
            { "Zinh", "\u0645\u0648\u0631\u0648\u062b\u06cc" },
            { "fr_CA", "\u0641\u0631\u0627\u0646\u0633\u0648\u06cc \u06a9\u0627\u0646\u0627\u062f\u0627" },
            { "KP", "\u06a9\u0631\u0647\u0654 \u0634\u0645\u0627\u0644\u06cc" },
            { "KR", "\u06a9\u0631\u0647\u0654 \u062c\u0646\u0648\u0628\u06cc" },
            { "fr_CH", "\u0641\u0631\u0627\u0646\u0633\u0648\u06cc \u0633\u0648\u0626\u06cc\u0633" },
            { "KW", "\u06a9\u0648\u06cc\u062a" },
            { "tpi", "\u062a\u0648\u06a9\u200c\u067e\u06cc\u0633\u06cc\u0646\u06cc" },
            { "KY", "\u062c\u0632\u0627\u06cc\u0631 \u06a9\u0650\u06cc\u0645\u0646" },
            { "KZ", "\u0642\u0632\u0627\u0642\u0633\u062a\u0627\u0646" },
            { "Cyrl", "\u0633\u06cc\u0631\u06cc\u0644\u06cc" },
            { "LA", "\u0644\u0627\u0626\u0648\u0633" },
            { "LB", "\u0644\u0628\u0646\u0627\u0646" },
            { "phn", metaValue_phn },
            { "LC", "\u0633\u0646\u062a \u0644\u0648\u0633\u06cc\u0627" },
            { "gwi", "\u06af\u0648\u06cc\u0686 \u0627\u06cc\u0646" },
            { "nds", "\u0622\u0644\u0645\u0627\u0646\u06cc \u0633\u0641\u0644\u06cc" },
            { "LI", "\u0644\u06cc\u062e\u062a\u0646\u200c\u0627\u0634\u062a\u0627\u06cc\u0646" },
            { "LK", "\u0633\u0631\u06cc\u200c\u0644\u0627\u0646\u06a9\u0627" },
            { "akk", "\u0627\u06a9\u062f\u06cc" },
            { "cop", metaValue_cop },
            { "LR", "\u0644\u06cc\u0628\u0631\u06cc\u0627" },
            { "LS", "\u0644\u0633\u0648\u062a\u0648" },
            { "Phlv", "\u067e\u0647\u0644\u0648\u06cc \u06a9\u062a\u0627\u0628\u06cc" },
            { "LT", "\u0644\u06cc\u062a\u0648\u0627\u0646\u06cc" },
            { "LU", "\u0644\u0648\u06a9\u0632\u0627\u0645\u0628\u0648\u0631\u06af" },
            { "LV", "\u0644\u062a\u0648\u0646\u06cc" },
            { "Kana", "\u06a9\u0627\u062a\u0627\u06a9\u0627\u0646\u0627" },
            { "LY", "\u0644\u06cc\u0628\u06cc" },
            { "lad", "\u0644\u0627\u062f\u06cc\u0646\u0648" },
            { "vun", "\u0648\u0646\u062c\u0648" },
            { "akz", "\u0622\u0644\u0627\u0628\u0627\u0645\u0627\u06cc\u06cc" },
            { "lah", "\u0644\u0627\u0647\u0646\u062f\u0627" },
            { "lag", "\u0644\u0627\u0646\u06af\u06cc" },
            { "Thaa", "\u062a\u0627\u0646\u0627" },
            { "MA", "\u0645\u0631\u0627\u06a9\u0634" },
            { "MC", "\u0645\u0648\u0646\u0627\u06a9\u0648" },
            { "MD", "\u0645\u0648\u0644\u062f\u0627\u0648\u06cc" },
            { "ME", "\u0645\u0648\u0646\u062a\u0647\u200c\u0646\u06af\u0631\u0648" },
            { "MF", "\u0633\u0646\u062a \u0645\u0627\u0631\u062a\u06cc\u0646" },
            { "lam", "\u0644\u0627\u0645\u0628\u0627" },
            { "MG", "\u0645\u0627\u062f\u0627\u06af\u0627\u0633\u06a9\u0627\u0631" },
            { "Thai", metaValue_th },
            { "MH", "\u062c\u0632\u0627\u06cc\u0631 \u0645\u0627\u0631\u0634\u0627\u0644" },
            { "ale", "\u0622\u0644\u0626\u0648\u062a\u06cc" },
            { "type.nu.vaii", "\u0627\u0631\u0642\u0627\u0645 \u0648\u0627\u06cc\u06cc" },
            { "MK", "\u0645\u0642\u062f\u0648\u0646\u06cc\u0647\u0654 \u0634\u0645\u0627\u0644\u06cc" },
            { "ML", "\u0645\u0627\u0644\u06cc" },
            { "MM", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631 (\u0628\u0631\u0645\u0647)" },
            { "MN", "\u0645\u063a\u0648\u0644\u0633\u062a\u0627\u0646" },
            { "new", "\u0646\u0648\u0627\u0631\u06cc\u0627\u06cc\u06cc" },
            { "MO", "\u0645\u0627\u06a9\u0627\u0626\u0648\u060c \u0645\u0646\u0637\u0642\u0647\u0654 \u0648\u06cc\u0698\u0647\u0654 \u0627\u062f\u0627\u0631\u06cc \u0686\u06cc\u0646" },
            { "MP", "\u062c\u0632\u0627\u06cc\u0631 \u0645\u0627\u0631\u06cc\u0627\u0646\u0627\u06cc \u0634\u0645\u0627\u0644\u06cc" },
            { "MQ", "\u0645\u0627\u0631\u062a\u06cc\u0646\u06cc\u06a9" },
            { "MR", "\u0645\u0648\u0631\u06cc\u062a\u0627\u0646\u06cc" },
            { "MS", "\u0645\u0648\u0646\u062a\u200c\u0633\u0631\u0627\u062a" },
            { "MT", "\u0645\u0627\u0644\u062a" },
            { "type.m0.ungegn", "\u062a\u0631\u0627\u0646\u0648\u06cc\u0633\u06cc \u06af\u0631\u0648\u0647 \u0646\u0627\u0645\u200c\u0647\u0627\u06cc \u062c\u063a\u0631\u0627\u0641\u06cc\u0627\u06cc\u06cc \u0633\u0627\u0632\u0645\u0627\u0646 \u0645\u0644\u0644" },
            { "MU", "\u0645\u0648\u0631\u06cc\u0633" },
            { "alt", "\u0622\u0644\u062a\u0627\u06cc\u06cc \u062c\u0646\u0648\u0628\u06cc" },
            { "MV", "\u0645\u0627\u0644\u062f\u06cc\u0648" },
            { "MW", "\u0645\u0627\u0644\u0627\u0648\u06cc" },
            { "MX", "\u0645\u06a9\u0632\u06cc\u06a9" },
            { "type.ca.japanese", "\u062a\u0642\u0648\u06cc\u0645 \u0698\u0627\u067e\u0646\u06cc" },
            { "MY", "\u0645\u0627\u0644\u0632\u06cc" },
            { "MZ", "\u0645\u0648\u0632\u0627\u0645\u0628\u06cc\u06a9" },
            { "Phli", "\u067e\u0647\u0644\u0648\u06cc \u06a9\u062a\u06cc\u0628\u0647\u200c\u0627\u06cc" },
            { "NA", "\u0646\u0627\u0645\u06cc\u0628\u06cc\u0627" },
            { "202", "\u0627\u0641\u0631\u06cc\u0642\u0627\u06cc \u062c\u0646\u0648\u0628 \u0635\u062d\u0631\u0627" },
            { "type.ca.hebrew", "\u062a\u0642\u0648\u06cc\u0645 \u0639\u0628\u0631\u06cc" },
            { "type.co.dictionary", "\u062a\u0631\u062a\u06cc\u0628 \u0641\u0631\u0647\u0646\u06af \u0644\u063a\u062a" },
            { "NC", "\u06a9\u0627\u0644\u062f\u0648\u0646\u06cc\u0627\u06cc \u062c\u062f\u06cc\u062f" },
            { "NE", "\u0646\u06cc\u062c\u0631" },
            { "NF", "\u062c\u0632\u06cc\u0631\u0647\u0654 \u0646\u0648\u0631\u0641\u0648\u0644\u06a9" },
            { "NG", "\u0646\u06cc\u062c\u0631\u06cc\u0647" },
            { "trv", "\u062a\u0627\u0631\u0648\u06a9\u0648\u06cc\u06cc" },
            { "Phlp", "\u067e\u0647\u0644\u0648\u06cc \u0632\u0628\u0648\u0631\u06cc" },
            { "NI", "\u0646\u06cc\u06a9\u0627\u0631\u0627\u06af\u0648\u0626\u0647" },
            { "NL", "\u0647\u0644\u0646\u062f" },
            { "NO", "\u0646\u0631\u0648\u0698" },
            { "NP", "\u0646\u067e\u0627\u0644" },
            { "NR", "\u0646\u0627\u0626\u0648\u0631\u0648" },
            { "Phnx", metaValue_phn },
            { "NU", "\u0646\u06cc\u0648\u0626\u0647" },
            { "rof", "\u0631\u0648\u0645\u0628\u0648\u06cc\u06cc" },
            { "tsi", "\u062a\u0633\u06cc\u0645\u200c\u0634\u06cc\u0627\u0646\u06cc" },
            { "NZ", "\u0646\u06cc\u0648\u0632\u06cc\u0644\u0646\u062f" },
            { "%%COLB1945", "\u06a9\u0646\u0648\u0627\u0646\u0633\u06cc\u0648\u0646 \u0631\u0633\u0645\u200c\u0627\u0644\u062e\u0637 \u067e\u0631\u062a\u063a\u0627\u0644 \u0648 \u0628\u0631\u0632\u06cc\u0644 \u062f\u0631 \u06f1\u06f9\u06f4\u06f5" },
            { "rom", "\u0631\u0648\u0645\u0627\u0646\u0648\u06cc\u06cc" },
            { "Mero", "\u0645\u0631\u0648\u06cc\u06cc\u062a\u06cc" },
            { "crh", "\u062a\u0631\u06a9\u06cc \u06a9\u0631\u06cc\u0645\u0647" },
            { "ang", "\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc \u0628\u0627\u0633\u062a\u0627\u0646" },
            { "OM", "\u0639\u0645\u0627\u0646" },
            { "anp", "\u0622\u0646\u06af\u06cc\u06a9\u0627" },
            { "crs", "\u0633\u06cc\u0634\u0644 \u0622\u0645\u06cc\u062e\u062a\u0647\u0654 \u0641\u0631\u0627\u0646\u0633\u0648\u06cc" },
            { "Xpeo", metaValue_peo },
            { "PA", "\u067e\u0627\u0646\u0627\u0645\u0627" },
            { "type.ca.islamic-civil", "\u062a\u0642\u0648\u06cc\u0645 \u0647\u062c\u0631\u06cc \u0642\u0645\u0631\u06cc \u062c\u062f\u0648\u0644\u06cc \u0645\u062f\u0646\u06cc" },
            { "csb", "\u06a9\u0627\u0634\u0648\u0628\u06cc" },
            { "en_GB", "\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc \u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627" },
            { "PE", "\u067e\u0631\u0648" },
            { "PF", "\u067e\u0644\u06cc\u200c\u0646\u0632\u06cc \u0641\u0631\u0627\u0646\u0633\u0647" },
            { "PG", "\u067e\u0627\u067e\u0648\u0627 \u06af\u06cc\u0646\u0647\u0654 \u0646\u0648" },
            { "PH", "\u0641\u06cc\u0644\u06cc\u067e\u06cc\u0646" },
            { "PK", "\u067e\u0627\u06a9\u0633\u062a\u0627\u0646" },
            { "PL", "\u0644\u0647\u0633\u062a\u0627\u0646" },
            { "ewo", "\u0627\u0648\u0627\u0646\u062f\u0648" },
            { "PM", "\u0633\u0646 \u067e\u06cc\u0631 \u0648 \u0645\u06cc\u06a9\u0644\u0646" },
            { "PN", "\u062c\u0632\u0627\u06cc\u0631 \u067e\u06cc\u062a\u200c\u06a9\u0631\u0646" },
            { "PR", "\u067e\u0648\u0631\u062a\u0648\u0631\u06cc\u06a9\u0648" },
            { "Bali", metaValue_ban },
            { "PS", "\u0633\u0631\u0632\u0645\u06cc\u0646\u200c\u0647\u0627\u06cc \u0641\u0644\u0633\u0637\u06cc\u0646\u06cc" },
            { "PT", "\u067e\u0631\u062a\u063a\u0627\u0644" },
            { "PW", "\u067e\u0627\u0644\u0627\u0626\u0648" },
            { "nia", "\u0646\u06cc\u0627\u0633\u06cc" },
            { "type.nu.greklow", "\u0627\u0639\u062f\u0627\u062f \u06cc\u0648\u0646\u0627\u0646\u06cc \u0628\u0627 \u062d\u0631\u0648\u0641 \u06a9\u0648\u0686\u06a9" },
            { "PY", "\u067e\u0627\u0631\u0627\u06af\u0648\u0626\u0647" },
            { "tum", "\u062a\u0648\u0645\u0628\u0648\u06a9\u0627\u06cc\u06cc" },
            { "Hebr", metaValue_he },
            { "QA", "\u0642\u0637\u0631" },
            { "%%SCOTLAND", "\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc \u0645\u0639\u06cc\u0627\u0631 \u0627\u0633\u06a9\u0627\u062a\u0644\u0646\u062f" },
            { "niu", "\u0646\u06cc\u0648\u06cc\u06cc" },
            { "QO", "\u0628\u062e\u0634\u200c\u0647\u0627\u06cc \u062f\u0648\u0631\u0627\u0641\u062a\u0627\u062f\u0647\u0654 \u0627\u0642\u06cc\u0627\u0646\u0648\u0633\u06cc\u0647" },
            { "lez", "\u0644\u0632\u06af\u06cc" },
            { "%%FONUPA", "\u0641\u0648\u0646\u062a\u06cc\u06a9 UPA" },
            { "tvl", "\u062a\u0648\u0648\u0627\u0644\u0648\u06cc\u06cc" },
            { "001", "\u062c\u0647\u0627\u0646" },
            { "002", "\u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "003", "\u0627\u0645\u0631\u06cc\u06a9\u0627\u06cc \u0634\u0645\u0627\u0644\u06cc" },
            { "RE", "\u0631\u0626\u0648\u0646\u06cc\u0648\u0646" },
            { "005", "\u0627\u0645\u0631\u06cc\u06a9\u0627\u06cc \u062c\u0646\u0648\u0628\u06cc" },
            { "jbo", "\u0644\u0648\u062c\u0628\u0627\u0646" },
            { "Rjng", "\u0631\u062c\u0646\u06af\u06cc" },
            { "009", "\u0627\u0642\u06cc\u0627\u0646\u0648\u0633\u06cc\u0647" },
            { "RO", "\u0631\u0648\u0645\u0627\u0646\u06cc" },
            { "RS", "\u0635\u0631\u0628\u0633\u062a\u0627\u0646" },
            { "RU", "\u0631\u0648\u0633\u06cc\u0647" },
            { "RW", "\u0631\u0648\u0627\u0646\u062f\u0627" },
            { "Ugar", metaValue_uga },
            { "Mani", "\u0645\u0627\u0646\u0648\u06cc" },
            { "Mand", metaValue_men },
            { "SA", "\u0639\u0631\u0628\u0633\u062a\u0627\u0646 \u0633\u0639\u0648\u062f\u06cc" },
            { "pon", "\u067e\u0627\u0646\u067e\u06cc\u06cc" },
            { "SB", "\u062c\u0632\u0627\u06cc\u0631 \u0633\u0644\u06cc\u0645\u0627\u0646" },
            { "twq", "\u062a\u0633\u0648\u0627\u06a9\u06cc" },
            { "011", "\u063a\u0631\u0628 \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "SC", "\u0633\u06cc\u0634\u0644" },
            { "SD", "\u0633\u0648\u062f\u0627\u0646" },
            { "013", "\u0627\u0645\u0631\u06cc\u06a9\u0627\u06cc \u0645\u0631\u06a9\u0632\u06cc" },
            { "SE", "\u0633\u0648\u0626\u062f" },
            { "014", "\u0634\u0631\u0642 \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "arc", "\u0622\u0631\u0627\u0645\u06cc" },
            { "015", "\u0634\u0645\u0627\u0644 \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "SG", "\u0633\u0646\u06af\u0627\u067e\u0648\u0631" },
            { "SH", "\u0633\u0646\u062a \u0647\u0644\u0646" },
            { "type.lb.strict", "\u0634\u06cc\u0648\u0647\u0654 \u0633\u0637\u0631\u0634\u06a9\u0646\u06cc \u0633\u062e\u062a\u200c\u06af\u06cc\u0631\u0627\u0646\u0647" },
            { "017", "\u0645\u0631\u06a9\u0632 \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "SI", "\u0627\u0633\u0644\u0648\u0648\u0646\u06cc" },
            { "018", "\u062c\u0646\u0648\u0628 \u0627\u0641\u0631\u06cc\u0642\u0627" },
            { "SJ", "\u0633\u0648\u0627\u0644\u0628\u0627\u0631\u062f \u0648 \u06cc\u0627\u0646 \u0645\u0627\u06cc\u0646" },
            { "SK", metaValue_SK },
            { "019", "\u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "SL", "\u0633\u06cc\u0631\u0627\u0644\u0626\u0648\u0646" },
            { "SM", "\u0633\u0627\u0646\u200c\u0645\u0627\u0631\u06cc\u0646\u0648" },
            { "SN", "\u0633\u0646\u06af\u0627\u0644" },
            { "SO", "\u0633\u0648\u0645\u0627\u0644\u06cc" },
            { "arn", "\u0645\u0627\u067e\u0648\u0686\u0647\u200c\u0627\u06cc" },
            { "arp", "\u0622\u0631\u0627\u067e\u0627\u0647\u0648\u06cc\u06cc" },
            { "type.nu.taml", "\u0627\u0639\u062f\u0627\u062f \u0633\u0646\u062a\u06cc \u062a\u0627\u0645\u06cc\u0644\u06cc" },
            { "SR", "\u0633\u0648\u0631\u06cc\u0646\u0627\u0645" },
            { "SS", "\u0633\u0648\u062f\u0627\u0646 \u062c\u0646\u0648\u0628\u06cc" },
            { "ST", "\u0633\u0627\u0626\u0648\u062a\u0648\u0645\u0647 \u0648 \u067e\u0631\u06cc\u0646\u0633\u06cc\u067e" },
            { "arq", "\u0639\u0631\u0628\u06cc \u0627\u0644\u062c\u0632\u0627\u06cc\u0631\u06cc" },
            { "SV", "\u0627\u0644\u0633\u0627\u0644\u0648\u0627\u062f\u0648\u0631" },
            { "SX", "\u0633\u0646\u062a \u0645\u0627\u0631\u062a\u0646" },
            { "SY", "\u0633\u0648\u0631\u06cc\u0647" },
            { "yao", "\u06cc\u0627\u0626\u0648\u06cc\u06cc" },
            { "SZ", "\u0627\u0633\u0648\u0627\u062a\u06cc\u0646\u06cc" },
            { "arw", "\u0622\u0631\u0627\u0648\u0627\u06a9\u06cc" },
            { "arz", "\u0639\u0631\u0628\u06cc \u0645\u0635\u0631\u06cc" },
            { "ary", "\u0639\u0631\u0628\u06cc \u0645\u0631\u0627\u06a9\u0634\u06cc" },
            { "yap", "\u06cc\u0627\u067e\u06cc" },
            { "TA", "\u062a\u0631\u06cc\u0633\u062a\u0627\u0646 \u062f\u0627 \u06a9\u0648\u0646\u0627" },
            { "asa", "\u0622\u0633\u0648" },
            { "type.ms.ussystem", "\u0633\u06cc\u0633\u062a\u0645 \u0627\u0646\u062f\u0627\u0632\u0647\u200c\u06af\u06cc\u0631\u06cc \u0627\u0645\u0631\u06cc\u06a9\u0627\u06cc\u06cc" },
            { "021", "\u0634\u0645\u0627\u0644 \u0627\u0645\u0631\u06cc\u06a9\u0627" },
            { "TC", "\u062c\u0632\u0627\u06cc\u0631 \u062a\u0648\u0631\u06a9\u0633 \u0648 \u06a9\u0627\u06cc\u06a9\u0648\u0633" },
            { "yav", "\u06cc\u0627\u0646\u06af\u0628\u0646\u06cc" },
            { "TD", "\u0686\u0627\u062f" },
            { "TF", "\u0633\u0631\u0632\u0645\u06cc\u0646\u200c\u0647\u0627\u06cc \u062c\u0646\u0648\u0628 \u0641\u0631\u0627\u0646\u0633\u0647" },
            { "TG", "\u062a\u0648\u06af\u0648" },
            { "TH", "\u062a\u0627\u06cc\u0644\u0646\u062f" },
            { "TJ", "\u062a\u0627\u062c\u06cc\u06a9\u0633\u062a\u0627\u0646" },
            { "029", "\u06a9\u0627\u0631\u0627\u0626\u06cc\u0628" },
            { "TK", "\u062a\u0648\u06a9\u0644\u0627\u0626\u0648" },
            { "TL", "\u062a\u06cc\u0645\u0648\u0631-\u0644\u0633\u062a\u0647" },
            { "ybb", "\u06cc\u0645\u0628\u0627\u06cc\u06cc" },
            { "type.co.searchjl", "\u062c\u0633\u062a\u062c\u0648 \u0628\u0627 \u0635\u0627\u0645\u062a \u0627\u0648\u0644 \u0647\u0627\u0646\u06af\u0648\u0644" },
            { "TM", "\u062a\u0631\u06a9\u0645\u0646\u0633\u062a\u0627\u0646" },
            { "TN", "\u062a\u0648\u0646\u0633" },
            { "TO", "\u062a\u0648\u0646\u06af\u0627" },
            { "TR", "\u062a\u0631\u06a9\u06cc\u0647" },
            { "TT", "\u062a\u0631\u06cc\u0646\u06cc\u062f\u0627\u062f \u0648 \u062a\u0648\u0628\u0627\u06af\u0648" },
            { "TV", "\u062a\u0648\u0648\u0627\u0644\u0648" },
            { "TW", "\u062a\u0627\u06cc\u0648\u0627\u0646" },
            { "ast", "\u0622\u0633\u062a\u0648\u0631\u06cc" },
            { "Orkh", "\u0627\u0648\u0631\u062e\u0648\u0646\u06cc" },
            { "TZ", "\u062a\u0627\u0646\u0632\u0627\u0646\u06cc\u0627" },
            { "nmg", "\u06a9\u0648\u0627\u0632\u06cc\u0648" },
            { "Zzzz", "\u062e\u0637 \u0646\u0627\u0645\u0634\u062e\u0635" },
            { "UA", "\u0627\u0648\u06a9\u0631\u0627\u06cc\u0646" },
            { "rup", "\u0622\u0631\u0648\u0645\u0627\u0646\u06cc" },
            { "030", "\u0634\u0631\u0642 \u0622\u0633\u06cc\u0627" },
            { "tyv", "\u062a\u0648\u0648\u0627\u06cc\u06cc" },
            { "sw_CD", "\u0633\u0648\u0627\u062d\u06cc\u0644\u06cc \u06a9\u0646\u06af\u0648" },
            { "034", "\u062c\u0646\u0648\u0628 \u0622\u0633\u06cc\u0627" },
            { "hai", "\u0647\u0627\u06cc\u062f\u0627\u06cc\u06cc" },
            { "035", "\u062c\u0646\u0648\u0628 \u0634\u0631\u0642 \u0622\u0633\u06cc\u0627" },
            { "UG", "\u0627\u0648\u06af\u0627\u0646\u062f\u0627" },
            { "type.co.pinyin", "\u062a\u0631\u062a\u06cc\u0628 \u067e\u06cc\u0646\u200c\u06cc\u06cc\u0646" },
            { "039", "\u062c\u0646\u0648\u0628 \u0627\u0631\u0648\u067e\u0627" },
            { "Sinh", metaValue_si },
            { "UM", "\u062c\u0632\u0627\u06cc\u0631 \u062f\u0648\u0631\u0627\u0641\u062a\u0627\u062f\u0647\u0654 \u0627\u06cc\u0627\u0644\u0627\u062a \u0645\u062a\u062d\u062f\u0647" },
            { "UN", "\u0633\u0627\u0632\u0645\u0627\u0646 \u0645\u0644\u0644 \u0645\u062a\u062d\u062f" },
            { "US", "\u0627\u06cc\u0627\u0644\u0627\u062a \u0645\u062a\u062d\u062f\u0647" },
            { "haw", "\u0647\u0627\u0648\u0627\u06cc\u06cc" },
            { "type.co.gb2312han", "\u062a\u0631\u062a\u06cc\u0628 \u0686\u06cc\u0646\u06cc \u0633\u0627\u062f\u0647\u200c\u0634\u062f\u0647 - GB2312" },
            { "UY", "\u0627\u0631\u0648\u06af\u0648\u0626\u0647" },
            { "prg", "\u067e\u0631\u0648\u0633\u06cc" },
            { "UZ", "\u0627\u0632\u0628\u06a9\u0633\u062a\u0627\u0646" },
            { "tzm", "\u0622\u0645\u0627\u0632\u06cc\u063a\u06cc \u0627\u0637\u0644\u0633 \u0645\u0631\u06a9\u0632\u06cc" },
            { "type.co.stroke", "\u062a\u0631\u062a\u06cc\u0628 \u062d\u0631\u06a9\u062a\u06cc" },
            { "nnh", "\u0646\u06cc\u0627\u0645\u0628\u0648\u0646" },
            { "VA", "\u0648\u0627\u062a\u06cc\u06a9\u0627\u0646" },
            { "pro", "\u067e\u0631\u0648\u0648\u0627\u0646\u0633\u06cc \u0628\u0627\u0633\u062a\u0627\u0646" },
            { "VC", "\u0633\u0646\u062a \u0648\u06cc\u0646\u0633\u0646\u062a \u0648 \u06af\u0631\u0646\u0627\u062f\u06cc\u0646" },
            { "VE", "\u0648\u0646\u0632\u0648\u0626\u0644\u0627" },
            { "VG", "\u062c\u0632\u0627\u06cc\u0631 \u0648\u06cc\u0631\u062c\u06cc\u0646 \u0628\u0631\u06cc\u062a\u0627\u0646\u06cc\u0627" },
            { "VI", "\u062c\u0632\u0627\u06cc\u0631 \u0648\u06cc\u0631\u062c\u06cc\u0646 \u0627\u06cc\u0627\u0644\u0627\u062a \u0645\u062a\u062d\u062f\u0647" },
            { "VN", "\u0648\u06cc\u062a\u0646\u0627\u0645" },
            { "VU", "\u0648\u0627\u0646\u0648\u0627\u062a\u0648" },
            { "nog", "\u0646\u063a\u0627\u06cc\u06cc" },
            { "rwk", "\u0631\u0648\u0627\u06cc\u06cc" },
            { "non", "\u0646\u0631\u0633 \u0628\u0627\u0633\u062a\u0627\u0646" },
            { "053", "\u0627\u0633\u062a\u0631\u0627\u0644\u0632\u06cc" },
            { "%%AREVMDA", "\u0627\u0631\u0645\u0646\u06cc \u063a\u0631\u0628\u06cc" },
            { "054", "\u0645\u0644\u0627\u0646\u0632\u06cc" },
            { "WF", "\u0648\u0627\u0644\u06cc\u0633 \u0648 \u0641\u0648\u062a\u0648\u0646\u0627" },
            { "type.co.traditional", "\u062a\u0631\u062a\u06cc\u0628 \u0633\u0646\u062a\u06cc" },
            { "057", "\u0646\u0627\u062d\u06cc\u0647\u0654 \u0645\u06cc\u06a9\u0631\u0648\u0646\u0632\u06cc" },
            { "jgo", "\u0646\u06af\u0648\u0645\u0628\u0627" },
            { "lkt", "\u0644\u0627\u06a9\u0648\u062a\u0627" },
            { "type.nu.finance", "\u0633\u06cc\u0633\u062a\u0645 \u0639\u062f\u062f\u06cc \u0645\u0627\u0644\u06cc" },
            { "type.co.compat", "\u062a\u0631\u062a\u06cc\u0628 \u067e\u06cc\u0634\u06cc\u0646\u060c \u0628\u0631\u0627\u06cc \u0633\u0627\u0632\u06af\u0627\u0631\u06cc" },
            { "wae", "\u0648\u0627\u0644\u0633\u0631" },
            { "WS", "\u0633\u0627\u0645\u0648\u0622" },
            { "wal", "\u0648\u0627\u0644\u0627\u0645\u0648" },
            { "was", "\u0648\u0627\u0634\u0648\u06cc\u06cc" },
            { "XA", "\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc \u0628\u0627 \u0644\u0647\u062c\u0647 \u062e\u0627\u0631\u062c\u06cc" },
            { "war", "\u0648\u0627\u0631\u0627\u06cc\u06cc" },
            { "XB", "\u0645\u062c\u0627\u0632\u06cc - \u062f\u0648\u062c\u0647\u062a\u0647" },
            { "awa", "\u0627\u0648\u062f\u0647\u06cc" },
            { "061", "\u067e\u0644\u06cc\u200c\u0646\u0632\u06cc" },
            { "%%KSCOR", "\u0631\u0633\u0645\u200c\u0627\u0644\u062e\u0637 \u0627\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f" },
            { "XK", "\u06a9\u0648\u0632\u0648\u0648" },
            { "type.nu.brah", "\u0627\u0631\u0642\u0627\u0645 \u0628\u0631\u0647\u0645\u0627\u06cc\u06cc" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u0646\u0627\u0646\u0648\u0634\u062a\u0647" },
            { "wbp", "\u0648\u0627\u0631\u0644\u067e\u06cc\u0631\u06cc" },
            { "Batk", "\u0628\u0627\u062a\u0627\u06a9\u06cc" },
            { "Blis", "\u0646\u0645\u0627\u062f\u0647\u0627\u06cc \u0628\u0644\u06cc\u0633" },
            { "YE", "\u06cc\u0645\u0646" },
            { "nqo", "\u0646\u06a9\u0648" },
            { "type.co.standard", "\u062a\u0631\u062a\u06cc\u0628 \u0627\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f" },
            { "fan", "\u0641\u0627\u0646\u06af\u06cc" },
            { "%%ROZAJ", "\u0631\u0648\u0698\u0627\u0646" },
            { "fat", "\u0641\u0627\u0646\u062a\u06cc\u0627\u06cc\u06cc" },
            { "YT", "\u0645\u0627\u06cc\u0648\u062a" },
            { "ZA", "\u0627\u0641\u0631\u06cc\u0642\u0627\u06cc \u062c\u0646\u0648\u0628\u06cc" },
            { "type.lb.loose", "\u0634\u06cc\u0648\u0647\u0654 \u0633\u0637\u0631\u0634\u06a9\u0646\u06cc \u0633\u0647\u0644\u200c\u06af\u06cc\u0631\u0627\u0646\u0647" },
            { "Deva", "\u062f\u0648\u0646\u0627\u06af\u0631\u06cc" },
            { "type.nu.geor", "\u0627\u0639\u062f\u0627\u062f \u06af\u0631\u062c\u06cc" },
            { "type.co.zhuyin", "\u062a\u0631\u062a\u06cc\u0628 \u0698\u0648\u06cc\u06cc\u0646" },
            { "Hira", "\u0647\u06cc\u0631\u0627\u06af\u0627\u0646\u0627" },
            { "ZM", "\u0632\u0627\u0645\u0628\u06cc\u0627" },
            { "ZW", "\u0632\u06cc\u0645\u0628\u0627\u0628\u0648\u0647" },
            { "ZZ", "\u0646\u0627\u062d\u06cc\u0647\u0654 \u0646\u0627\u0645\u0634\u062e\u0635" },
            { "Runr", "\u0631\u0648\u0646\u06cc" },
            { "type.ms.metric", "\u062f\u0633\u062a\u06af\u0627\u0647 \u0645\u062a\u0631\u06cc\u06a9" },
            { "type.ca.iso8601", "\u062a\u0642\u0648\u06cc\u0645 \u0627\u06cc\u0632\u0648 \u06f8\u06f6\u06f0\u06f1" },
            { "lol", "\u0645\u0648\u0646\u06af\u0648\u06cc\u06cc" },
            { "nso", "\u0633\u0648\u062a\u0648\u06cc\u06cc \u0634\u0645\u0627\u0644\u06cc" },
            { "type.nu.telu", "\u0627\u0631\u0642\u0627\u0645 \u062a\u0644\u0648\u06af\u0648\u06cc\u06cc" },
            { "lou", "\u0632\u0628\u0627\u0646 \u0622\u0645\u06cc\u062e\u062a\u0647\u0654 \u0645\u0627\u062f\u0631\u06cc \u0644\u0648\u0626\u06cc\u0632\u06cc\u0627\u0646\u0627" },
            { "loz", "\u0644\u0648\u0632\u06cc\u0627\u06cc\u06cc" },
            { "jmc", "\u0645\u0627\u0686\u0627\u0645\u0647\u200c\u0627\u06cc" },
            { "hif", "\u0647\u0646\u062f\u06cc \u0641\u06cc\u062c\u06cc\u0627\u06cc\u06cc" },
            { "type.nu.hansfin", "\u0627\u0639\u062f\u0627\u062f \u0645\u0627\u0644\u06cc \u0686\u06cc\u0646\u06cc \u0633\u0627\u062f\u0647\u200c\u0634\u062f\u0647" },
            { "hil", "\u0647\u06cc\u0644\u06cc\u200c\u06af\u0627\u06cc\u0646\u0648\u0646\u06cc" },
            { "type.nu.arabext", "\u0627\u0631\u0642\u0627\u0645 \u0641\u0627\u0631\u0633\u06cc" },
            { "nus", "\u0646\u0648\u06cc\u0631" },
            { "dak", "\u062f\u0627\u06a9\u0648\u062a\u0627\u06cc\u06cc" },
            { "type.nu.fullwide", "\u0627\u0631\u0642\u0627\u0645 \u062a\u0645\u0627\u0645\u200c\u0639\u0631\u0636" },
            { "hit", "\u0647\u06cc\u062a\u06cc" },
            { "dar", "\u062f\u0627\u0631\u0642\u06cc\u0646\u06cc" },
            { "dav", "\u062a\u0627\u06cc\u062a\u0627" },
            { "Maya", "\u0647\u06cc\u0631\u0648\u06af\u0644\u06cc\u0641 \u0645\u0627\u06cc\u0627\u06cc\u06cc" },
            { "lrc", "\u0644\u0631\u06cc \u0634\u0645\u0627\u0644\u06cc" },
            { "type.co.emoji", "\u062a\u0631\u062a\u06cc\u0628 \u0627\u06cc\u0645\u0648\u062c\u06cc" },
            { "Copt", metaValue_cop },
            { "nwc", "\u0646\u0648\u0627\u0631\u06cc\u0627\u06cc\u06cc \u06a9\u0644\u0627\u0633\u06cc\u06a9" },
            { "udm", "\u0627\u0648\u062f\u0645\u0648\u0631\u062a\u06cc" },
            { "Khmr", metaValue_km },
            { "type.ca.islamic-rgsa", "\u0642\u0648\u06cc\u0645 \u0647\u062c\u0631\u06cc \u0642\u0645\u0631\u06cc \u0647\u0644\u0627\u0644\u06cc \u0639\u0631\u0628\u0633\u062a\u0627\u0646 \u0633\u0639\u0648\u062f\u06cc" },
            { "Limb", "\u0644\u06cc\u0645\u0628\u0627\u06cc\u06cc" },
            { "sad", "\u0633\u0627\u0646\u062f\u0627\u0648\u0647\u200c\u0627\u06cc" },
            { "type.nu.roman", "\u0627\u0639\u062f\u0627\u062f \u0631\u0648\u0645\u06cc" },
            { "sah", "\u06cc\u0627\u0642\u0648\u062a\u06cc" },
            { "sam", "\u0622\u0631\u0627\u0645\u06cc \u0633\u0627\u0645\u0631\u06cc" },
            { "Aghb", "\u0622\u0644\u0628\u0627\u0646\u06cc\u0627\u06cc\u06cc \u0642\u0641\u0642\u0627\u0632\u06cc" },
            { "saq", "\u0633\u0627\u0645\u0628\u0648\u0631\u0648" },
            { "sas", "\u0633\u0627\u0633\u0627\u06a9\u06cc" },
            { "sat", "\u0633\u0627\u0646\u062a\u0627\u0644\u06cc" },
            { "Tfng", "\u062a\u06cc\u0641\u06cc\u0646\u0627\u063a\u06cc" },
            { "jpr", "\u0641\u0627\u0631\u0633\u06cc \u06cc\u0647\u0648\u062f\u06cc" },
            { "type.d0.npinyin", "\u0633\u06cc\u0633\u062a\u0645 \u0627\u0639\u062f\u0627\u062f" },
            { "type.nu.native", "\u0627\u0631\u0642\u0627\u0645 \u0628\u0648\u0645\u06cc" },
            { "sba", "\u0627\u0646\u06af\u0627\u0645\u0628\u0627\u06cc\u06cc" },
            { "Guru", "\u06af\u0648\u0631\u0648\u0645\u062e\u06cc" },
            { "lua", "\u0644\u0648\u0628\u0627\u06cc\u06cc\u2010\u0644\u0648\u0644\u0648\u0627" },
            { "type.d0.fwidth", "\u062a\u0645\u0627\u0645\u200c\u0639\u0631\u0636" },
            { "sbp", "\u0633\u0627\u0646\u06af\u0648\u06cc\u06cc" },
            { "lui", "\u0644\u0648\u06cc\u0633\u0646\u0648" },
            { "nyn", "\u0646\u06cc\u0627\u0646\u06a9\u0648\u0644\u0647\u200c\u0627\u06cc" },
            { "nym", "\u0646\u06cc\u0627\u0645\u200c\u0648\u0632\u06cc\u0627\u06cc\u06cc" },
            { "lun", "\u0644\u0648\u0646\u062f\u0627\u06cc\u06cc" },
            { "nyo", "\u0646\u06cc\u0648\u0631\u0648\u06cc\u06cc" },
            { "luo", "\u0644\u0648\u0626\u0648\u06cc\u06cc" },
            { "fil", "\u0641\u06cc\u0644\u06cc\u067e\u06cc\u0646\u06cc" },
            { "hmn", "\u0647\u0645\u0648\u0646\u06af" },
            { "del", "\u062f\u0644\u0627\u0648\u0627\u0631\u06cc" },
            { "lus", "\u0644\u0648\u0634\u0647\u200c\u0627\u06cc" },
            { "bal", "\u0628\u0644\u0648\u0686\u06cc" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "luy", "\u0644\u0648\u06cc\u0627" },
            { "bar", "\u0628\u0627\u0648\u0627\u0631\u06cc\u0627\u06cc\u06cc" },
            { "bas", "\u0628\u0627\u0633\u0627\u06cc\u06cc" },
            { "bax", "\u0628\u0645\u0648\u0646\u06cc" },
            { "jrb", "\u0639\u0631\u0628\u06cc \u06cc\u0647\u0648\u062f\u06cc" },
            { "es_ES", "\u0627\u0633\u067e\u0627\u0646\u06cc\u0627\u06cc\u06cc \u0627\u0631\u0648\u067e\u0627" },
            { "nzi", "\u0646\u0632\u06cc\u0645\u0627\u06cc\u06cc" },
            { "sco", "\u0627\u0633\u06a9\u0627\u062a\u0644\u0646\u062f\u06cc" },
            { "scn", "\u0633\u06cc\u0633\u06cc\u0644\u06cc" },
            { "aa", "\u0622\u0641\u0627\u0631\u06cc" },
            { "ab", "\u0622\u0628\u062e\u0627\u0632\u06cc" },
            { "ae", metaValue_ae },
            { "af", "\u0622\u0641\u0631\u06cc\u06a9\u0627\u0646\u0633" },
            { "ak", "\u0622\u06a9\u0627\u0646" },
            { "am", "\u0627\u0645\u0647\u0631\u06cc" },
            { "Arab", metaValue_ar },
            { "an", "\u0622\u0631\u0627\u06af\u0648\u0646\u06cc" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "\u0647\u062c\u0627\u0646\u06af\u0627\u0631\u06cc \u0698\u0627\u067e\u0646\u06cc" },
            { "as", "\u0622\u0633\u0627\u0645\u06cc" },
            { "Lina", "\u062e\u0637\u06cc \u0627\u0644\u0641" },
            { "av", "\u0622\u0648\u0627\u0631\u06cc" },
            { "Linb", "\u062e\u0637\u06cc \u0628" },
            { "sdh", "\u06a9\u0631\u062f\u06cc \u062c\u0646\u0648\u0628\u06cc" },
            { "ay", "\u0622\u06cc\u0645\u0627\u0631\u0627\u06cc\u06cc" },
            { "az", "\u062a\u0631\u06a9\u06cc \u0622\u0630\u0631\u0628\u0627\u06cc\u062c\u0627\u0646\u06cc" },
            { "Khoj", "\u062e\u0648\u0627\u062c\u06a9\u06cc" },
            { "ba", "\u0628\u0627\u0634\u0642\u06cc\u0631\u06cc" },
            { "type.co.unihan", "\u062a\u0631\u062a\u06cc\u0628 \u0631\u0627\u062f\u06cc\u06a9\u0627\u0644\u06cc-\u062d\u0631\u06a9\u062a\u06cc" },
            { "be", "\u0628\u0644\u0627\u0631\u0648\u0633\u06cc" },
            { "bg", "\u0628\u0644\u063a\u0627\u0631\u06cc" },
            { "bi", "\u0628\u06cc\u0633\u0644\u0627\u0645\u0627" },
            { "type.nu.java", "\u0627\u0631\u0642\u0627\u0645 \u062c\u0627\u0648\u0647\u200c\u0627\u06cc" },
            { "bm", "\u0628\u0627\u0645\u0628\u0627\u0631\u0627\u06cc\u06cc" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "dgr", "\u062f\u0648\u06af\u0631\u06cc\u0628" },
            { "br", "\u0628\u0631\u062a\u0648\u0646" },
            { "bs", "\u0628\u0648\u0633\u0646\u06cc\u0627\u06cc\u06cc" },
            { "Mymr", "\u0645\u06cc\u0627\u0646\u0645\u0627\u0631" },
            { "type.nu.laoo", "\u0627\u0631\u0642\u0627\u0645 \u0644\u0627\u0626\u0648\u0633\u06cc" },
            { "seh", "\u0633\u0646\u0627" },
            { "sel", "\u0633\u0644\u06a9\u0648\u067e\u06cc" },
            { "ca", "\u06a9\u0627\u062a\u0627\u0644\u0627\u0646" },
            { "ses", "\u06a9\u0648\u06cc\u0631\u0627\u0628\u0648\u0631\u0627 \u0633\u0646\u06cc" },
            { "ce", "\u0686\u0686\u0646\u06cc" },
            { "ch", "\u0686\u0627\u0645\u0648\u0631\u0648\u06cc\u06cc" },
            { "%%REVISED", "\u0631\u0633\u0645\u200c\u0627\u0644\u062e\u0637 \u062a\u062c\u062f\u06cc\u062f\u0646\u0638\u0631\u0634\u062f\u0647" },
            { "co", "\u06a9\u0648\u0631\u0633\u06cc" },
            { "Orya", "\u0627\u0648\u062f\u06cc\u0647" },
            { "cr", "\u06a9\u0631\u06cc\u0627\u06cc\u06cc" },
            { "cs", "\u0686\u06a9\u06cc" },
            { "cu", "\u0627\u0633\u0644\u0627\u0648\u06cc \u06a9\u0644\u06cc\u0633\u0627\u06cc\u06cc" },
            { "cv", "\u0686\u0648\u0648\u0627\u0634\u06cc" },
            { "cy", "\u0648\u0644\u0632\u06cc" },
            { "type.nu.ethi", "\u0627\u0639\u062f\u0627\u062f \u0627\u062a\u06cc\u0648\u067e\u06cc\u0627\u06cc\u06cc" },
            { "Yiii", "\u06cc\u06cc" },
            { "da", "\u062f\u0627\u0646\u0645\u0627\u0631\u06a9\u06cc" },
            { "pt_PT", "\u067e\u0631\u062a\u063a\u0627\u0644\u06cc \u0627\u0631\u0648\u067e\u0627" },
            { "de", "\u0622\u0644\u0645\u0627\u0646\u06cc" },
            { "type.cf.standard", "\u0642\u0627\u0644\u0628 \u0627\u0633\u062a\u0627\u0646\u062f\u0627\u0631\u062f \u0648\u0627\u062d\u062f \u067e\u0648\u0644" },
            { "bej", "\u0628\u062c\u0627\u06cc\u06cc" },
            { "din", "\u062f\u06cc\u0646\u06a9\u0627\u06cc\u06cc" },
            { "Bugi", metaValue_bug },
            { "bem", "\u0628\u0645\u0628\u0627\u06cc\u06cc" },
            { "sga", "\u0627\u06cc\u0631\u0644\u0646\u062f\u06cc \u0628\u0627\u0633\u062a\u0627\u0646" },
            { "type.nu.mong", "\u0627\u0631\u0642\u0627\u0645 \u0645\u063a\u0648\u0644\u06cc" },
            { "dv", "\u062f\u06cc\u0648\u0647\u06cc" },
            { "es_419", "\u0627\u0633\u067e\u0627\u0646\u06cc\u0627\u06cc\u06cc \u0627\u0645\u0631\u06cc\u06a9\u0627\u06cc \u0644\u0627\u062a\u06cc\u0646" },
            { "dz", "\u062f\u0632\u0648\u0646\u06af\u062e\u0627" },
            { "bez", "\u0628\u0646\u0627\u06cc\u06cc" },
            { "type.ca.chinese", "\u062a\u0642\u0648\u06cc\u0645 \u0686\u06cc\u0646\u06cc" },
            { "lzh", "\u0686\u06cc\u0646\u06cc \u0627\u062f\u0628\u06cc" },
            { "dje", "\u0632\u0631\u0645\u0627" },
            { "type.nu.grek", "\u0627\u0639\u062f\u0627\u062f \u06cc\u0648\u0646\u0627\u0646\u06cc" },
            { "ee", "\u0627\u0648\u0647\u200c\u0627\u06cc" },
            { "type.lb.normal", "\u0634\u06cc\u0648\u0647\u0654 \u0633\u0637\u0631\u0634\u06a9\u0646\u06cc \u0639\u0627\u062f\u06cc" },
            { "ro_MD", "\u0645\u0648\u0644\u062f\u0627\u0648\u06cc\u0627\u06cc\u06cc" },
            { "el", metaValue_el },
            { "en", "\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc" },
            { "eo", "\u0627\u0633\u067e\u0631\u0627\u0646\u062a\u0648" },
            { "type.co.big5han", "\u062a\u0631\u062a\u06cc\u0628 \u0686\u06cc\u0646\u06cc \u0633\u0646\u062a\u06cc - Big5" },
            { "es", "\u0627\u0633\u067e\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "et", "\u0627\u0633\u062a\u0648\u0646\u06cc\u0627\u06cc\u06cc" },
            { "Hanb", "\u0647\u0627\u0646 \u0628\u0627 \u0628\u0648\u0645\u0648\u067e\u0648\u0641\u0648" },
            { "eu", "\u0628\u0627\u0633\u06a9\u06cc" },
            { "Buhd", "\u0628\u0648\u0647\u06cc\u062f" },
            { "Hang", "\u0647\u0627\u0646\u06af\u0648\u0644" },
            { "Samr", "\u0633\u0627\u0645\u0631\u06cc" },
            { "shi", "\u062a\u0627\u0686\u0644\u200c\u0647\u06cc\u062a" },
            { "hsb", "\u0635\u064f\u0631\u0628\u06cc \u0639\u0644\u06cc\u0627" },
            { "Hani", "\u0647\u0627\u0646" },
            { "shn", "\u0634\u0627\u0646\u06cc" },
            { "Hano", "\u0647\u0627\u0646\u0648\u0646\u0648\u06cc\u06cc" },
            { "fa", "\u0641\u0627\u0631\u0633\u06cc" },
            { "Hans", "\u0633\u0627\u062f\u0647\u200c\u0634\u062f\u0647" },
            { "type.nu.latn", "\u0627\u0631\u0642\u0627\u0645 \u063a\u0631\u0628\u06cc" },
            { "Hant", "\u0633\u0646\u062a\u06cc" },
            { "az_Arab", "\u062a\u0631\u06a9\u06cc \u0622\u0630\u0631\u06cc \u062c\u0646\u0648\u0628\u06cc" },
            { "ff", "\u0641\u0648\u0644\u0627\u0646\u06cc" },
            { "shu", "\u0639\u0631\u0628\u06cc \u0686\u0627\u062f\u06cc" },
            { "fi", "\u0641\u0646\u0644\u0627\u0646\u062f\u06cc" },
            { "fj", "\u0641\u06cc\u062c\u06cc\u0627\u06cc\u06cc" },
            { "fon", "\u0641\u0648\u0646\u06cc" },
            { "bgn", "\u0628\u0644\u0648\u0686\u06cc \u063a\u0631\u0628\u06cc" },
            { "yue", "\u06a9\u0627\u0646\u062a\u0648\u0646\u06cc" },
            { "fo", "\u0641\u0627\u0631\u0648\u06cc\u06cc" },
            { "type.m0.bgn", "\u062a\u0631\u0627\u0646\u0648\u06cc\u0633\u06cc \u0627\u0646\u062c\u0645\u0646 \u0646\u0627\u0645\u200c\u0647\u0627\u06cc \u062c\u063a\u0631\u0627\u0641\u06cc\u0627\u06cc\u06cc \u0627\u06cc\u0627\u0644\u0627\u062a \u0645\u062a\u062d\u062f\u0647" },
            { "umb", "\u0627\u0645\u0628\u0648\u0646\u062f\u0648\u06cc\u06cc" },
            { "fr", "\u0641\u0631\u0627\u0646\u0633\u0648\u06cc" },
            { "sid", "\u0633\u06cc\u062f\u0627\u0645\u0648\u06cc\u06cc" },
            { "fy", "\u0641\u0631\u06cc\u0633\u06cc \u063a\u0631\u0628\u06cc" },
            { "ga", "\u0627\u06cc\u0631\u0644\u0646\u062f\u06cc" },
            { "gd", "\u06af\u06cc\u0644\u06cc \u0627\u0633\u06a9\u0627\u062a\u0644\u0646\u062f\u06cc" },
            { "gl", "\u06af\u0627\u0644\u06cc\u0633\u06cc\u0627\u06cc\u06cc" },
            { "gn", "\u06af\u0648\u0627\u0631\u0627\u0646\u06cc" },
            { "bho", "\u0628\u0648\u062c\u067e\u0648\u0631\u06cc" },
            { "und", "\u0632\u0628\u0627\u0646 \u0646\u0627\u0645\u0634\u062e\u0635" },
            { "type.ca.ethiopic-amete-alem", "\u062a\u0642\u0648\u06cc\u0645 \u0627\u062a\u06cc\u0648\u067e\u06cc\u0627\u06cc\u06cc \u0639\u0627\u0645\u062a \u0639\u0627\u0644\u0645" },
            { "gu", metaValue_gu },
            { "type.ca.islamic-tbla", "\u062a\u0642\u0648\u06cc\u0645 \u0647\u062c\u0631\u06cc \u0642\u0645\u0631\u06cc \u062c\u062f\u0648\u0644\u06cc \u0646\u062c\u0648\u0645\u06cc" },
            { "gv", "\u0645\u0627\u0646\u06cc" },
            { "ha", "\u0647\u0648\u0633\u0627\u06cc\u06cc" },
            { "he", metaValue_he },
            { "hi", "\u0647\u0646\u062f\u06cc" },
            { "hup", "\u0647\u0648\u067e\u0627" },
            { "bik", "\u0628\u06cc\u06a9\u0648\u0644\u06cc" },
            { "bin", "\u0628\u06cc\u0646\u06cc" },
            { "ho", "\u0645\u0648\u062a\u0648\u06cc\u06cc \u0647\u06cc\u0631\u06cc" },
            { "hr", "\u06a9\u0631\u0648\u0627\u062a" },
            { "ht", "\u0647\u0627\u0626\u06cc\u062a\u06cc\u0627\u06cc\u06cc" },
            { "hu", "\u0645\u062c\u0627\u0631\u06cc" },
            { "hy", metaValue_hy },
            { "hz", "\u0647\u0631\u06cc\u0631\u0648\u06cc\u06cc" },
            { "frc", "\u0641\u0631\u0627\u0646\u0633\u0648\u06cc \u06a9\u0627\u062f\u06cc\u0646" },
            { "%%FONIPA", "\u0641\u0648\u0646\u062a\u06cc\u06a9 IPA" },
            { "ia", "\u0627\u06cc\u0646\u062a\u0631\u0644\u06cc\u0646\u06af\u0648\u0627" },
            { "Jamo", "\u062c\u0627\u0645\u0648" },
            { "id", "\u0627\u0646\u062f\u0648\u0646\u0632\u06cc\u0627\u06cc\u06cc" },
            { "type.nu.tibt", "\u0627\u0631\u0642\u0627\u0645 \u062a\u0628\u062a\u06cc" },
            { "ie", "\u0627\u06a9\u0633\u06cc\u062f\u0646\u062a\u0627\u0644" },
            { "ig", "\u0627\u06cc\u06af\u0628\u0648\u06cc\u06cc" },
            { "ii", "\u06cc\u06cc \u0633\u06cc\u0686\u0648\u0627\u0646" },
            { "frm", "\u0641\u0631\u0627\u0646\u0633\u0648\u06cc \u0645\u06cc\u0627\u0646\u0647" },
            { "ik", "\u0627\u06cc\u0646\u0648\u067e\u06cc\u06a9" },
            { "fro", "\u0641\u0631\u0627\u0646\u0633\u0648\u06cc \u0628\u0627\u0633\u062a\u0627\u0646" },
            { "io", "\u0627\u06cc\u062f\u0648" },
            { "frs", "\u0641\u0631\u06cc\u0632\u06cc \u0634\u0631\u0642\u06cc" },
            { "frr", "\u0641\u0631\u06cc\u0632\u06cc \u0634\u0645\u0627\u0644\u06cc" },
            { "is", "\u0627\u06cc\u0633\u0644\u0646\u062f\u06cc" },
            { "it", "\u0627\u06cc\u062a\u0627\u0644\u06cc\u0627\u06cc\u06cc" },
            { "iu", "\u0627\u06cc\u0646\u0648\u06a9\u062a\u06cc\u062a\u0648\u062a" },
            { "sli", "\u0633\u06cc\u0644\u0632\u06cc\u0627\u06cc\u06cc \u0633\u0641\u0644\u06cc" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sarb", "\u0639\u0631\u0628\u06cc \u062c\u0646\u0648\u0628\u06cc \u0628\u0627\u0633\u062a\u0627\u0646" },
            { "Sara", "\u0633\u0627\u0631\u0627\u062a\u06cc" },
            { "doi", "\u062f\u0648\u06af\u0631\u06cc" },
            { "sma", "\u0633\u0627\u0645\u06cc \u062c\u0646\u0648\u0628\u06cc" },
            { "jv", metaValue_jv },
            { "Shaw", "\u0634\u0627\u0648\u06cc" },
            { "mad", "\u0645\u0627\u062f\u0648\u0631\u0627\u06cc\u06cc" },
            { "smj", "\u0644\u0648\u0644\u0647 \u0633\u0627\u0645\u06cc" },
            { "mag", "\u0645\u0627\u06af\u0627\u0647\u06cc\u0627\u06cc\u06cc" },
            { "mai", "\u0645\u0627\u06cc\u062f\u06cc\u0644\u06cc" },
            { "smn", "\u0627\u06cc\u0646\u0627\u0631\u06cc \u0633\u0627\u0645\u06cc" },
            { "ka", metaValue_ka },
            { "bla", "\u0633\u06cc\u06a9\u0633\u06cc\u06a9\u0627" },
            { "mak", "\u0645\u0627\u06a9\u0627\u0633\u0627\u0631" },
            { "sms", "\u0627\u0633\u06a9\u0648\u0644\u062a \u0633\u0627\u0645\u06cc" },
            { "man", "\u0645\u0627\u0646\u062f\u06cc\u0646\u06af\u0648\u06cc\u06cc" },
            { "kg", "\u06a9\u0646\u06af\u0648\u06cc\u06cc" },
            { "Goth", metaValue_got },
            { "ki", "\u06a9\u06cc\u06a9\u0648\u06cc\u0648\u06cc\u06cc" },
            { "mas", "\u0645\u0627\u0633\u0627\u06cc\u06cc" },
            { "kj", "\u06a9\u0648\u0627\u0646\u06cc\u0627\u0645\u0627" },
            { "kk", "\u0642\u0632\u0627\u0642\u06cc" },
            { "kl", "\u06af\u0631\u06cc\u0646\u0644\u0646\u062f\u06cc" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u06a9\u0627\u0646\u0648\u0631\u06cc\u0627\u06cc\u06cc" },
            { "ks", "\u06a9\u0634\u0645\u06cc\u0631\u06cc" },
            { "Cirt", "\u06a9\u0631\u062a" },
            { "Avst", metaValue_ae },
            { "ku", "\u06a9\u0631\u062f\u06cc" },
            { "kv", "\u06a9\u0648\u0645\u06cc\u0627\u06cc\u06cc" },
            { "kw", "\u06a9\u0648\u0631\u0646\u06cc" },
            { "ky", "\u0642\u0631\u0642\u06cc\u0632\u06cc" },
            { "snk", "\u0633\u0648\u0646\u06cc\u0646\u06a9\u0647\u200c\u0627\u06cc" },
            { "la", metaValue_la },
            { "lb", "\u0644\u0648\u06af\u0632\u0627\u0645\u0628\u0648\u0631\u06af\u06cc" },
            { "type.nu.mlym", "\u0627\u0631\u0642\u0627\u0645 \u0645\u0627\u0644\u0627\u06cc\u0627\u0644\u0627\u0645\u06cc" },
            { "lg", "\u06af\u0627\u0646\u062f\u0627\u06cc\u06cc" },
            { "li", "\u0644\u06cc\u0645\u0628\u0648\u0631\u06af\u06cc" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0644\u06cc\u0646\u06af\u0627\u0644\u0627" },
            { "fur", "\u0641\u0631\u06cc\u0648\u0644\u06cc\u0627\u06cc\u06cc" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "\u0633\u06cc\u0633\u062a\u0645 \u0627\u0646\u062f\u0627\u0632\u0647\u200c\u06af\u06cc\u0631\u06cc \u0627\u0646\u06af\u0644\u06cc\u0633\u06cc" },
            { "lt", "\u0644\u06cc\u062a\u0648\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "lu", "\u0644\u0648\u0628\u0627\u06cc\u06cc\u2010\u06a9\u0627\u062a\u0627\u0646\u06af\u0627" },
            { "lv", "\u0644\u062a\u0648\u0646\u06cc\u0627\u06cc\u06cc" },
            { "sog", "\u0633\u063a\u062f\u06cc" },
            { "ListCompositionPattern", "{0}\u060c {1}" },
            { "mg", "\u0645\u0627\u0644\u0627\u06af\u0627\u0633\u06cc" },
            { "mh", "\u0645\u0627\u0631\u0634\u0627\u0644\u06cc" },
            { "type.co.ducet", "\u062a\u0631\u062a\u06cc\u0628 \u067e\u06cc\u0634\u200c\u0641\u0631\u0636 \u06cc\u0648\u0646\u06cc\u200c\u06a9\u062f" },
            { "mi", "\u0645\u0627\u0626\u0648\u0631\u06cc" },
            { "mk", "\u0645\u0642\u062f\u0648\u0646\u06cc" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u0645\u0631\u0627\u062a\u06cc" },
            { "ms", "\u0645\u0627\u0644\u0627\u06cc\u06cc" },
            { "mt", "\u0645\u0627\u0644\u062a\u06cc" },
            { "my", "\u0628\u0631\u0645\u0647\u200c\u0627\u06cc" },
            { "Saur", "\u0633\u0648\u0631\u0627\u0634\u062a\u0631\u0627\u06cc\u06cc" },
            { "Armn", metaValue_hy },
            { "mdf", "\u0645\u06a9\u0634\u0627\u06cc\u06cc" },
            { "dsb", "\u0635\u064f\u0631\u0628\u06cc \u0633\u0641\u0644\u06cc" },
            { "Armi", "\u0622\u0631\u0627\u0645\u06cc \u0647\u062e\u0627\u0645\u0646\u0634\u06cc" },
            { "na", "\u0646\u0627\u0626\u0648\u0631\u0648\u06cc\u06cc" },
            { "type.co.search", "\u062c\u0633\u062a\u062c\u0648\u06cc \u0639\u0645\u0648\u0645\u06cc" },
            { "nb", "\u0646\u0631\u0648\u0698\u06cc \u0628\u0648\u06a9\u200c\u0645\u064f\u0644" },
            { "nd", "\u0627\u0646\u062f\u0647\u200c\u0628\u0644\u0647\u200c\u0627\u06cc \u0634\u0645\u0627\u0644\u06cc" },
            { "ne", "\u0646\u067e\u0627\u0644\u06cc" },
            { "ng", "\u0627\u0646\u062f\u0648\u0646\u06af\u0627\u06cc\u06cc" },
            { "mdr", "\u0645\u0627\u0646\u062f\u0627\u0631" },
            { "nl", "\u0647\u0644\u0646\u062f\u06cc" },
            { "nn", "\u0646\u0631\u0648\u0698\u06cc \u0646\u06cc\u200c\u0646\u064f\u0634\u06a9" },
            { "no", "\u0646\u0631\u0648\u0698\u06cc" },
            { "nr", "\u0627\u0646\u062f\u0647\u200c\u0628\u0644\u0647\u200c\u0627\u06cc \u062c\u0646\u0648\u0628\u06cc" },
            { "nv", "\u0646\u0627\u0648\u0627\u0647\u0648\u06cc\u06cc" },
            { "kaa", "\u0642\u0631\u0647\u200c\u0642\u0627\u0644\u067e\u0627\u0642\u06cc" },
            { "ny", "\u0646\u06cc\u0627\u0646\u062c\u0627\u06cc\u06cc" },
            { "kac", "\u06a9\u0627\u0686\u06cc\u0646\u06cc" },
            { "kab", "\u0642\u0628\u0627\u06cc\u0644\u06cc" },
            { "oc", "\u0627\u06a9\u0633\u06cc\u062a\u0627\u0646" },
            { "kaj", "\u062c\u0648" },
            { "kam", "\u06a9\u0627\u0645\u0628\u0627\u06cc\u06cc" },
            { "men", metaValue_men },
            { "oj", "\u0627\u0648\u062c\u06cc\u0628\u0648\u0627\u06cc\u06cc" },
            { "mer", "\u0645\u0631\u0648\u06cc\u06cc" },
            { "type.nu.armn", "\u0627\u0639\u062f\u0627\u062f \u0627\u0631\u0645\u0646\u06cc" },
            { "om", "\u0627\u0648\u0631\u0648\u0645\u0648\u06cc\u06cc" },
            { "kaw", "\u06a9\u0627\u0648\u06cc\u0627\u06cc\u06cc" },
            { "or", "\u0627\u0648\u0631\u06cc\u0647\u200c\u0627\u06cc" },
            { "os", "\u0622\u0633\u06cc" },
            { "kbd", "\u06a9\u0627\u0628\u0627\u0631\u062f\u06cc\u0646\u06cc" },
            { "mfe", "\u0645\u0648\u0631\u06cc\u0633\u06cc\u0646" },
            { "srn", "\u062a\u0627\u06a9\u06cc\u200c\u062a\u0627\u06a9\u06cc" },
            { "pa", "\u067e\u0646\u062c\u0627\u0628\u06cc" },
            { "dua", "\u062f\u0648\u0622\u0644\u0627\u06cc\u06cc" },
            { "srr", "\u0633\u0631\u06cc\u0631\u06cc" },
            { "pi", "\u067e\u0627\u0644\u06cc" },
            { "bqi", "\u0644\u0631\u06cc \u0628\u062e\u062a\u06cc\u0627\u0631\u06cc" },
            { "pl", "\u0644\u0647\u0633\u062a\u0627\u0646\u06cc" },
            { "dum", "\u0647\u0644\u0646\u062f\u06cc \u0645\u06cc\u0627\u0646\u0647" },
            { "type.ca.dangi", "\u062a\u0642\u0648\u06cc\u0645 \u062f\u0627\u0646\u06af\u06cc" },
            { "ps", "\u067e\u0634\u062a\u0648" },
            { "pt", "\u067e\u0631\u062a\u063a\u0627\u0644\u06cc" },
            { "mga", "\u0627\u06cc\u0631\u0644\u0646\u062f\u06cc \u0645\u06cc\u0627\u0646\u0647" },
            { "key.co", "\u062a\u0631\u062a\u06cc\u0628" },
            { "pt_BR", "\u067e\u0631\u062a\u063a\u0627\u0644\u06cc \u0628\u0631\u0632\u06cc\u0644" },
            { "kcg", "\u062a\u06cc\u0627\u067e\u06cc" },
            { "mgh", "\u0645\u0627\u06a9\u0648\u0627 \u0645\u062a\u0648" },
            { "key.cf", "\u0642\u0627\u0644\u0628 \u0648\u0627\u062d\u062f \u067e\u0648\u0644" },
            { "bra", "\u0628\u0631\u0627\u062c" },
            { "key.ca", "\u062a\u0642\u0648\u06cc\u0645" },
            { "Laoo", metaValue_lo },
            { "mgo", "\u0645\u062a\u0627\u06cc\u06cc" },
            { "type.hc.h23", "\u0633\u06cc\u0633\u062a\u0645 \u06f2\u06f4 \u0633\u0627\u0639\u062a\u0647 (\u06f0 \u062a\u0627 \u06f2\u06f3)" },
            { "type.hc.h24", "\u0633\u06cc\u0633\u062a\u0645 \u06f2\u06f4 \u0633\u0627\u0639\u062a\u0647 (\u06f1 \u062a\u0627 \u06f2\u06f4)" },
            { "ssy", "\u0633\u0627\u0647\u0648" },
            { "brh", "\u0628\u0631\u0627\u0647\u0648\u06cc\u06cc" },
            { "type.nu.mymr", "\u0627\u0631\u0642\u0627\u0645 \u0645\u06cc\u0627\u0646\u0645\u0627\u0631\u06cc" },
            { "qu", "\u06a9\u0686\u0648\u0627\u06cc\u06cc" },
            { "zap", "\u0632\u0627\u067e\u0648\u062a\u06a9\u06cc" },
            { "brx", "\u0628\u0648\u062f\u0648\u06cc\u06cc" },
            { "Lana", "\u0644\u0627\u0646\u0627\u06cc\u06cc" },
            { "kde", "\u0645\u0627\u06a9\u0648\u0646\u062f\u0647" },
            { "Ethi", "\u0627\u062a\u06cc\u0648\u067e\u06cc\u0627\u06cc\u06cc" },
            { "type.hc.h12", "\u0633\u06cc\u0633\u062a\u0645 \u06f1\u06f2 \u0633\u0627\u0639\u062a\u0647 (\u06f1 \u062a\u0627 \u06f1\u06f2)" },
            { "type.hc.h11", "\u0633\u06cc\u0633\u062a\u0645 \u06f1\u06f2 \u0633\u0627\u0639\u062a\u0647 (\u06f0 \u062a\u0627 \u06f1\u06f1)" },
            { "rm", "\u0631\u0648\u0645\u0627\u0646\u0634" },
            { "rn", "\u0631\u0648\u0646\u062f\u06cc\u0627\u06cc\u06cc" },
            { "key.cu", "\u0648\u0627\u062d\u062f \u067e\u0648\u0644" },
            { "ro", "\u0631\u0648\u0645\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "%%SAAHO", "\u0633\u0627\u0647\u0648\u06cc\u06cc" },
            { "type.nu.orya", "\u0627\u0631\u0642\u0627\u0645 \u0627\u0648\u062f\u06cc\u0647" },
            { "type.nu.hanidec", "\u0627\u0639\u062f\u0627\u062f \u062f\u0647\u062f\u0647\u06cc \u0686\u06cc\u0646\u06cc" },
            { "ru", "\u0631\u0648\u0633\u06cc" },
            { "rw", "\u06a9\u06cc\u0646\u06cc\u0627\u0631\u0648\u0627\u0646\u062f\u0627\u06cc\u06cc" },
            { "kea", "\u06a9\u0627\u0628\u0648\u0648\u0631\u062f\u06cc\u0627\u0646\u0648" },
            { "mic", "\u0645\u06cc\u06a9\u0645\u0627\u06a9\u06cc" },
            { "suk", "\u0633\u0648\u06a9\u0648\u0645\u0627\u06cc\u06cc" },
            { "en_AU", "\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc \u0627\u0633\u062a\u0631\u0627\u0644\u06cc\u0627" },
            { "sa", "\u0633\u0627\u0646\u0633\u06a9\u0631\u06cc\u062a" },
            { "sc", "\u0633\u0627\u0631\u062f\u06cc\u0646\u06cc\u0627\u06cc\u06cc" },
            { "sus", "\u0633\u0648\u0633\u0648\u06cc\u06cc" },
            { "sd", "\u0633\u0646\u062f\u06cc" },
            { "se", "\u0633\u0627\u0645\u06cc \u0634\u0645\u0627\u0644\u06cc" },
            { "min", "\u0645\u06cc\u0646\u0627\u0646\u06af\u200c\u06a9\u0627\u0628\u0648\u06cc\u06cc" },
            { "sg", "\u0633\u0627\u0646\u06af\u0648" },
            { "sh", "\u0635\u0631\u0628 \u0648 \u06a9\u0631\u0648\u0627\u062a\u06cc" },
            { "si", metaValue_si },
            { "sux", "\u0633\u0648\u0645\u0631\u06cc" },
            { "sk", metaValue_SK },
            { "sl", "\u0627\u0633\u0644\u0648\u0648\u0646\u06cc\u0627\u06cc\u06cc" },
            { "sm", "\u0633\u0627\u0645\u0648\u0622\u06cc\u06cc" },
            { "sn", "\u0634\u0648\u0646\u0627\u06cc\u06cc" },
            { "so", "\u0633\u0648\u0645\u0627\u0644\u06cc\u0627\u06cc\u06cc" },
            { "type.nu.arab", "\u0627\u0631\u0642\u0627\u0645 \u0639\u0631\u0628\u06cc" },
            { "sq", "\u0622\u0644\u0628\u0627\u0646\u06cc\u0627\u06cc\u06cc" },
            { "sr", "\u0635\u0631\u0628\u06cc" },
            { "ss", "\u0633\u0648\u0627\u0632\u06cc\u0627\u06cc\u06cc" },
            { "type.cf.account", "\u0642\u0627\u0644\u0628 \u062d\u0633\u0627\u0628\u062f\u0627\u0631\u06cc \u0648\u0627\u062d\u062f \u067e\u0648\u0644" },
            { "Java", metaValue_jv },
            { "st", "\u0633\u0648\u062a\u0648\u06cc \u062c\u0646\u0648\u0628\u06cc" },
            { "su", "\u0633\u0648\u0646\u062f\u0627\u06cc\u06cc" },
            { "sv", "\u0633\u0648\u0626\u062f\u06cc" },
            { "sw", "\u0633\u0648\u0627\u062d\u06cc\u0644\u06cc" },
            { "type.nu.hantfin", "\u0627\u0639\u062f\u0627\u062f \u0645\u0627\u0644\u06cc \u0686\u06cc\u0646\u06cc \u0633\u0646\u062a\u06cc" },
            { "ibb", "\u0627\u06cc\u0628\u06cc\u0628\u06cc\u0648" },
            { "iba", "\u0627\u06cc\u0628\u0627\u0646\u06cc" },
            { "ta", metaValue_ta },
            { "142", "\u0622\u0633\u06cc\u0627" },
            { "bua", "\u0628\u0648\u0631\u06cc\u0627\u062a\u06cc" },
            { "143", "\u0622\u0633\u06cc\u0627\u06cc \u0645\u0631\u06a9\u0632\u06cc" },
            { "te", metaValue_te },
            { "145", "\u063a\u0631\u0628 \u0622\u0633\u06cc\u0627" },
            { "tg", "\u062a\u0627\u062c\u06cc\u06a9\u06cc" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "\u062a\u06cc\u06af\u0631\u06cc\u0646\u06cc\u0627\u06cc\u06cc" },
            { "kfo", "\u06a9\u0648\u0631\u0648" },
            { "en_CA", "\u0627\u0646\u06af\u0644\u06cc\u0633\u06cc \u06a9\u0627\u0646\u0627\u062f\u0627" },
            { "tk", "\u062a\u0631\u06a9\u0645\u0646\u06cc" },
            { "tl", metaValue_tl },
            { "tn", "\u062a\u0633\u0648\u0627\u0646\u0627\u06cc\u06cc" },
            { "to", "\u062a\u0648\u0646\u06af\u0627\u06cc\u06cc" },
            { "dyo", "\u062f\u06cc\u0648\u0644\u0627 \u0641\u0648\u0646\u06cc" },
            { "type.nu.jpan", "\u0627\u0639\u062f\u0627\u062f \u0698\u0627\u067e\u0646\u06cc" },
            { "tr", "\u062a\u0631\u06a9\u06cc \u0627\u0633\u062a\u0627\u0646\u0628\u0648\u0644\u06cc" },
            { "ts", "\u062a\u0633\u0648\u0646\u06af\u0627\u06cc\u06cc" },
            { "swb", "\u06a9\u0648\u0645\u0648\u0631\u06cc" },
            { "Cakm", "\u0686\u0627\u06a9\u0645\u0627\u06cc\u06cc" },
            { "tt", "\u062a\u0627\u062a\u0627\u0631\u06cc" },
            { "dyu", "\u062f\u0627\u06cc\u0648\u0644\u0627\u06cc\u06cc" },
            { "tw", "\u062a\u0648\u06cc\u200c\u06cc\u0627\u06cc\u06cc" },
            { "ty", "\u062a\u0627\u0647\u06cc\u062a\u06cc\u0627\u06cc\u06cc" },
            { "150", "\u0627\u0631\u0648\u067e\u0627" },
            { "151", "\u0634\u0631\u0642 \u0627\u0631\u0648\u067e\u0627" },
            { "type.nu.mathsanb", "\u0627\u0631\u0642\u0627\u0645 \u0631\u06cc\u0627\u0636\u06cc \u0633\u06cc\u0627\u0647 \u0628\u06cc\u200c\u0633\u0631\u06cc\u0641" },
            { "154", "\u0634\u0645\u0627\u0644 \u0627\u0631\u0648\u067e\u0627" },
            { "dzg", "\u062f\u0627\u0632\u0627\u06af\u0627\u06cc\u06cc" },
            { "155", "\u063a\u0631\u0628 \u0627\u0631\u0648\u067e\u0627" },
            { "ug", "\u0627\u0648\u06cc\u063a\u0648\u0631\u06cc" },
            { "Kore", metaValue_ko },
            { "Ital", "\u0627\u06cc\u062a\u0627\u0644\u06cc \u0628\u0627\u0633\u062a\u0627\u0646" },
            { "Zyyy", "\u0645\u0634\u062a\u0631\u06a9" },
            { "uk", "\u0627\u0648\u06a9\u0631\u0627\u06cc\u0646\u06cc" },
            { "type.ca.coptic", "\u062a\u0642\u0648\u06cc\u0645 \u0642\u0628\u0637\u06cc" },
            { "ur", "\u0627\u0631\u062f\u0648" },
            { "xal", "\u0642\u0644\u0645\u0648\u0642\u06cc" },
            { "zen", "\u0632\u0646\u0627\u06af\u0627" },
            { "uz", "\u0627\u0632\u0628\u06a9\u06cc" },
            { "kha", "\u062e\u0627\u0633\u06cc\u0627\u06cc\u06cc" },
            { "%%1996", "\u0631\u0633\u0645\u200c\u0627\u0644\u062e\u0637 \u0622\u0644\u0645\u0627\u0646\u06cc \u06f1\u06f9\u06f9\u06f6 \u0645\u06cc\u0644\u0627\u062f\u06cc" },
            { "nds_NL", "\u0633\u0627\u06a9\u0633\u0648\u0646\u06cc \u0633\u0641\u0644\u06cc" },
            { "Sylo", "\u0633\u06cc\u0644\u0648\u062a\u06cc \u0646\u06af\u0627\u0631\u06cc" },
            { "ve", "\u0648\u0646\u062f\u0627\u06cc\u06cc" },
            { "type.ca.roc", "\u062a\u0642\u0648\u06cc\u0645 \u062c\u0645\u0647\u0648\u0631\u06cc \u0686\u06cc\u0646 (\u062a\u0627\u06cc\u0648\u0627\u0646)" },
            { "vi", "\u0648\u06cc\u062a\u0646\u0627\u0645\u06cc" },
            { "kho", "\u062e\u062a\u0646\u06cc" },
            { "khq", "\u06a9\u0648\u062c\u0631\u0627\u0686\u06cc\u0646\u06cc" },
            { "key.hc", "\u062f\u0648\u0631 \u0633\u0627\u0639\u062a (\u06f1\u06f2 \u062f\u0631 \u0645\u0642\u0627\u0628\u0644 \u06f2\u06f4)" },
            { "vo", "\u0648\u0644\u0627\u067e\u0648\u06a9" },
            { "khw", "\u06a9\u0647\u0648\u0627\u0631" },
            { "syc", "\u0633\u0631\u06cc\u0627\u0646\u06cc \u06a9\u0644\u0627\u0633\u06cc\u06a9" },
            { "type.nu.mathsans", "\u0627\u0631\u0642\u0627\u0645 \u0631\u06cc\u0627\u0636\u06cc \u0628\u06cc\u200c\u0633\u0631\u06cc\u0641" },
            { "quc", "\u06a9\u06cc\u0686\u0647\u200c" },
            { "gaa", "\u06af\u0627\u06cc\u06cc" },
            { "wa", "\u0648\u0627\u0644\u0648\u0646\u06cc" },
            { "gag", "\u06af\u0627\u06af\u0627\u0626\u0648\u0632\u06cc\u0627\u06cc\u06cc" },
            { "syr", metaValue_syr },
            { "Grek", metaValue_el },
            { "kiu", "\u06a9\u0631\u0645\u0627\u0646\u062c\u06cc" },
            { "Lydi", "\u0644\u062f\u06cc\u0627\u06cc\u06cc" },
            { "Xsux", "\u0645\u06cc\u062e\u06cc \u0633\u0648\u0645\u0631\u06cc\u2010\u0627\u06a9\u062f\u06cc" },
            { "wo", "\u0648\u0644\u0648\u0641\u06cc" },
            { "zgh", "\u0622\u0645\u0627\u0632\u06cc\u063a\u06cc \u0645\u0639\u06cc\u0627\u0631 \u0645\u0631\u0627\u06a9\u0634" },
            { "ar_001", "\u0639\u0631\u0628\u06cc \u0631\u0633\u0645\u06cc" },
            { "gay", "\u06af\u0627\u06cc\u0648\u06cc\u06cc" },
            { "Mong", metaValue_mn },
            { "mnc", "\u0645\u0627\u0646\u0686\u0648\u06cc\u06cc" },
            { "Latf", "\u0644\u0627\u062a\u06cc\u0646\u06cc \u0641\u0631\u0627\u06a9\u062a\u0648\u0631" },
            { "szl", "\u0633\u06cc\u0644\u0632\u06cc\u0627\u06cc\u06cc" },
            { "Hluw", "\u0647\u06cc\u0631\u0648\u06af\u0644\u06cc\u0641 \u0622\u0646\u0627\u062a\u0648\u0644\u06cc" },
            { "gba", "\u06af\u0628\u0627\u06cc\u0627\u06cc\u06cc" },
            { "mni", "\u0645\u0627\u0646\u06cc\u067e\u0648\u0631\u06cc" },
            { "Latn", metaValue_la },
            { "Latg", "\u0644\u0627\u062a\u06cc\u0646\u06cc \u06af\u06cc\u0644\u06cc" },
            { "type.nu.hans", "\u0627\u0639\u062f\u0627\u062f \u0686\u06cc\u0646\u06cc \u0633\u0627\u062f\u0647\u200c\u0634\u062f\u0647" },
            { "type.nu.hant", "\u0627\u0639\u062f\u0627\u062f \u0686\u06cc\u0646\u06cc \u0633\u0646\u062a\u06cc" },
            { "xh", "\u062e\u0648\u0633\u0627\u06cc\u06cc" },
            { "type.nu.romanlow", "\u0627\u0639\u062f\u0627\u062f \u0631\u0648\u0645\u06cc \u0628\u0627 \u062d\u0631\u0648\u0641 \u06a9\u0648\u0686\u06a9" },
            { "byn", "\u0628\u0644\u06cc\u0646" },
            { "Lyci", "\u0644\u0633\u06cc\u0627\u06cc\u06cc" },
            { "osa", "\u0627\u0648\u0633\u06cc\u062c\u06cc" },
            { "gbz", "\u062f\u0631\u06cc \u0632\u0631\u062a\u0634\u062a\u06cc" },
            { "Moon", "\u0645\u0648\u0646\u06cc" },
            { "moh", "\u0645\u0648\u0647\u0627\u06a9\u06cc" },
            { "kkj", "\u06a9\u0627\u06a9\u0627\u06cc\u06cc" },
            { "Syrc", metaValue_syr },
            { "yi", "\u06cc\u062f\u06cc" },
            { "mos", "\u0645\u0627\u0633\u06cc\u0627\u06cc\u06cc" },
            { "Dsrt", "\u062f\u06cc\u0633\u0631\u062a\u06cc" },
            { "yo", "\u06cc\u0648\u0631\u0648\u0628\u0627\u06cc\u06cc" },
            { "type.nu.traditional", "\u0633\u06cc\u0633\u062a\u0645 \u0627\u0639\u062f\u0627\u062f \u0633\u0646\u062a\u06cc" },
            { "es_MX", "\u0627\u0633\u067e\u0627\u0646\u06cc\u0627\u06cc\u06cc \u0645\u06a9\u0632\u06cc\u06a9" },
            { "Syrj", "\u0633\u0631\u06cc\u0627\u0646\u06cc \u063a\u0631\u0628\u06cc" },
            { "ota", "\u062a\u0631\u06a9\u06cc \u0639\u062b\u0645\u0627\u0646\u06cc" },
            { "Syre", "\u0633\u0631\u06cc\u0627\u0646\u06cc \u0633\u0637\u0631\u0646\u062c\u06cc\u0644\u06cc" },
            { "vai", metaValue_vai },
            { "za", "\u0686\u0648\u0627\u0646\u06af\u06cc" },
            { "Cari", "\u06a9\u0627\u0631\u06cc" },
            { "kln", "\u06a9\u0627\u0644\u0646\u062c\u06cc\u0646" },
            { "zh", "\u0686\u06cc\u0646\u06cc" },
            { "Bopo", "\u0628\u0648\u067e\u0648\u0645\u0648\u0641\u0648" },
            { "Perm", "\u067e\u0631\u0645\u06cc \u0628\u0627\u0633\u062a\u0627\u0646" },
            { "key.lb", "\u0634\u06cc\u0648\u0647\u0654 \u0633\u0637\u0631\u0634\u06a9\u0646\u06cc" },
            { "zu", "\u0632\u0648\u0644\u0648\u06cc\u06cc" },
            { "type.co.phonebook", "\u062a\u0631\u062a\u06cc\u0628 \u062f\u0641\u062a\u0631 \u062a\u0644\u0641\u0646" },
            { "Geor", metaValue_ka },
            { "kmb", "\u06a9\u06cc\u0645\u0628\u0648\u0646\u062f\u0648\u06cc\u06cc" },
            { "type.nu.jpanfin", "\u0627\u0639\u062f\u0627\u062f \u0645\u0627\u0644\u06cc \u0698\u0627\u067e\u0646\u06cc" },
            { "Cham", "\u0686\u0645\u06cc" },
            { "gez", "\u06af\u06cc\u200c\u0626\u0632\u06cc" },
            { "Syrn", "\u0633\u0631\u06cc\u0627\u0646\u06cc \u0634\u0631\u0642\u06cc" },
            { "type.nu.mymrshan", "\u0627\u0631\u0642\u0627\u0645 \u0634\u0627\u0646 \u0645\u06cc\u0627\u0646\u0645\u0627\u0631\u06cc" },
            { "Narb", "\u0639\u0631\u0628\u06cc \u0634\u0645\u0627\u0644\u06cc \u0628\u0627\u0633\u062a\u0627\u0646" },
            { "type.co.reformed", "\u062a\u0631\u062a\u06cc\u0628 \u0627\u0635\u0644\u0627\u062d\u200c\u0634\u062f\u0647" },
            { "Tglg", metaValue_tl },
            { "Egyh", "\u06a9\u0627\u0647\u0646\u06cc \u0645\u0635\u0631\u06cc" },
            { "Palm", "\u067e\u0627\u0644\u0645\u06cc\u0631\u0627\u06cc\u06cc" },
            { "ebu", "\u0627\u0645\u0628\u0648" },
            { "Egyp", "\u0647\u06cc\u0631\u0648\u06af\u0644\u06cc\u0641 \u0645\u0635\u0631\u06cc" },
            { "Geok", "\u06af\u0631\u062c\u06cc \u062e\u0648\u062a\u0633\u0648\u0631\u06cc" },
            { "zh_Hans", "\u0686\u06cc\u0646\u06cc \u0633\u0627\u062f\u0647\u200c\u0634\u062f\u0647" },
            { "koi", "\u06a9\u0648\u0645\u06cc \u067e\u0631\u0645\u06cc\u0627\u06a9" },
            { "Hung", "\u0645\u062c\u0627\u0631\u06cc \u0628\u0627\u0633\u062a\u0627\u0646" },
            { "kok", "\u06a9\u0646\u06a9\u0627\u0646\u06cc" },
            { "%%1901", "\u0631\u0633\u0645\u200c\u0627\u0644\u062e\u0637 \u0633\u0646\u062a\u06cc \u0622\u0644\u0645\u0627\u0646\u06cc" },
            { "zh_Hant", "\u0686\u06cc\u0646\u06cc \u0633\u0646\u062a\u06cc" },
            { "kpe", "\u06a9\u067e\u0644\u0647\u200c\u0627\u06cc" },
            { "type.nu.khmr", "\u0627\u0631\u0642\u0627\u0645 \u062e\u0645\u0631\u06cc" },
            { "ilo", "\u0627\u06cc\u0644\u0648\u06a9\u0648\u06cc\u06cc" },
            { "Cprt", "\u0642\u0628\u0631\u0633\u06cc" },
            { "mua", "\u0645\u0627\u0646\u062f\u0627\u0646\u06af\u06cc" },
            { "type.nu.guru", "\u0627\u0631\u0642\u0627\u0645 \u06af\u0648\u0631\u0648\u0645\u062e\u06cc" },
            { "mul", "\u0686\u0646\u062f\u06cc\u0646 \u0632\u0628\u0627\u0646" },
            { "cad", "\u06a9\u0627\u062f\u0648\u06cc\u06cc" },
            { "key.ms", "\u062f\u0633\u062a\u06af\u0627\u0647 \u0627\u0646\u062f\u0627\u0632\u0647\u200c\u06af\u06cc\u0631\u06cc" },
            { "mus", "\u06a9\u0631\u06cc\u06a9\u06cc" },
            { "Glag", "\u06af\u0644\u0627\u06af\u0648\u0644\u06cc\u062a\u06cc" },
            { "gil", "\u06af\u06cc\u0644\u0628\u0631\u062a\u06cc" },
            { "Cher", "\u0686\u0631\u0648\u06a9\u06cc\u0627\u06cc\u06cc" },
            { "car", "\u06a9\u0627\u0631\u06cc\u0628\u06cc" },
            { "type.nu.tamldec", "\u0627\u0631\u0642\u0627\u0645 \u062a\u0627\u0645\u06cc\u0644\u06cc" },
            { "krc", "\u0642\u0631\u0647\u200c\u0686\u0627\u06cc\u06cc\u2010\u0628\u0627\u0644\u06a9\u0627\u0631\u06cc" },
            { "inh", "\u0627\u06cc\u0646\u06af\u0648\u0634\u06cc" },
            { "fa_AF", "\u062f\u0631\u06cc" },
            { "krl", "\u06a9\u0627\u0631\u06cc\u0644\u06cc\u0627\u0646\u06cc" },
            { "%%OXENDICT", "\u0627\u0645\u0644\u0627\u06cc \u0641\u0631\u0647\u0646\u06af \u0627\u0646\u06af\u0644\u06cc\u0633\u06cc \u0622\u06a9\u0633\u0641\u0648\u0631\u062f" },
            { "efi", "\u0627\u0641\u06cc\u06a9\u06cc" },
            { "key.nu", "\u0627\u0639\u062f\u0627\u062f" },
            { "kru", "\u06a9\u0648\u0631\u0648\u062e\u06cc" },
            { "ksb", "\u0634\u0627\u0645\u0628\u0627\u0644\u0627" },
            { "Telu", metaValue_te },
            { "ksf", "\u0628\u0627\u0641\u06cc\u0627\u06cc\u06cc" },
        };
        return data;
    }
}
