/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: Elf64_auxv_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the Elf64_auxv_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=Elf64_auxv_t.class)
public class Elf64_auxv_tPointer extends StructurePointer {

	// NULL
	public static final Elf64_auxv_tPointer NULL = new Elf64_auxv_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected Elf64_auxv_tPointer(long address) {
		super(address);
	}

	public static Elf64_auxv_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static Elf64_auxv_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static Elf64_auxv_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new Elf64_auxv_tPointer(address);
	}

	public Elf64_auxv_tPointer add(long count) {
		return Elf64_auxv_tPointer.cast(address + (Elf64_auxv_t.SIZEOF * count));
	}

	public Elf64_auxv_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public Elf64_auxv_tPointer addOffset(long offset) {
		return Elf64_auxv_tPointer.cast(address + offset);
	}

	public Elf64_auxv_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public Elf64_auxv_tPointer sub(long count) {
		return Elf64_auxv_tPointer.cast(address - (Elf64_auxv_t.SIZEOF * count));
	}

	public Elf64_auxv_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public Elf64_auxv_tPointer subOffset(long offset) {
		return Elf64_auxv_tPointer.cast(address - offset);
	}

	public Elf64_auxv_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public Elf64_auxv_tPointer untag(long mask) {
		return Elf64_auxv_tPointer.cast(address & ~mask);
	}

	public Elf64_auxv_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return Elf64_auxv_t.SIZEOF;
	}

	// Implementation methods

	// U64 a_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_a_typeOffset_", declaredType="U64")
	public UDATA a_type() throws CorruptDataException {
		return new U64(getLongAtOffset(Elf64_auxv_t._a_typeOffset_));
	}

	// U64 a_type
	public UDATAPointer a_typeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_auxv_t._a_typeOffset_));
	}

	// U64 a_un.a_val
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_a_un$a_valOffset_", declaredType="U64")
	public UDATA a_un$a_val() throws CorruptDataException {
		return new U64(getLongAtOffset(Elf64_auxv_t._a_un$a_valOffset_));
	}

	// U64 a_un.a_val
	public UDATAPointer a_un$a_valEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_auxv_t._a_un$a_valOffset_));
	}

}
