/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ThreadEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ThreadEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ThreadEntry.class)
public class ThreadEntryPointer extends StructurePointer {

	// NULL
	public static final ThreadEntryPointer NULL = new ThreadEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ThreadEntryPointer(long address) {
		super(address);
	}

	public static ThreadEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ThreadEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ThreadEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ThreadEntryPointer(address);
	}

	public ThreadEntryPointer add(long count) {
		return ThreadEntryPointer.cast(address + (ThreadEntry.SIZEOF * count));
	}

	public ThreadEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ThreadEntryPointer addOffset(long offset) {
		return ThreadEntryPointer.cast(address + offset);
	}

	public ThreadEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ThreadEntryPointer sub(long count) {
		return ThreadEntryPointer.cast(address - (ThreadEntry.SIZEOF * count));
	}

	public ThreadEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ThreadEntryPointer subOffset(long offset) {
		return ThreadEntryPointer.cast(address - offset);
	}

	public ThreadEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ThreadEntryPointer untag(long mask) {
		return ThreadEntryPointer.cast(address & ~mask);
	}

	public ThreadEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ThreadEntry.SIZEOF;
	}

	// Implementation methods

	// U32 index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_indexOffset_", declaredType="U32")
	public UDATA index() throws CorruptDataException {
		return new U32(getIntAtOffset(ThreadEntry._indexOffset_));
	}

	// U32 index
	public UDATAPointer indexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ThreadEntry._indexOffset_));
	}

	// U64 javaTID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_javaTIDOffset_", declaredType="U64")
	public UDATA javaTID() throws CorruptDataException {
		return new U64(getLongAtOffset(ThreadEntry._javaTIDOffset_));
	}

	// U64 javaTID
	public UDATAPointer javaTIDEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ThreadEntry._javaTIDOffset_));
	}

	// J9UTF8* javaThreadName
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_javaThreadNameOffset_", declaredType="J9UTF8*")
	public J9UTF8Pointer javaThreadName() throws CorruptDataException {
		return J9UTF8Pointer.cast(getPointerAtOffset(ThreadEntry._javaThreadNameOffset_));
	}

	// J9UTF8* javaThreadName
	public PointerPointer javaThreadNameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadEntry._javaThreadNameOffset_));
	}

	// ThreadEntry* next
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nextOffset_", declaredType="ThreadEntry*")
	public ThreadEntryPointer next() throws CorruptDataException {
		return ThreadEntryPointer.cast(getPointerAtOffset(ThreadEntry._nextOffset_));
	}

	// ThreadEntry* next
	public PointerPointer nextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadEntry._nextOffset_));
	}

	// U64 osTID
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_osTIDOffset_", declaredType="U64")
	public UDATA osTID() throws CorruptDataException {
		return new U64(getLongAtOffset(ThreadEntry._osTIDOffset_));
	}

	// U64 osTID
	public UDATAPointer osTIDEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ThreadEntry._osTIDOffset_));
	}

	// J9UTF8* osThreadName
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_osThreadNameOffset_", declaredType="J9UTF8*")
	public J9UTF8Pointer osThreadName() throws CorruptDataException {
		return J9UTF8Pointer.cast(getPointerAtOffset(ThreadEntry._osThreadNameOffset_));
	}

	// J9UTF8* osThreadName
	public PointerPointer osThreadNameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadEntry._osThreadNameOffset_));
	}

	// U32 threadGroupIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_threadGroupIndexOffset_", declaredType="U32")
	public UDATA threadGroupIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(ThreadEntry._threadGroupIndexOffset_));
	}

	// U32 threadGroupIndex
	public UDATAPointer threadGroupIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ThreadEntry._threadGroupIndexOffset_));
	}

	// J9VMThread* vmThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmThreadOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer vmThread() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(ThreadEntry._vmThreadOffset_));
	}

	// J9VMThread* vmThread
	public PointerPointer vmThreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ThreadEntry._vmThreadOffset_));
	}

}
