/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: Elf64_ShdrPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the Elf64_ShdrPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=Elf64_Shdr.class)
public class Elf64_ShdrPointer extends StructurePointer {

	// NULL
	public static final Elf64_ShdrPointer NULL = new Elf64_ShdrPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected Elf64_ShdrPointer(long address) {
		super(address);
	}

	public static Elf64_ShdrPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static Elf64_ShdrPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static Elf64_ShdrPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new Elf64_ShdrPointer(address);
	}

	public Elf64_ShdrPointer add(long count) {
		return Elf64_ShdrPointer.cast(address + (Elf64_Shdr.SIZEOF * count));
	}

	public Elf64_ShdrPointer add(Scalar count) {
		return add(count.longValue());
	}

	public Elf64_ShdrPointer addOffset(long offset) {
		return Elf64_ShdrPointer.cast(address + offset);
	}

	public Elf64_ShdrPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public Elf64_ShdrPointer sub(long count) {
		return Elf64_ShdrPointer.cast(address - (Elf64_Shdr.SIZEOF * count));
	}

	public Elf64_ShdrPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public Elf64_ShdrPointer subOffset(long offset) {
		return Elf64_ShdrPointer.cast(address - offset);
	}

	public Elf64_ShdrPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public Elf64_ShdrPointer untag(long mask) {
		return Elf64_ShdrPointer.cast(address & ~mask);
	}

	public Elf64_ShdrPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return Elf64_Shdr.SIZEOF;
	}

	// Implementation methods

	// Elf64_Addr sh_addr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sh_addrOffset_", declaredType="Elf64_Addr")
	public UDATA sh_addr() throws CorruptDataException {
		return new U64(getLongAtOffset(Elf64_Shdr._sh_addrOffset_));
	}

	// Elf64_Addr sh_addr
	public UDATAPointer sh_addrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_Shdr._sh_addrOffset_));
	}

	// Elf64_Xword sh_addralign
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sh_addralignOffset_", declaredType="Elf64_Xword")
	public UDATA sh_addralign() throws CorruptDataException {
		return new U64(getLongAtOffset(Elf64_Shdr._sh_addralignOffset_));
	}

	// Elf64_Xword sh_addralign
	public UDATAPointer sh_addralignEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_Shdr._sh_addralignOffset_));
	}

	// Elf64_Xword sh_entsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sh_entsizeOffset_", declaredType="Elf64_Xword")
	public UDATA sh_entsize() throws CorruptDataException {
		return new U64(getLongAtOffset(Elf64_Shdr._sh_entsizeOffset_));
	}

	// Elf64_Xword sh_entsize
	public UDATAPointer sh_entsizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_Shdr._sh_entsizeOffset_));
	}

	// Elf64_Xword sh_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sh_flagsOffset_", declaredType="Elf64_Xword")
	public UDATA sh_flags() throws CorruptDataException {
		return new U64(getLongAtOffset(Elf64_Shdr._sh_flagsOffset_));
	}

	// Elf64_Xword sh_flags
	public UDATAPointer sh_flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_Shdr._sh_flagsOffset_));
	}

	// Elf64_Word sh_info
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sh_infoOffset_", declaredType="Elf64_Word")
	public UDATA sh_info() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf64_Shdr._sh_infoOffset_));
	}

	// Elf64_Word sh_info
	public UDATAPointer sh_infoEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_Shdr._sh_infoOffset_));
	}

	// Elf64_Word sh_link
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sh_linkOffset_", declaredType="Elf64_Word")
	public UDATA sh_link() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf64_Shdr._sh_linkOffset_));
	}

	// Elf64_Word sh_link
	public UDATAPointer sh_linkEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_Shdr._sh_linkOffset_));
	}

	// Elf64_Word sh_name
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sh_nameOffset_", declaredType="Elf64_Word")
	public UDATA sh_name() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf64_Shdr._sh_nameOffset_));
	}

	// Elf64_Word sh_name
	public UDATAPointer sh_nameEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_Shdr._sh_nameOffset_));
	}

	// Elf64_Off sh_offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sh_offsetOffset_", declaredType="Elf64_Off")
	public UDATA sh_offset() throws CorruptDataException {
		return new U64(getLongAtOffset(Elf64_Shdr._sh_offsetOffset_));
	}

	// Elf64_Off sh_offset
	public UDATAPointer sh_offsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_Shdr._sh_offsetOffset_));
	}

	// Elf64_Xword sh_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sh_sizeOffset_", declaredType="Elf64_Xword")
	public UDATA sh_size() throws CorruptDataException {
		return new U64(getLongAtOffset(Elf64_Shdr._sh_sizeOffset_));
	}

	// Elf64_Xword sh_size
	public UDATAPointer sh_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_Shdr._sh_sizeOffset_));
	}

	// Elf64_Word sh_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sh_typeOffset_", declaredType="Elf64_Word")
	public UDATA sh_type() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf64_Shdr._sh_typeOffset_));
	}

	// Elf64_Word sh_type
	public UDATAPointer sh_typeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf64_Shdr._sh_typeOffset_));
	}

}
