/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9CRIUCheckpointStatePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9CRIUCheckpointStatePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9CRIUCheckpointState.class)
public class J9CRIUCheckpointStatePointer extends StructurePointer {

	// NULL
	public static final J9CRIUCheckpointStatePointer NULL = new J9CRIUCheckpointStatePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9CRIUCheckpointStatePointer(long address) {
		super(address);
	}

	public static J9CRIUCheckpointStatePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9CRIUCheckpointStatePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9CRIUCheckpointStatePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9CRIUCheckpointStatePointer(address);
	}

	public J9CRIUCheckpointStatePointer add(long count) {
		return J9CRIUCheckpointStatePointer.cast(address + (J9CRIUCheckpointState.SIZEOF * count));
	}

	public J9CRIUCheckpointStatePointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9CRIUCheckpointStatePointer addOffset(long offset) {
		return J9CRIUCheckpointStatePointer.cast(address + offset);
	}

	public J9CRIUCheckpointStatePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9CRIUCheckpointStatePointer sub(long count) {
		return J9CRIUCheckpointStatePointer.cast(address - (J9CRIUCheckpointState.SIZEOF * count));
	}

	public J9CRIUCheckpointStatePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9CRIUCheckpointStatePointer subOffset(long offset) {
		return J9CRIUCheckpointStatePointer.cast(address - offset);
	}

	public J9CRIUCheckpointStatePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9CRIUCheckpointStatePointer untag(long mask) {
		return J9CRIUCheckpointStatePointer.cast(address & ~mask);
	}

	public J9CRIUCheckpointStatePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9CRIUCheckpointState.SIZEOF;
	}

	// Implementation methods

	// I64 checkpointRestoreTimeDelta
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_checkpointRestoreTimeDeltaOffset_", declaredType="I64")
	public IDATA checkpointRestoreTimeDelta() throws CorruptDataException {
		return new I64(getLongAtOffset(J9CRIUCheckpointState._checkpointRestoreTimeDeltaOffset_));
	}

	// I64 checkpointRestoreTimeDelta
	public IDATAPointer checkpointRestoreTimeDeltaEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._checkpointRestoreTimeDeltaOffset_));
	}

	// J9VMThread* checkpointThread
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_checkpointThreadOffset_", declaredType="J9VMThread*")
	public J9VMThreadPointer checkpointThread() throws CorruptDataException {
		return J9VMThreadPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._checkpointThreadOffset_));
	}

	// J9VMThread* checkpointThread
	public PointerPointer checkpointThreadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._checkpointThreadOffset_));
	}

	// J9Pool* classIterationRestoreHookRecords
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_classIterationRestoreHookRecordsOffset_", declaredType="J9Pool*")
	public J9PoolPointer classIterationRestoreHookRecords() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._classIterationRestoreHookRecordsOffset_));
	}

	// J9Pool* classIterationRestoreHookRecords
	public PointerPointer classIterationRestoreHookRecordsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._classIterationRestoreHookRecordsOffset_));
	}

	// U8* cracCheckpointToDir
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cracCheckpointToDirOffset_", declaredType="U8*")
	public U8Pointer cracCheckpointToDir() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9CRIUCheckpointState._cracCheckpointToDirOffset_));
	}

	// U8* cracCheckpointToDir
	public PointerPointer cracCheckpointToDirEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._cracCheckpointToDirOffset_));
	}

	// void* criuDumpFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuDumpFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuDumpFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuDumpFunctionPointerTypeOffset_));
	}

	// void* criuDumpFunctionPointerType
	public PointerPointer criuDumpFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuDumpFunctionPointerTypeOffset_));
	}

	// void* criuInitOptsFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuInitOptsFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuInitOptsFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuInitOptsFunctionPointerTypeOffset_));
	}

	// void* criuInitOptsFunctionPointerType
	public PointerPointer criuInitOptsFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuInitOptsFunctionPointerTypeOffset_));
	}

	// jclass criuJVMCheckpointExceptionClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuJVMCheckpointExceptionClassOffset_", declaredType="jclass")
	public _jclassPointer criuJVMCheckpointExceptionClass() throws CorruptDataException {
		return _jclassPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuJVMCheckpointExceptionClassOffset_));
	}

	// jclass criuJVMCheckpointExceptionClass
	public PointerPointer criuJVMCheckpointExceptionClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuJVMCheckpointExceptionClassOffset_));
	}

	// jmethodID criuJVMCheckpointExceptionInit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuJVMCheckpointExceptionInitOffset_", declaredType="jmethodID")
	public _jmethodIDPointer criuJVMCheckpointExceptionInit() throws CorruptDataException {
		return _jmethodIDPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuJVMCheckpointExceptionInitOffset_));
	}

	// jmethodID criuJVMCheckpointExceptionInit
	public PointerPointer criuJVMCheckpointExceptionInitEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuJVMCheckpointExceptionInitOffset_));
	}

	// jclass criuJVMRestoreExceptionClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuJVMRestoreExceptionClassOffset_", declaredType="jclass")
	public _jclassPointer criuJVMRestoreExceptionClass() throws CorruptDataException {
		return _jclassPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuJVMRestoreExceptionClassOffset_));
	}

	// jclass criuJVMRestoreExceptionClass
	public PointerPointer criuJVMRestoreExceptionClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuJVMRestoreExceptionClassOffset_));
	}

	// jmethodID criuJVMRestoreExceptionInit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuJVMRestoreExceptionInitOffset_", declaredType="jmethodID")
	public _jmethodIDPointer criuJVMRestoreExceptionInit() throws CorruptDataException {
		return _jmethodIDPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuJVMRestoreExceptionInitOffset_));
	}

	// jmethodID criuJVMRestoreExceptionInit
	public PointerPointer criuJVMRestoreExceptionInitEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuJVMRestoreExceptionInitOffset_));
	}

	// void* criuSetAutoDedupFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetAutoDedupFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetAutoDedupFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetAutoDedupFunctionPointerTypeOffset_));
	}

	// void* criuSetAutoDedupFunctionPointerType
	public PointerPointer criuSetAutoDedupFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetAutoDedupFunctionPointerTypeOffset_));
	}

	// void* criuSetExtUnixSkFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetExtUnixSkFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetExtUnixSkFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetExtUnixSkFunctionPointerTypeOffset_));
	}

	// void* criuSetExtUnixSkFunctionPointerType
	public PointerPointer criuSetExtUnixSkFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetExtUnixSkFunctionPointerTypeOffset_));
	}

	// void* criuSetFileLocksFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetFileLocksFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetFileLocksFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetFileLocksFunctionPointerTypeOffset_));
	}

	// void* criuSetFileLocksFunctionPointerType
	public PointerPointer criuSetFileLocksFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetFileLocksFunctionPointerTypeOffset_));
	}

	// void* criuSetGhostFileLimitFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetGhostFileLimitFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetGhostFileLimitFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetGhostFileLimitFunctionPointerTypeOffset_));
	}

	// void* criuSetGhostFileLimitFunctionPointerType
	public PointerPointer criuSetGhostFileLimitFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetGhostFileLimitFunctionPointerTypeOffset_));
	}

	// void* criuSetImagesDirFdFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetImagesDirFdFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetImagesDirFdFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetImagesDirFdFunctionPointerTypeOffset_));
	}

	// void* criuSetImagesDirFdFunctionPointerType
	public PointerPointer criuSetImagesDirFdFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetImagesDirFdFunctionPointerTypeOffset_));
	}

	// void* criuSetLeaveRunningFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetLeaveRunningFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetLeaveRunningFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetLeaveRunningFunctionPointerTypeOffset_));
	}

	// void* criuSetLeaveRunningFunctionPointerType
	public PointerPointer criuSetLeaveRunningFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetLeaveRunningFunctionPointerTypeOffset_));
	}

	// void* criuSetLogFileFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetLogFileFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetLogFileFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetLogFileFunctionPointerTypeOffset_));
	}

	// void* criuSetLogFileFunctionPointerType
	public PointerPointer criuSetLogFileFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetLogFileFunctionPointerTypeOffset_));
	}

	// void* criuSetLogLevelFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetLogLevelFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetLogLevelFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetLogLevelFunctionPointerTypeOffset_));
	}

	// void* criuSetLogLevelFunctionPointerType
	public PointerPointer criuSetLogLevelFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetLogLevelFunctionPointerTypeOffset_));
	}

	// void* criuSetShellJobFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetShellJobFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetShellJobFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetShellJobFunctionPointerTypeOffset_));
	}

	// void* criuSetShellJobFunctionPointerType
	public PointerPointer criuSetShellJobFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetShellJobFunctionPointerTypeOffset_));
	}

	// void* criuSetTcpCloseFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetTcpCloseFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetTcpCloseFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetTcpCloseFunctionPointerTypeOffset_));
	}

	// void* criuSetTcpCloseFunctionPointerType
	public PointerPointer criuSetTcpCloseFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetTcpCloseFunctionPointerTypeOffset_));
	}

	// void* criuSetTcpEstablishedFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetTcpEstablishedFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetTcpEstablishedFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetTcpEstablishedFunctionPointerTypeOffset_));
	}

	// void* criuSetTcpEstablishedFunctionPointerType
	public PointerPointer criuSetTcpEstablishedFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetTcpEstablishedFunctionPointerTypeOffset_));
	}

	// void* criuSetTcpTcpSkipInFlightFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetTcpTcpSkipInFlightFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetTcpTcpSkipInFlightFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetTcpTcpSkipInFlightFunctionPointerTypeOffset_));
	}

	// void* criuSetTcpTcpSkipInFlightFunctionPointerType
	public PointerPointer criuSetTcpTcpSkipInFlightFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetTcpTcpSkipInFlightFunctionPointerTypeOffset_));
	}

	// void* criuSetTrackMemFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetTrackMemFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetTrackMemFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetTrackMemFunctionPointerTypeOffset_));
	}

	// void* criuSetTrackMemFunctionPointerType
	public PointerPointer criuSetTrackMemFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetTrackMemFunctionPointerTypeOffset_));
	}

	// void* criuSetUnprivilegedFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetUnprivilegedFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetUnprivilegedFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetUnprivilegedFunctionPointerTypeOffset_));
	}

	// void* criuSetUnprivilegedFunctionPointerType
	public PointerPointer criuSetUnprivilegedFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetUnprivilegedFunctionPointerTypeOffset_));
	}

	// void* criuSetWorkDirFdFunctionPointerType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSetWorkDirFdFunctionPointerTypeOffset_", declaredType="void*")
	public VoidPointer criuSetWorkDirFdFunctionPointerType() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSetWorkDirFdFunctionPointerTypeOffset_));
	}

	// void* criuSetWorkDirFdFunctionPointerType
	public PointerPointer criuSetWorkDirFdFunctionPointerTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSetWorkDirFdFunctionPointerTypeOffset_));
	}

	// jclass criuSystemCheckpointExceptionClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSystemCheckpointExceptionClassOffset_", declaredType="jclass")
	public _jclassPointer criuSystemCheckpointExceptionClass() throws CorruptDataException {
		return _jclassPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSystemCheckpointExceptionClassOffset_));
	}

	// jclass criuSystemCheckpointExceptionClass
	public PointerPointer criuSystemCheckpointExceptionClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSystemCheckpointExceptionClassOffset_));
	}

	// jmethodID criuSystemCheckpointExceptionInit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSystemCheckpointExceptionInitOffset_", declaredType="jmethodID")
	public _jmethodIDPointer criuSystemCheckpointExceptionInit() throws CorruptDataException {
		return _jmethodIDPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSystemCheckpointExceptionInitOffset_));
	}

	// jmethodID criuSystemCheckpointExceptionInit
	public PointerPointer criuSystemCheckpointExceptionInitEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSystemCheckpointExceptionInitOffset_));
	}

	// jclass criuSystemRestoreExceptionClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSystemRestoreExceptionClassOffset_", declaredType="jclass")
	public _jclassPointer criuSystemRestoreExceptionClass() throws CorruptDataException {
		return _jclassPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSystemRestoreExceptionClassOffset_));
	}

	// jclass criuSystemRestoreExceptionClass
	public PointerPointer criuSystemRestoreExceptionClassEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSystemRestoreExceptionClassOffset_));
	}

	// jmethodID criuSystemRestoreExceptionInit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_criuSystemRestoreExceptionInitOffset_", declaredType="jmethodID")
	public _jmethodIDPointer criuSystemRestoreExceptionInit() throws CorruptDataException {
		return _jmethodIDPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._criuSystemRestoreExceptionInitOffset_));
	}

	// jmethodID criuSystemRestoreExceptionInit
	public PointerPointer criuSystemRestoreExceptionInitEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._criuSystemRestoreExceptionInitOffset_));
	}

	// J9Pool* delayedLockingOperationsRecords
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_delayedLockingOperationsRecordsOffset_", declaredType="J9Pool*")
	public J9PoolPointer delayedLockingOperationsRecords() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._delayedLockingOperationsRecordsOffset_));
	}

	// J9Pool* delayedLockingOperationsRecords
	public PointerPointer delayedLockingOperationsRecordsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._delayedLockingOperationsRecordsOffset_));
	}

	// J9DelayedLockingOpertionsRecord* delayedLockingOperationsRoot
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_delayedLockingOperationsRootOffset_", declaredType="J9DelayedLockingOpertionsRecord*")
	public J9DelayedLockingOpertionsRecordPointer delayedLockingOperationsRoot() throws CorruptDataException {
		return J9DelayedLockingOpertionsRecordPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._delayedLockingOperationsRootOffset_));
	}

	// J9DelayedLockingOpertionsRecord* delayedLockingOperationsRoot
	public PointerPointer delayedLockingOperationsRootEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._delayedLockingOperationsRootOffset_));
	}

	// U32 flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="U32")
	public UDATA flags() throws CorruptDataException {
		return new U32(getIntAtOffset(J9CRIUCheckpointState._flagsOffset_));
	}

	// U32 flags
	public UDATAPointer flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._flagsOffset_));
	}

	// J9Pool* hookRecords
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hookRecordsOffset_", declaredType="J9Pool*")
	public J9PoolPointer hookRecords() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._hookRecordsOffset_));
	}

	// J9Pool* hookRecords
	public PointerPointer hookRecordsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._hookRecordsOffset_));
	}

	// BOOLEAN isDebugOnRestoreEnabled
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_isDebugOnRestoreEnabledOffset_", declaredType="BOOLEAN")
	public UDATA isDebugOnRestoreEnabled() throws CorruptDataException {
		return new U32(getIntAtOffset(J9CRIUCheckpointState._isDebugOnRestoreEnabledOffset_));
	}

	// BOOLEAN isDebugOnRestoreEnabled
	public UDATAPointer isDebugOnRestoreEnabledEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._isDebugOnRestoreEnabledOffset_));
	}

	// UDATA javaDebugThreadCount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_javaDebugThreadCountOffset_", declaredType="UDATA")
	public UDATA javaDebugThreadCount() throws CorruptDataException {
		return getUDATAAtOffset(J9CRIUCheckpointState._javaDebugThreadCountOffset_);
	}

	// UDATA javaDebugThreadCount
	public UDATAPointer javaDebugThreadCountEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._javaDebugThreadCountOffset_));
	}

	// jthread[] javaDebugThreads
	public PointerPointer javaDebugThreadsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._javaDebugThreadsOffset_));
	}

	// IDATA jucForkJoinPoolParallelismOffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jucForkJoinPoolParallelismOffsetOffset_", declaredType="IDATA")
	public IDATA jucForkJoinPoolParallelismOffset() throws CorruptDataException {
		return getIDATAAtOffset(J9CRIUCheckpointState._jucForkJoinPoolParallelismOffsetOffset_);
	}

	// IDATA jucForkJoinPoolParallelismOffset
	public IDATAPointer jucForkJoinPoolParallelismOffsetEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._jucForkJoinPoolParallelismOffsetOffset_));
	}

	// jvmtiEnv* jvmtienv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_jvmtienvOffset_", declaredType="jvmtiEnv*")
	public _jvmtiEnvPointer jvmtienv() throws CorruptDataException {
		return _jvmtiEnvPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._jvmtienvOffset_));
	}

	// jvmtiEnv* jvmtienv
	public PointerPointer jvmtienvEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._jvmtienvOffset_));
	}

	// I64 lastRestoreTimeInNanoseconds
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lastRestoreTimeInNanosecondsOffset_", declaredType="I64")
	public IDATA lastRestoreTimeInNanoseconds() throws CorruptDataException {
		return new I64(getLongAtOffset(J9CRIUCheckpointState._lastRestoreTimeInNanosecondsOffset_));
	}

	// I64 lastRestoreTimeInNanoseconds
	public IDATAPointer lastRestoreTimeInNanosecondsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._lastRestoreTimeInNanosecondsOffset_));
	}

	// UDATA libCRIUHandle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_libCRIUHandleOffset_", declaredType="UDATA")
	public UDATA libCRIUHandle() throws CorruptDataException {
		return getUDATAAtOffset(J9CRIUCheckpointState._libCRIUHandleOffset_);
	}

	// UDATA libCRIUHandle
	public UDATAPointer libCRIUHandleEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._libCRIUHandleOffset_));
	}

	// UDATA maxRetryForNotCheckpointSafe
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_maxRetryForNotCheckpointSafeOffset_", declaredType="UDATA")
	public UDATA maxRetryForNotCheckpointSafe() throws CorruptDataException {
		return getUDATAAtOffset(J9CRIUCheckpointState._maxRetryForNotCheckpointSafeOffset_);
	}

	// UDATA maxRetryForNotCheckpointSafe
	public UDATAPointer maxRetryForNotCheckpointSafeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._maxRetryForNotCheckpointSafeOffset_));
	}

	// I64 processRestoreStartTimeInNanoseconds
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_processRestoreStartTimeInNanosecondsOffset_", declaredType="I64")
	public IDATA processRestoreStartTimeInNanoseconds() throws CorruptDataException {
		return new I64(getLongAtOffset(J9CRIUCheckpointState._processRestoreStartTimeInNanosecondsOffset_));
	}

	// I64 processRestoreStartTimeInNanoseconds
	public IDATAPointer processRestoreStartTimeInNanosecondsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._processRestoreStartTimeInNanosecondsOffset_));
	}

	// jvmtiCapabilities requiredCapabilities
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_requiredCapabilitiesOffset_", declaredType="jvmtiCapabilities")
	public jvmtiCapabilitiesPointer requiredCapabilities() throws CorruptDataException {
		return jvmtiCapabilitiesPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._requiredCapabilitiesOffset_));
	}

	// jvmtiCapabilities requiredCapabilities
	public PointerPointer requiredCapabilitiesEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._requiredCapabilitiesOffset_));
	}

	// U32 requiredGhostFileLimit
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_requiredGhostFileLimitOffset_", declaredType="U32")
	public UDATA requiredGhostFileLimit() throws CorruptDataException {
		return new U32(getIntAtOffset(J9CRIUCheckpointState._requiredGhostFileLimitOffset_));
	}

	// U32 requiredGhostFileLimit
	public UDATAPointer requiredGhostFileLimitEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._requiredGhostFileLimitOffset_));
	}

	// U8* restoreArgsChars
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_restoreArgsCharsOffset_", declaredType="U8*")
	public U8Pointer restoreArgsChars() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(J9CRIUCheckpointState._restoreArgsCharsOffset_));
	}

	// U8* restoreArgsChars
	public PointerPointer restoreArgsCharsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._restoreArgsCharsOffset_));
	}

	// J9VMInitArgs* restoreArgsList
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_restoreArgsListOffset_", declaredType="J9VMInitArgs*")
	public J9VMInitArgsPointer restoreArgsList() throws CorruptDataException {
		return J9VMInitArgsPointer.cast(getPointerAtOffset(J9CRIUCheckpointState._restoreArgsListOffset_));
	}

	// J9VMInitArgs* restoreArgsList
	public PointerPointer restoreArgsListEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._restoreArgsListOffset_));
	}

	// UDATA sleepMillisecondsForNotCheckpointSafe
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sleepMillisecondsForNotCheckpointSafeOffset_", declaredType="UDATA")
	public UDATA sleepMillisecondsForNotCheckpointSafe() throws CorruptDataException {
		return getUDATAAtOffset(J9CRIUCheckpointState._sleepMillisecondsForNotCheckpointSafeOffset_);
	}

	// UDATA sleepMillisecondsForNotCheckpointSafe
	public UDATAPointer sleepMillisecondsForNotCheckpointSafeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9CRIUCheckpointState._sleepMillisecondsForNotCheckpointSafeOffset_));
	}

}
