/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: TR_PersistentJittedBodyInfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the TR_PersistentJittedBodyInfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=TR_PersistentJittedBodyInfo.class)
public class TR_PersistentJittedBodyInfoPointer extends StructurePointer {

	// NULL
	public static final TR_PersistentJittedBodyInfoPointer NULL = new TR_PersistentJittedBodyInfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected TR_PersistentJittedBodyInfoPointer(long address) {
		super(address);
	}

	public static TR_PersistentJittedBodyInfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static TR_PersistentJittedBodyInfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static TR_PersistentJittedBodyInfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new TR_PersistentJittedBodyInfoPointer(address);
	}

	public TR_PersistentJittedBodyInfoPointer add(long count) {
		return TR_PersistentJittedBodyInfoPointer.cast(address + (TR_PersistentJittedBodyInfo.SIZEOF * count));
	}

	public TR_PersistentJittedBodyInfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public TR_PersistentJittedBodyInfoPointer addOffset(long offset) {
		return TR_PersistentJittedBodyInfoPointer.cast(address + offset);
	}

	public TR_PersistentJittedBodyInfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public TR_PersistentJittedBodyInfoPointer sub(long count) {
		return TR_PersistentJittedBodyInfoPointer.cast(address - (TR_PersistentJittedBodyInfo.SIZEOF * count));
	}

	public TR_PersistentJittedBodyInfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public TR_PersistentJittedBodyInfoPointer subOffset(long offset) {
		return TR_PersistentJittedBodyInfoPointer.cast(address - offset);
	}

	public TR_PersistentJittedBodyInfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public TR_PersistentJittedBodyInfoPointer untag(long mask) {
		return TR_PersistentJittedBodyInfoPointer.cast(address & ~mask);
	}

	public TR_PersistentJittedBodyInfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return TR_PersistentJittedBodyInfo.SIZEOF;
	}

	// Implementation methods

	// I32 _dummy1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__dummy1Offset_", declaredType="I32")
	public IDATA _dummy1() throws CorruptDataException {
		return new I32(getIntAtOffset(TR_PersistentJittedBodyInfo.__dummy1Offset_));
	}

	// I32 _dummy1
	public IDATAPointer _dummy1EA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(TR_PersistentJittedBodyInfo.__dummy1Offset_));
	}

	// void* _dummy2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__dummy2Offset_", declaredType="void*")
	public VoidPointer _dummy2() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(TR_PersistentJittedBodyInfo.__dummy2Offset_));
	}

	// void* _dummy2
	public PointerPointer _dummy2EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(TR_PersistentJittedBodyInfo.__dummy2Offset_));
	}

	// void* _dummy3
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__dummy3Offset_", declaredType="void*")
	public VoidPointer _dummy3() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(TR_PersistentJittedBodyInfo.__dummy3Offset_));
	}

	// void* _dummy3
	public PointerPointer _dummy3EA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(TR_PersistentJittedBodyInfo.__dummy3Offset_));
	}

	// void* _mapTable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__mapTableOffset_", declaredType="void*")
	public VoidPointer _mapTable() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(TR_PersistentJittedBodyInfo.__mapTableOffset_));
	}

	// void* _mapTable
	public PointerPointer _mapTableEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(TR_PersistentJittedBodyInfo.__mapTableOffset_));
	}

}
