/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_VerboseEventMetronomeGCEnd
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_VerboseEventMetronomeGCEnd {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __classLoadersUnloadedOffset_;
	public static final int __classLoadersUnloadedTotalOffset_;
	public static final int __classesUnloadedOffset_;
	public static final int __classesUnloadedTotalOffset_;
	public static final int __dynamicSoftReferenceThresholdOffset_;
	public static final int __endIncrementCountOffset_;
	public static final int __finalizableCountOffset_;
	public static final int __finalizableCountTotalOffset_;
	public static final int __heapFreeOffset_;
	public static final int __incrementTimeOffset_;
	public static final int __maxExclusiveAccessTimeOffset_;
	public static final int __maxHeapFreeOffset_;
	public static final int __maxIncrementTimeOffset_;
	public static final int __maxStartPriorityOffset_;
	public static final int __meanExclusiveAccessTimeOffset_;
	public static final int __meanHeapFreeOffset_;
	public static final int __meanIncrementTimeOffset_;
	public static final int __minExclusiveAccessTimeOffset_;
	public static final int __minHeapFreeOffset_;
	public static final int __minIncrementTimeOffset_;
	public static final int __minStartPriorityOffset_;
	public static final int __nonDeterministicSweepOffset_;
	public static final int __nonDeterministicSweepConsecutiveOffset_;
	public static final int __nonDeterministicSweepConsecutiveMaxOffset_;
	public static final int __nonDeterministicSweepDelayOffset_;
	public static final int __nonDeterministicSweepDelayMaxOffset_;
	public static final int __nonDeterministicSweepTotalOffset_;
	public static final int __objectOverflowCountOffset_;
	public static final int __objectOverflowCountTotalOffset_;
	public static final int __phantomReferenceClearCountOffset_;
	public static final int __phantomReferenceClearCountTotalOffset_;
	public static final int __softReferenceClearCountOffset_;
	public static final int __softReferenceClearCountTotalOffset_;
	public static final int __softReferenceThresholdOffset_;
	public static final int __startIncrementCountOffset_;
	public static final int __timeInMilliSecondsOffset_;
	public static final int __weakReferenceClearCountOffset_;
	public static final int __weakReferenceClearCountTotalOffset_;
	public static final int __workPacketOverflowCountOffset_;
	public static final int __workPacketOverflowCountTotalOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__classLoadersUnloadedOffset_ = 0;
		__classLoadersUnloadedTotalOffset_ = 0;
		__classesUnloadedOffset_ = 0;
		__classesUnloadedTotalOffset_ = 0;
		__dynamicSoftReferenceThresholdOffset_ = 0;
		__endIncrementCountOffset_ = 0;
		__finalizableCountOffset_ = 0;
		__finalizableCountTotalOffset_ = 0;
		__heapFreeOffset_ = 0;
		__incrementTimeOffset_ = 0;
		__maxExclusiveAccessTimeOffset_ = 0;
		__maxHeapFreeOffset_ = 0;
		__maxIncrementTimeOffset_ = 0;
		__maxStartPriorityOffset_ = 0;
		__meanExclusiveAccessTimeOffset_ = 0;
		__meanHeapFreeOffset_ = 0;
		__meanIncrementTimeOffset_ = 0;
		__minExclusiveAccessTimeOffset_ = 0;
		__minHeapFreeOffset_ = 0;
		__minIncrementTimeOffset_ = 0;
		__minStartPriorityOffset_ = 0;
		__nonDeterministicSweepOffset_ = 0;
		__nonDeterministicSweepConsecutiveOffset_ = 0;
		__nonDeterministicSweepConsecutiveMaxOffset_ = 0;
		__nonDeterministicSweepDelayOffset_ = 0;
		__nonDeterministicSweepDelayMaxOffset_ = 0;
		__nonDeterministicSweepTotalOffset_ = 0;
		__objectOverflowCountOffset_ = 0;
		__objectOverflowCountTotalOffset_ = 0;
		__phantomReferenceClearCountOffset_ = 0;
		__phantomReferenceClearCountTotalOffset_ = 0;
		__softReferenceClearCountOffset_ = 0;
		__softReferenceClearCountTotalOffset_ = 0;
		__softReferenceThresholdOffset_ = 0;
		__startIncrementCountOffset_ = 0;
		__timeInMilliSecondsOffset_ = 0;
		__weakReferenceClearCountOffset_ = 0;
		__weakReferenceClearCountTotalOffset_ = 0;
		__workPacketOverflowCountOffset_ = 0;
		__workPacketOverflowCountTotalOffset_ = 0;
	}

}
