/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: _IO_FILE
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class _IO_FILE {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int __IO_backup_baseOffset_;
	public static final int __IO_buf_baseOffset_;
	public static final int __IO_buf_endOffset_;
	public static final int __IO_read_baseOffset_;
	public static final int __IO_read_endOffset_;
	public static final int __IO_read_ptrOffset_;
	public static final int __IO_save_baseOffset_;
	public static final int __IO_save_endOffset_;
	public static final int __IO_write_baseOffset_;
	public static final int __IO_write_endOffset_;
	public static final int __IO_write_ptrOffset_;
	public static final int ___pad1Offset_;
	public static final int ___pad2Offset_;
	public static final int ___pad3Offset_;
	public static final int ___pad4Offset_;
	public static final int ___pad5Offset_;
	public static final int __chainOffset_;
	public static final int __cur_columnOffset_;
	public static final int __filenoOffset_;
	public static final int __flagsOffset_;
	public static final int __flags2Offset_;
	public static final int __lockOffset_;
	public static final int __markersOffset_;
	public static final int __modeOffset_;
	public static final int __offsetOffset_;
	public static final int __old_offsetOffset_;
	public static final int __shortbufOffset_;
	public static final int __unused2Offset_;
	public static final int __vtable_offsetOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		__IO_backup_baseOffset_ = 0;
		__IO_buf_baseOffset_ = 0;
		__IO_buf_endOffset_ = 0;
		__IO_read_baseOffset_ = 0;
		__IO_read_endOffset_ = 0;
		__IO_read_ptrOffset_ = 0;
		__IO_save_baseOffset_ = 0;
		__IO_save_endOffset_ = 0;
		__IO_write_baseOffset_ = 0;
		__IO_write_endOffset_ = 0;
		__IO_write_ptrOffset_ = 0;
		___pad1Offset_ = 0;
		___pad2Offset_ = 0;
		___pad3Offset_ = 0;
		___pad4Offset_ = 0;
		___pad5Offset_ = 0;
		__chainOffset_ = 0;
		__cur_columnOffset_ = 0;
		__filenoOffset_ = 0;
		__flagsOffset_ = 0;
		__flags2Offset_ = 0;
		__lockOffset_ = 0;
		__markersOffset_ = 0;
		__modeOffset_ = 0;
		__offsetOffset_ = 0;
		__old_offsetOffset_ = 0;
		__shortbufOffset_ = 0;
		__unused2Offset_ = 0;
		__vtable_offsetOffset_ = 0;
	}

}
