/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: gcMemoryParameters
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class gcMemoryParameters {

	// VM Constants

	public static final long SIZEOF;
	public static final long opt_Xmca;
	public static final long opt_Xmco;
	public static final long opt_Xmcrs;
	public static final long opt_Xmdx;
	public static final long opt_Xmn;
	public static final long opt_Xmns;
	public static final long opt_Xmnx;
	public static final long opt_Xmo;
	public static final long opt_Xmoi;
	public static final long opt_Xmos;
	public static final long opt_Xmox;
	public static final long opt_Xmr;
	public static final long opt_Xmrx;
	public static final long opt_Xms;
	public static final long opt_Xmx;
	public static final long opt_Xsoftmx;
	public static final long opt_none;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		opt_Xmca = 0;
		opt_Xmco = 0;
		opt_Xmcrs = 0;
		opt_Xmdx = 0;
		opt_Xmn = 0;
		opt_Xmns = 0;
		opt_Xmnx = 0;
		opt_Xmo = 0;
		opt_Xmoi = 0;
		opt_Xmos = 0;
		opt_Xmox = 0;
		opt_Xmr = 0;
		opt_Xmrx = 0;
		opt_Xms = 0;
		opt_Xmx = 0;
		opt_Xsoftmx = 0;
		opt_none = 0;
	}

}
