/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: vmem_hugepage_info_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the vmem_hugepage_info_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=vmem_hugepage_info_t.class)
public class vmem_hugepage_info_tPointer extends StructurePointer {

	// NULL
	public static final vmem_hugepage_info_tPointer NULL = new vmem_hugepage_info_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected vmem_hugepage_info_tPointer(long address) {
		super(address);
	}

	public static vmem_hugepage_info_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static vmem_hugepage_info_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static vmem_hugepage_info_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new vmem_hugepage_info_tPointer(address);
	}

	public vmem_hugepage_info_tPointer add(long count) {
		return vmem_hugepage_info_tPointer.cast(address + (vmem_hugepage_info_t.SIZEOF * count));
	}

	public vmem_hugepage_info_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public vmem_hugepage_info_tPointer addOffset(long offset) {
		return vmem_hugepage_info_tPointer.cast(address + offset);
	}

	public vmem_hugepage_info_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public vmem_hugepage_info_tPointer sub(long count) {
		return vmem_hugepage_info_tPointer.cast(address - (vmem_hugepage_info_t.SIZEOF * count));
	}

	public vmem_hugepage_info_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public vmem_hugepage_info_tPointer subOffset(long offset) {
		return vmem_hugepage_info_tPointer.cast(address - offset);
	}

	public vmem_hugepage_info_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public vmem_hugepage_info_tPointer untag(long mask) {
		return vmem_hugepage_info_tPointer.cast(address & ~mask);
	}

	public vmem_hugepage_info_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return vmem_hugepage_info_t.SIZEOF;
	}

	// Implementation methods

	// U64 enabled
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_enabledOffset_", declaredType="U64")
	public UDATA enabled() throws CorruptDataException {
		return new U64(getLongAtOffset(vmem_hugepage_info_t._enabledOffset_));
	}

	// U64 enabled
	public UDATAPointer enabledEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vmem_hugepage_info_t._enabledOffset_));
	}

	// U64 page_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_page_sizeOffset_", declaredType="U64")
	public UDATA page_size() throws CorruptDataException {
		return new U64(getLongAtOffset(vmem_hugepage_info_t._page_sizeOffset_));
	}

	// U64 page_size
	public UDATAPointer page_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vmem_hugepage_info_t._page_sizeOffset_));
	}

	// U64 pages_free
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pages_freeOffset_", declaredType="U64")
	public UDATA pages_free() throws CorruptDataException {
		return new U64(getLongAtOffset(vmem_hugepage_info_t._pages_freeOffset_));
	}

	// U64 pages_free
	public UDATAPointer pages_freeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vmem_hugepage_info_t._pages_freeOffset_));
	}

	// U64 pages_total
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pages_totalOffset_", declaredType="U64")
	public UDATA pages_total() throws CorruptDataException {
		return new U64(getLongAtOffset(vmem_hugepage_info_t._pages_totalOffset_));
	}

	// U64 pages_total
	public UDATAPointer pages_totalEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vmem_hugepage_info_t._pages_totalOffset_));
	}

}
