/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9VMThread
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9VMThread {

	// VM Constants

	public static final long SIZEOF;
	public static final long J9VMSTATE_ATTACHEDDATA_FIND;
	public static final long J9VMSTATE_ATTACHEDDATA_STORE;
	public static final long J9VMSTATE_ATTACHEDDATA_UPDATE;
	public static final long J9VMSTATE_BCVERIFY;
	public static final long J9VMSTATE_GC;
	public static final long J9VMSTATE_GP;
	public static final long J9VMSTATE_GROW_STACK;
	public static final long J9VMSTATE_INTERPRETER;
	public static final long J9VMSTATE_JIT_CODEGEN;
	public static final long J9VMSTATE_JNI;
	public static final long J9VMSTATE_JNI_FROM_JIT;
	public static final long J9VMSTATE_MAJOR;
	public static final long J9VMSTATE_MINOR;
	public static final long J9VMSTATE_RTVERIFY;
	public static final long J9VMSTATE_SHAREDAOT_FIND;
	public static final long J9VMSTATE_SHAREDAOT_STORE;
	public static final long J9VMSTATE_SHAREDCHARARRAY_FIND;
	public static final long J9VMSTATE_SHAREDCHARARRAY_STORE;
	public static final long J9VMSTATE_SHAREDCLASS_FIND;
	public static final long J9VMSTATE_SHAREDCLASS_MARKSTALE;
	public static final long J9VMSTATE_SHAREDCLASS_STORE;
	public static final long J9VMSTATE_SHAREDDATA_FIND;
	public static final long J9VMSTATE_SHAREDDATA_STORE;
	public static final long J9VMSTATE_SNW_STACK_VALIDATE;
	public static final long J9VMTHREAD_ALIGNMENT;
	public static final long J9VMTHREAD_OBJECT_MONITOR_CACHE_SIZE;
	public static final long J9VMTHREAD_RESERVED_C_STACK_FRACTION;
	public static final long J9VMTHREAD_STATE_BLOCKED;
	public static final long J9VMTHREAD_STATE_DEAD;
	public static final long J9VMTHREAD_STATE_INTERRUPTED;
	public static final long J9VMTHREAD_STATE_PARKED;
	public static final long J9VMTHREAD_STATE_PARKED_TIMED;
	public static final long J9VMTHREAD_STATE_RUNNING;
	public static final long J9VMTHREAD_STATE_SLEEPING;
	public static final long J9VMTHREAD_STATE_SUSPENDED;
	public static final long J9VMTHREAD_STATE_UNKNOWN;
	public static final long J9VMTHREAD_STATE_UNREADABLE;
	public static final long J9VMTHREAD_STATE_WAITING;
	public static final long J9VMTHREAD_STATE_WAITING_TIMED;

	// Offsets

	public static final int _activeCardTableBaseOffset_;
	public static final int _activeWalkStateOffset_;
	public static final int _allocateThreadLocalHeapOffset_;
	public static final int _aotVMwithThreadInfoOffset_;
	public static final int _arg0EAOffset_;
	public static final int _asyncEventFlagsOffset_;
	public static final int _blockingEnterObjectOffset_;
	public static final int _bytecodesOffset_;
	public static final int _cardTableShiftSizeOffset_;
	public static final int _cardTableVirtualStartOffset_;
	public static final int _classLoadingStackOffset_;
	public static final int _codertTOCOffset_;
	public static final int _compressObjectReferencesOffset_;
	public static final int _contiguousIndexableHeaderSizeOffset_;
	public static final int _currentExceptionOffset_;
	public static final int _currentOSStackFreeOffset_;
	public static final int _debugEventData1Offset_;
	public static final int _debugEventData2Offset_;
	public static final int _debugEventData3Offset_;
	public static final int _debugEventData4Offset_;
	public static final int _debugEventData5Offset_;
	public static final int _debugEventData6Offset_;
	public static final int _debugEventData7Offset_;
	public static final int _debugEventData8Offset_;
	public static final int _decompilationStackOffset_;
	public static final int _discontiguousIndexableHeaderSizeOffset_;
	public static final int _dltBlockOffset_;
	public static final int _dropBPOffset_;
	public static final int _dropFlagsOffset_;
	public static final int _entryLocalStorageOffset_;
	public static final int _eventFlagsOffset_;
	public static final int _exclusiveVMAccessQueueNextOffset_;
	public static final int _exclusiveVMAccessQueuePreviousOffset_;
	public static final int _ferReturnTypeOffset_;
	public static final int _ferReturnValueOffset_;
	public static final int _ffiArgCountOffset_;
	public static final int _ffiArgsOffset_;
	public static final int _floatTemp1Offset_;
	public static final int _floatTemp2Offset_;
	public static final int _floatTemp3Offset_;
	public static final int _floatTemp4Offset_;
	public static final int _forceEarlyReturnObjectSlotOffset_;
	public static final int _functionsOffset_;
	public static final int _gcClassUnloadingMutexOffset_;
	public static final int _gcClassUnloadingThreadNextOffset_;
	public static final int _gcClassUnloadingThreadPreviousOffset_;
	public static final int _gcExtensionsOffset_;
	public static final int _gcRememberedSetOffset_;
	public static final int _gcTaskListPtrOffset_;
	public static final int _gpInfoOffset_;
	public static final int _gpProtectedOffset_;
	public static final int _gpuInfoOffset_;
	public static final int _gsParametersOffset_;
	public static final int _heapAllocOffset_;
	public static final int _heapBaseForActiveCardTableOffset_;
	public static final int _heapBaseForBarrierRange0Offset_;
	public static final int _heapSizeForActiveCardTableOffset_;
	public static final int _heapSizeForBarrierRange0Offset_;
	public static final int _heapTopOffset_;
	public static final int _highTenureAddressOffset_;
	public static final int _inNativeOffset_;
	public static final int _indexableObjectLayoutOffset_;
	public static final int _inlineStackWalkStateOffset_;
	public static final int _inspectionSuspendCountOffset_;
	public static final int _inspectorCountOffset_;
	public static final int _j2iFrameOffset_;
	public static final int _javaLangThreadLocalCacheOffset_;
	public static final int _javaVMOffset_;
	public static final int _jfrBufferOffset_;
	public static final int _jitArtifactSearchCacheOffset_;
	public static final int _jitCountDeltaOffset_;
	public static final int _jitCurrentRIFlagsOffset_;
	public static final int _jitExceptionOffset_;
	public static final int _jitExceptionHandlerCacheOffset_;
	public static final int _jitMethodToBeCompiledOffset_;
	public static final int _jitPendingRIFlagsOffset_;
	public static final int _jitPrivateDataOffset_;
	public static final int _jitReturnAddressOffset_;
	public static final int _jitStackFrameFlagsOffset_;
	public static final int _jitTOCOffset_;
	public static final int _jitTransitionJumpSlotOffset_;
	public static final int _jitVMwithThreadInfoOffset_;
	public static final int _jmpBufEnvPtrOffset_;
	public static final int _jniArrayCacheOffset_;
	public static final int _jniArrayCache2Offset_;
	public static final int _jniCalloutArgsOffset_;
	public static final int _jniCriticalCopyCountOffset_;
	public static final int _jniCriticalDirectCountOffset_;
	public static final int _jniCurrentReferenceOffset_;
	public static final int _jniLimitReferenceOffset_;
	public static final int _jniLocalReferencesOffset_;
	public static final int _jniMonitorEnterRecordsOffset_;
	public static final int _jniReferenceFramesOffset_;
	public static final int _jniVMAccessCountOffset_;
	public static final int _lastDecompilationOffset_;
	public static final int _linkNextOffset_;
	public static final int _linkPreviousOffset_;
	public static final int _literalsOffset_;
	public static final int _lowTenureAddressOffset_;
	public static final int _ludclBPOffsetOffset_;
	public static final int _ludclInlineDepthOffset_;
	public static final int _maxProfilingCountOffset_;
	public static final int _mgmtBlockedCountOffset_;
	public static final int _mgmtBlockedStartOffset_;
	public static final int _mgmtBlockedTimeStartOffset_;
	public static final int _mgmtBlockedTimeTotalOffset_;
	public static final int _mgmtWaitedCountOffset_;
	public static final int _mgmtWaitedStartOffset_;
	public static final int _mgmtWaitedTimeStartOffset_;
	public static final int _mgmtWaitedTimeTotalOffset_;
	public static final int _monitorEnterRecordPoolOffset_;
	public static final int _monitorEnterRecordsOffset_;
	public static final int _nonZeroAllocateThreadLocalHeapOffset_;
	public static final int _nonZeroHeapAllocOffset_;
	public static final int _nonZeroHeapTopOffset_;
	public static final int _nonZeroTlhPrefetchFTAOffset_;
	public static final int _objectFlagSpinLockAddressOffset_;
	public static final int _objectMonitorLookupCacheOffset_;
	public static final int _omrVMThreadOffset_;
	public static final int _osThreadOffset_;
	public static final int _osrBufferOffset_;
	public static final int _osrFrameIndexOffset_;
	public static final int _osrJittedFrameCopyOffset_;
	public static final int _osrReturnAddressOffset_;
	public static final int _osrScratchBufferOffset_;
	public static final int _outOfMemoryErrorOffset_;
	public static final int _pcOffset_;
	public static final int _privateFlagsOffset_;
	public static final int _privateFlags2Offset_;
	public static final int _profilingBufferCursorOffset_;
	public static final int _profilingBufferEndOffset_;
	public static final int _ptBuffersOffset_;
	public static final int _publicFlagsOffset_;
	public static final int _publicFlagsMutexOffset_;
	public static final int _readBarrierRangeCheckBaseOffset_;
	public static final int _readBarrierRangeCheckBaseCompressedOffset_;
	public static final int _readBarrierRangeCheckTopOffset_;
	public static final int _readBarrierRangeCheckTopCompressedOffset_;
	public static final int _returnValueOffset_;
	public static final int _returnValue2Offset_;
	public static final int _riParametersOffset_;
	public static final int _sATBBarrierRememberedSetFragmentOffset_;
	public static final int _safePointCountOffset_;
	public static final int _segregatedAllocationCacheOffset_;
	public static final int _sidecarEventOffset_;
	public static final int _spOffset_;
	public static final int _stackObjectOffset_;
	public static final int _stackOverflowMarkOffset_;
	public static final int _stackOverflowMark2Offset_;
	public static final int _stackWalkStateOffset_;
	public static final int _startOfMemoryBlockOffset_;
	public static final int _stopThrowableOffset_;
	public static final int _tempSlotOffset_;
	public static final int _threadJfrStateOffset_;
	public static final int _threadObjectOffset_;
	public static final int _tlhPrefetchFTAOffset_;
	public static final int _transactionDiagBlockOffset_;
	public static final int _unsafeIndexableHeaderSizeOffset_;
	public static final int _utfCacheOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		J9VMSTATE_ATTACHEDDATA_FIND = 0;
		J9VMSTATE_ATTACHEDDATA_STORE = 0;
		J9VMSTATE_ATTACHEDDATA_UPDATE = 0;
		J9VMSTATE_BCVERIFY = 0;
		J9VMSTATE_GC = 0;
		J9VMSTATE_GP = 0;
		J9VMSTATE_GROW_STACK = 0;
		J9VMSTATE_INTERPRETER = 0;
		J9VMSTATE_JIT_CODEGEN = 0;
		J9VMSTATE_JNI = 0;
		J9VMSTATE_JNI_FROM_JIT = 0;
		J9VMSTATE_MAJOR = 0;
		J9VMSTATE_MINOR = 0;
		J9VMSTATE_RTVERIFY = 0;
		J9VMSTATE_SHAREDAOT_FIND = 0;
		J9VMSTATE_SHAREDAOT_STORE = 0;
		J9VMSTATE_SHAREDCHARARRAY_FIND = 0;
		J9VMSTATE_SHAREDCHARARRAY_STORE = 0;
		J9VMSTATE_SHAREDCLASS_FIND = 0;
		J9VMSTATE_SHAREDCLASS_MARKSTALE = 0;
		J9VMSTATE_SHAREDCLASS_STORE = 0;
		J9VMSTATE_SHAREDDATA_FIND = 0;
		J9VMSTATE_SHAREDDATA_STORE = 0;
		J9VMSTATE_SNW_STACK_VALIDATE = 0;
		J9VMTHREAD_ALIGNMENT = 0;
		J9VMTHREAD_OBJECT_MONITOR_CACHE_SIZE = 0;
		J9VMTHREAD_RESERVED_C_STACK_FRACTION = 0;
		J9VMTHREAD_STATE_BLOCKED = 0;
		J9VMTHREAD_STATE_DEAD = 0;
		J9VMTHREAD_STATE_INTERRUPTED = 0;
		J9VMTHREAD_STATE_PARKED = 0;
		J9VMTHREAD_STATE_PARKED_TIMED = 0;
		J9VMTHREAD_STATE_RUNNING = 0;
		J9VMTHREAD_STATE_SLEEPING = 0;
		J9VMTHREAD_STATE_SUSPENDED = 0;
		J9VMTHREAD_STATE_UNKNOWN = 0;
		J9VMTHREAD_STATE_UNREADABLE = 0;
		J9VMTHREAD_STATE_WAITING = 0;
		J9VMTHREAD_STATE_WAITING_TIMED = 0;
		_activeCardTableBaseOffset_ = 0;
		_activeWalkStateOffset_ = 0;
		_allocateThreadLocalHeapOffset_ = 0;
		_aotVMwithThreadInfoOffset_ = 0;
		_arg0EAOffset_ = 0;
		_asyncEventFlagsOffset_ = 0;
		_blockingEnterObjectOffset_ = 0;
		_bytecodesOffset_ = 0;
		_cardTableShiftSizeOffset_ = 0;
		_cardTableVirtualStartOffset_ = 0;
		_classLoadingStackOffset_ = 0;
		_codertTOCOffset_ = 0;
		_compressObjectReferencesOffset_ = 0;
		_contiguousIndexableHeaderSizeOffset_ = 0;
		_currentExceptionOffset_ = 0;
		_currentOSStackFreeOffset_ = 0;
		_debugEventData1Offset_ = 0;
		_debugEventData2Offset_ = 0;
		_debugEventData3Offset_ = 0;
		_debugEventData4Offset_ = 0;
		_debugEventData5Offset_ = 0;
		_debugEventData6Offset_ = 0;
		_debugEventData7Offset_ = 0;
		_debugEventData8Offset_ = 0;
		_decompilationStackOffset_ = 0;
		_discontiguousIndexableHeaderSizeOffset_ = 0;
		_dltBlockOffset_ = 0;
		_dropBPOffset_ = 0;
		_dropFlagsOffset_ = 0;
		_entryLocalStorageOffset_ = 0;
		_eventFlagsOffset_ = 0;
		_exclusiveVMAccessQueueNextOffset_ = 0;
		_exclusiveVMAccessQueuePreviousOffset_ = 0;
		_ferReturnTypeOffset_ = 0;
		_ferReturnValueOffset_ = 0;
		_ffiArgCountOffset_ = 0;
		_ffiArgsOffset_ = 0;
		_floatTemp1Offset_ = 0;
		_floatTemp2Offset_ = 0;
		_floatTemp3Offset_ = 0;
		_floatTemp4Offset_ = 0;
		_forceEarlyReturnObjectSlotOffset_ = 0;
		_functionsOffset_ = 0;
		_gcClassUnloadingMutexOffset_ = 0;
		_gcClassUnloadingThreadNextOffset_ = 0;
		_gcClassUnloadingThreadPreviousOffset_ = 0;
		_gcExtensionsOffset_ = 0;
		_gcRememberedSetOffset_ = 0;
		_gcTaskListPtrOffset_ = 0;
		_gpInfoOffset_ = 0;
		_gpProtectedOffset_ = 0;
		_gpuInfoOffset_ = 0;
		_gsParametersOffset_ = 0;
		_heapAllocOffset_ = 0;
		_heapBaseForActiveCardTableOffset_ = 0;
		_heapBaseForBarrierRange0Offset_ = 0;
		_heapSizeForActiveCardTableOffset_ = 0;
		_heapSizeForBarrierRange0Offset_ = 0;
		_heapTopOffset_ = 0;
		_highTenureAddressOffset_ = 0;
		_inNativeOffset_ = 0;
		_indexableObjectLayoutOffset_ = 0;
		_inlineStackWalkStateOffset_ = 0;
		_inspectionSuspendCountOffset_ = 0;
		_inspectorCountOffset_ = 0;
		_j2iFrameOffset_ = 0;
		_javaLangThreadLocalCacheOffset_ = 0;
		_javaVMOffset_ = 0;
		_jfrBufferOffset_ = 0;
		_jitArtifactSearchCacheOffset_ = 0;
		_jitCountDeltaOffset_ = 0;
		_jitCurrentRIFlagsOffset_ = 0;
		_jitExceptionOffset_ = 0;
		_jitExceptionHandlerCacheOffset_ = 0;
		_jitMethodToBeCompiledOffset_ = 0;
		_jitPendingRIFlagsOffset_ = 0;
		_jitPrivateDataOffset_ = 0;
		_jitReturnAddressOffset_ = 0;
		_jitStackFrameFlagsOffset_ = 0;
		_jitTOCOffset_ = 0;
		_jitTransitionJumpSlotOffset_ = 0;
		_jitVMwithThreadInfoOffset_ = 0;
		_jmpBufEnvPtrOffset_ = 0;
		_jniArrayCacheOffset_ = 0;
		_jniArrayCache2Offset_ = 0;
		_jniCalloutArgsOffset_ = 0;
		_jniCriticalCopyCountOffset_ = 0;
		_jniCriticalDirectCountOffset_ = 0;
		_jniCurrentReferenceOffset_ = 0;
		_jniLimitReferenceOffset_ = 0;
		_jniLocalReferencesOffset_ = 0;
		_jniMonitorEnterRecordsOffset_ = 0;
		_jniReferenceFramesOffset_ = 0;
		_jniVMAccessCountOffset_ = 0;
		_lastDecompilationOffset_ = 0;
		_linkNextOffset_ = 0;
		_linkPreviousOffset_ = 0;
		_literalsOffset_ = 0;
		_lowTenureAddressOffset_ = 0;
		_ludclBPOffsetOffset_ = 0;
		_ludclInlineDepthOffset_ = 0;
		_maxProfilingCountOffset_ = 0;
		_mgmtBlockedCountOffset_ = 0;
		_mgmtBlockedStartOffset_ = 0;
		_mgmtBlockedTimeStartOffset_ = 0;
		_mgmtBlockedTimeTotalOffset_ = 0;
		_mgmtWaitedCountOffset_ = 0;
		_mgmtWaitedStartOffset_ = 0;
		_mgmtWaitedTimeStartOffset_ = 0;
		_mgmtWaitedTimeTotalOffset_ = 0;
		_monitorEnterRecordPoolOffset_ = 0;
		_monitorEnterRecordsOffset_ = 0;
		_nonZeroAllocateThreadLocalHeapOffset_ = 0;
		_nonZeroHeapAllocOffset_ = 0;
		_nonZeroHeapTopOffset_ = 0;
		_nonZeroTlhPrefetchFTAOffset_ = 0;
		_objectFlagSpinLockAddressOffset_ = 0;
		_objectMonitorLookupCacheOffset_ = 0;
		_omrVMThreadOffset_ = 0;
		_osThreadOffset_ = 0;
		_osrBufferOffset_ = 0;
		_osrFrameIndexOffset_ = 0;
		_osrJittedFrameCopyOffset_ = 0;
		_osrReturnAddressOffset_ = 0;
		_osrScratchBufferOffset_ = 0;
		_outOfMemoryErrorOffset_ = 0;
		_pcOffset_ = 0;
		_privateFlagsOffset_ = 0;
		_privateFlags2Offset_ = 0;
		_profilingBufferCursorOffset_ = 0;
		_profilingBufferEndOffset_ = 0;
		_ptBuffersOffset_ = 0;
		_publicFlagsOffset_ = 0;
		_publicFlagsMutexOffset_ = 0;
		_readBarrierRangeCheckBaseOffset_ = 0;
		_readBarrierRangeCheckBaseCompressedOffset_ = 0;
		_readBarrierRangeCheckTopOffset_ = 0;
		_readBarrierRangeCheckTopCompressedOffset_ = 0;
		_returnValueOffset_ = 0;
		_returnValue2Offset_ = 0;
		_riParametersOffset_ = 0;
		_sATBBarrierRememberedSetFragmentOffset_ = 0;
		_safePointCountOffset_ = 0;
		_segregatedAllocationCacheOffset_ = 0;
		_sidecarEventOffset_ = 0;
		_spOffset_ = 0;
		_stackObjectOffset_ = 0;
		_stackOverflowMarkOffset_ = 0;
		_stackOverflowMark2Offset_ = 0;
		_stackWalkStateOffset_ = 0;
		_startOfMemoryBlockOffset_ = 0;
		_stopThrowableOffset_ = 0;
		_tempSlotOffset_ = 0;
		_threadJfrStateOffset_ = 0;
		_threadObjectOffset_ = 0;
		_tlhPrefetchFTAOffset_ = 0;
		_transactionDiagBlockOffset_ = 0;
		_unsafeIndexableHeaderSizeOffset_ = 0;
		_utfCacheOffset_ = 0;
	}

}
