/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: re_pattern_bufferPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the re_pattern_bufferPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=re_pattern_buffer.class)
public class re_pattern_bufferPointer extends StructurePointer {

	// NULL
	public static final re_pattern_bufferPointer NULL = new re_pattern_bufferPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected re_pattern_bufferPointer(long address) {
		super(address);
	}

	public static re_pattern_bufferPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static re_pattern_bufferPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static re_pattern_bufferPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new re_pattern_bufferPointer(address);
	}

	public re_pattern_bufferPointer add(long count) {
		return re_pattern_bufferPointer.cast(address + (re_pattern_buffer.SIZEOF * count));
	}

	public re_pattern_bufferPointer add(Scalar count) {
		return add(count.longValue());
	}

	public re_pattern_bufferPointer addOffset(long offset) {
		return re_pattern_bufferPointer.cast(address + offset);
	}

	public re_pattern_bufferPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public re_pattern_bufferPointer sub(long count) {
		return re_pattern_bufferPointer.cast(address - (re_pattern_buffer.SIZEOF * count));
	}

	public re_pattern_bufferPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public re_pattern_bufferPointer subOffset(long offset) {
		return re_pattern_bufferPointer.cast(address - offset);
	}

	public re_pattern_bufferPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public re_pattern_bufferPointer untag(long mask) {
		return re_pattern_bufferPointer.cast(address & ~mask);
	}

	public re_pattern_bufferPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return re_pattern_buffer.SIZEOF;
	}

	// Implementation methods

	// U64 __allocated
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___allocatedOffset_", declaredType="U64")
	public UDATA __allocated() throws CorruptDataException {
		return new U64(getLongAtOffset(re_pattern_buffer.___allocatedOffset_));
	}

	// U64 __allocated
	public UDATAPointer __allocatedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(re_pattern_buffer.___allocatedOffset_));
	}

	// U8* __buffer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___bufferOffset_", declaredType="U8*")
	public U8Pointer __buffer() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(re_pattern_buffer.___bufferOffset_));
	}

	// U8* __buffer
	public PointerPointer __bufferEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(re_pattern_buffer.___bufferOffset_));
	}

	// U32:1 __can_be_null
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___can_be_nullOffset_", declaredType="U32:1")
	public UDATA __can_be_null() throws CorruptDataException {
		return getU32Bitfield(re_pattern_buffer.___can_be_null_s_, re_pattern_buffer.___can_be_null_b_);
	}

	// U8* __fastmap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___fastmapOffset_", declaredType="U8*")
	public U8Pointer __fastmap() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(re_pattern_buffer.___fastmapOffset_));
	}

	// U8* __fastmap
	public PointerPointer __fastmapEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(re_pattern_buffer.___fastmapOffset_));
	}

	// U32:1 __fastmap_accurate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___fastmap_accurateOffset_", declaredType="U32:1")
	public UDATA __fastmap_accurate() throws CorruptDataException {
		return getU32Bitfield(re_pattern_buffer.___fastmap_accurate_s_, re_pattern_buffer.___fastmap_accurate_b_);
	}

	// U32:1 __newline_anchor
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___newline_anchorOffset_", declaredType="U32:1")
	public UDATA __newline_anchor() throws CorruptDataException {
		return getU32Bitfield(re_pattern_buffer.___newline_anchor_s_, re_pattern_buffer.___newline_anchor_b_);
	}

	// U32:1 __no_sub
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___no_subOffset_", declaredType="U32:1")
	public UDATA __no_sub() throws CorruptDataException {
		return getU32Bitfield(re_pattern_buffer.___no_sub_s_, re_pattern_buffer.___no_sub_b_);
	}

	// U32:1 __not_bol
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___not_bolOffset_", declaredType="U32:1")
	public UDATA __not_bol() throws CorruptDataException {
		return getU32Bitfield(re_pattern_buffer.___not_bol_s_, re_pattern_buffer.___not_bol_b_);
	}

	// U32:1 __not_eol
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___not_eolOffset_", declaredType="U32:1")
	public UDATA __not_eol() throws CorruptDataException {
		return getU32Bitfield(re_pattern_buffer.___not_eol_s_, re_pattern_buffer.___not_eol_b_);
	}

	// U32:2 __regs_allocated
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___regs_allocatedOffset_", declaredType="U32:2")
	public UDATA __regs_allocated() throws CorruptDataException {
		return getU32Bitfield(re_pattern_buffer.___regs_allocated_s_, re_pattern_buffer.___regs_allocated_b_);
	}

	// reg_syntax_t __syntax
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___syntaxOffset_", declaredType="reg_syntax_t")
	public UDATA __syntax() throws CorruptDataException {
		return new U64(getLongAtOffset(re_pattern_buffer.___syntaxOffset_));
	}

	// reg_syntax_t __syntax
	public UDATAPointer __syntaxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(re_pattern_buffer.___syntaxOffset_));
	}

	// U8* __translate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___translateOffset_", declaredType="U8*")
	public U8Pointer __translate() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(re_pattern_buffer.___translateOffset_));
	}

	// U8* __translate
	public PointerPointer __translateEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(re_pattern_buffer.___translateOffset_));
	}

	// U64 __used
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___usedOffset_", declaredType="U64")
	public UDATA __used() throws CorruptDataException {
		return new U64(getLongAtOffset(re_pattern_buffer.___usedOffset_));
	}

	// U64 __used
	public UDATAPointer __usedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(re_pattern_buffer.___usedOffset_));
	}

	// size_t re_nsub
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_re_nsubOffset_", declaredType="size_t")
	public UDATA re_nsub() throws CorruptDataException {
		return new U64(getLongAtOffset(re_pattern_buffer._re_nsubOffset_));
	}

	// size_t re_nsub
	public UDATAPointer re_nsubEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(re_pattern_buffer._re_nsubOffset_));
	}

}
