/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_ObjectAllocationAPICompressedPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_ObjectAllocationAPICompressedPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_ObjectAllocationAPICompressed.class)
public class MM_ObjectAllocationAPICompressedPointer extends StructurePointer {

	// NULL
	public static final MM_ObjectAllocationAPICompressedPointer NULL = new MM_ObjectAllocationAPICompressedPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_ObjectAllocationAPICompressedPointer(long address) {
		super(address);
	}

	public static MM_ObjectAllocationAPICompressedPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_ObjectAllocationAPICompressedPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_ObjectAllocationAPICompressedPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MM_ObjectAllocationAPICompressedPointer(address);
	}

	public MM_ObjectAllocationAPICompressedPointer add(long count) {
		return MM_ObjectAllocationAPICompressedPointer.cast(address + (MM_ObjectAllocationAPICompressed.SIZEOF * count));
	}

	public MM_ObjectAllocationAPICompressedPointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_ObjectAllocationAPICompressedPointer addOffset(long offset) {
		return MM_ObjectAllocationAPICompressedPointer.cast(address + offset);
	}

	public MM_ObjectAllocationAPICompressedPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_ObjectAllocationAPICompressedPointer sub(long count) {
		return MM_ObjectAllocationAPICompressedPointer.cast(address - (MM_ObjectAllocationAPICompressed.SIZEOF * count));
	}

	public MM_ObjectAllocationAPICompressedPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_ObjectAllocationAPICompressedPointer subOffset(long offset) {
		return MM_ObjectAllocationAPICompressedPointer.cast(address - offset);
	}

	public MM_ObjectAllocationAPICompressedPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_ObjectAllocationAPICompressedPointer untag(long mask) {
		return MM_ObjectAllocationAPICompressedPointer.cast(address & ~mask);
	}

	public MM_ObjectAllocationAPICompressedPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_ObjectAllocationAPICompressed.SIZEOF;
	}

	// Implementation methods

	// U64 _contiguousIndexableHeaderSize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__contiguousIndexableHeaderSizeOffset_", declaredType="U64")
	public UDATA _contiguousIndexableHeaderSize() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ObjectAllocationAPICompressed.__contiguousIndexableHeaderSizeOffset_));
	}

	// U64 _contiguousIndexableHeaderSize
	public UDATAPointer _contiguousIndexableHeaderSizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ObjectAllocationAPICompressed.__contiguousIndexableHeaderSizeOffset_));
	}

	// const U64 _gcAllocationType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__gcAllocationTypeOffset_", declaredType="const U64")
	public UDATA _gcAllocationType() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ObjectAllocationAPICompressed.__gcAllocationTypeOffset_));
	}

	// const U64 _gcAllocationType
	public UDATAPointer _gcAllocationTypeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ObjectAllocationAPICompressed.__gcAllocationTypeOffset_));
	}

	// const U64 _initializeSlotsOnTLHAllocate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__initializeSlotsOnTLHAllocateOffset_", declaredType="const U64")
	public UDATA _initializeSlotsOnTLHAllocate() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ObjectAllocationAPICompressed.__initializeSlotsOnTLHAllocateOffset_));
	}

	// const U64 _initializeSlotsOnTLHAllocate
	public UDATAPointer _initializeSlotsOnTLHAllocateEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ObjectAllocationAPICompressed.__initializeSlotsOnTLHAllocateOffset_));
	}

	// bool _isIndexableDataAddrPresent
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__isIndexableDataAddrPresentOffset_", declaredType="bool")
	public boolean _isIndexableDataAddrPresent() throws CorruptDataException {
		return getBoolAtOffset(MM_ObjectAllocationAPICompressed.__isIndexableDataAddrPresentOffset_);
	}

	// bool _isIndexableDataAddrPresent
	public BoolPointer _isIndexableDataAddrPresentEA() throws CorruptDataException {
		return BoolPointer.cast(nonNullFieldEA(MM_ObjectAllocationAPICompressed.__isIndexableDataAddrPresentOffset_));
	}

	// const MM_ObjectAccessBarrierAPICompressed _objectAccessBarrierAPI
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__objectAccessBarrierAPIOffset_", declaredType="const MM_ObjectAccessBarrierAPICompressed")
	public MM_ObjectAccessBarrierAPICompressedPointer _objectAccessBarrierAPI() throws CorruptDataException {
		return MM_ObjectAccessBarrierAPICompressedPointer.cast(nonNullFieldEA(MM_ObjectAllocationAPICompressed.__objectAccessBarrierAPIOffset_));
	}

	// const MM_ObjectAccessBarrierAPICompressed _objectAccessBarrierAPI
	public PointerPointer _objectAccessBarrierAPIEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_ObjectAllocationAPICompressed.__objectAccessBarrierAPIOffset_));
	}

	// const U64 _objectAlignmentInBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__objectAlignmentInBytesOffset_", declaredType="const U64")
	public UDATA _objectAlignmentInBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_ObjectAllocationAPICompressed.__objectAlignmentInBytesOffset_));
	}

	// const U64 _objectAlignmentInBytes
	public UDATAPointer _objectAlignmentInBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_ObjectAllocationAPICompressed.__objectAlignmentInBytesOffset_));
	}

	// const J9VMGCSizeClasses* _sizeClasses
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__sizeClassesOffset_", declaredType="const J9VMGCSizeClasses*")
	public J9VMGCSizeClassesPointer _sizeClasses() throws CorruptDataException {
		return J9VMGCSizeClassesPointer.cast(getPointerAtOffset(MM_ObjectAllocationAPICompressed.__sizeClassesOffset_));
	}

	// const J9VMGCSizeClasses* _sizeClasses
	public PointerPointer _sizeClassesEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_ObjectAllocationAPICompressed.__sizeClassesOffset_));
	}

}
