/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ModuleRequireEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ModuleRequireEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ModuleRequireEntry.class)
public class ModuleRequireEntryPointer extends StructurePointer {

	// NULL
	public static final ModuleRequireEntryPointer NULL = new ModuleRequireEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ModuleRequireEntryPointer(long address) {
		super(address);
	}

	public static ModuleRequireEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ModuleRequireEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ModuleRequireEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ModuleRequireEntryPointer(address);
	}

	public ModuleRequireEntryPointer add(long count) {
		return ModuleRequireEntryPointer.cast(address + (ModuleRequireEntry.SIZEOF * count));
	}

	public ModuleRequireEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ModuleRequireEntryPointer addOffset(long offset) {
		return ModuleRequireEntryPointer.cast(address + offset);
	}

	public ModuleRequireEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ModuleRequireEntryPointer sub(long count) {
		return ModuleRequireEntryPointer.cast(address - (ModuleRequireEntry.SIZEOF * count));
	}

	public ModuleRequireEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ModuleRequireEntryPointer subOffset(long offset) {
		return ModuleRequireEntryPointer.cast(address - offset);
	}

	public ModuleRequireEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ModuleRequireEntryPointer untag(long mask) {
		return ModuleRequireEntryPointer.cast(address & ~mask);
	}

	public ModuleRequireEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ModuleRequireEntry.SIZEOF;
	}

	// Implementation methods

	// U32 requiredModuleIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_requiredModuleIndexOffset_", declaredType="U32")
	public UDATA requiredModuleIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(ModuleRequireEntry._requiredModuleIndexOffset_));
	}

	// U32 requiredModuleIndex
	public UDATAPointer requiredModuleIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ModuleRequireEntry._requiredModuleIndexOffset_));
	}

	// U32 sourceModuleIndex
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_sourceModuleIndexOffset_", declaredType="U32")
	public UDATA sourceModuleIndex() throws CorruptDataException {
		return new U32(getIntAtOffset(ModuleRequireEntry._sourceModuleIndexOffset_));
	}

	// U32 sourceModuleIndex
	public UDATAPointer sourceModuleIndexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ModuleRequireEntry._sourceModuleIndexOffset_));
	}

	// I64 ticks
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ticksOffset_", declaredType="I64")
	public IDATA ticks() throws CorruptDataException {
		return new I64(getLongAtOffset(ModuleRequireEntry._ticksOffset_));
	}

	// I64 ticks
	public IDATAPointer ticksEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ModuleRequireEntry._ticksOffset_));
	}

}
