/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9CudaJitOptions
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9CudaJitOptions {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _cacheModeOffset_;
	public static final int _errorLogBufferOffset_;
	public static final int _errorLogBufferSizeOffset_;
	public static final int _fallbackStrategyOffset_;
	public static final int _generateDebugInfoOffset_;
	public static final int _generateLineInfoOffset_;
	public static final int _infoLogBufferOffset_;
	public static final int _infoLogBufferSizeOffset_;
	public static final int _maxRegistersOffset_;
	public static final int _optimizationLevelOffset_;
	public static final int _recordWallTimeOffset_;
	public static final int _targetOffset_;
	public static final int _targetFromContextOffset_;
	public static final int _threadsPerBlockOffset_;
	public static final int _verboseLoggingOffset_;
	public static final int _wallTimeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_cacheModeOffset_ = 0;
		_errorLogBufferOffset_ = 0;
		_errorLogBufferSizeOffset_ = 0;
		_fallbackStrategyOffset_ = 0;
		_generateDebugInfoOffset_ = 0;
		_generateLineInfoOffset_ = 0;
		_infoLogBufferOffset_ = 0;
		_infoLogBufferSizeOffset_ = 0;
		_maxRegistersOffset_ = 0;
		_optimizationLevelOffset_ = 0;
		_recordWallTimeOffset_ = 0;
		_targetOffset_ = 0;
		_targetFromContextOffset_ = 0;
		_threadsPerBlockOffset_ = 0;
		_verboseLoggingOffset_ = 0;
		_wallTimeOffset_ = 0;
	}

}
