/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: JFRConstantEventsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the JFRConstantEventsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=JFRConstantEvents.class)
public class JFRConstantEventsPointer extends StructurePointer {

	// NULL
	public static final JFRConstantEventsPointer NULL = new JFRConstantEventsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected JFRConstantEventsPointer(long address) {
		super(address);
	}

	public static JFRConstantEventsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static JFRConstantEventsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static JFRConstantEventsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new JFRConstantEventsPointer(address);
	}

	public JFRConstantEventsPointer add(long count) {
		return JFRConstantEventsPointer.cast(address + (JFRConstantEvents.SIZEOF * count));
	}

	public JFRConstantEventsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public JFRConstantEventsPointer addOffset(long offset) {
		return JFRConstantEventsPointer.cast(address + offset);
	}

	public JFRConstantEventsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public JFRConstantEventsPointer sub(long count) {
		return JFRConstantEventsPointer.cast(address - (JFRConstantEvents.SIZEOF * count));
	}

	public JFRConstantEventsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public JFRConstantEventsPointer subOffset(long offset) {
		return JFRConstantEventsPointer.cast(address - offset);
	}

	public JFRConstantEventsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public JFRConstantEventsPointer untag(long mask) {
		return JFRConstantEventsPointer.cast(address & ~mask);
	}

	public JFRConstantEventsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return JFRConstantEvents.SIZEOF;
	}

	// Implementation methods

	// CPUInformationEntry CPUInfoEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_CPUInfoEntryOffset_", declaredType="CPUInformationEntry")
	public CPUInformationEntryPointer CPUInfoEntry() throws CorruptDataException {
		return CPUInformationEntryPointer.cast(nonNullFieldEA(JFRConstantEvents._CPUInfoEntryOffset_));
	}

	// CPUInformationEntry CPUInfoEntry
	public PointerPointer CPUInfoEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JFRConstantEvents._CPUInfoEntryOffset_));
	}

	// GCHeapConfigurationEntry GCHeapConfigEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_GCHeapConfigEntryOffset_", declaredType="GCHeapConfigurationEntry")
	public GCHeapConfigurationEntryPointer GCHeapConfigEntry() throws CorruptDataException {
		return GCHeapConfigurationEntryPointer.cast(nonNullFieldEA(JFRConstantEvents._GCHeapConfigEntryOffset_));
	}

	// GCHeapConfigurationEntry GCHeapConfigEntry
	public PointerPointer GCHeapConfigEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JFRConstantEvents._GCHeapConfigEntryOffset_));
	}

	// JVMInformationEntry JVMInfoEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_JVMInfoEntryOffset_", declaredType="JVMInformationEntry")
	public JVMInformationEntryPointer JVMInfoEntry() throws CorruptDataException {
		return JVMInformationEntryPointer.cast(nonNullFieldEA(JFRConstantEvents._JVMInfoEntryOffset_));
	}

	// JVMInformationEntry JVMInfoEntry
	public PointerPointer JVMInfoEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JFRConstantEvents._JVMInfoEntryOffset_));
	}

	// OSInformationEntry OSInfoEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_OSInfoEntryOffset_", declaredType="OSInformationEntry")
	public OSInformationEntryPointer OSInfoEntry() throws CorruptDataException {
		return OSInformationEntryPointer.cast(nonNullFieldEA(JFRConstantEvents._OSInfoEntryOffset_));
	}

	// OSInformationEntry OSInfoEntry
	public PointerPointer OSInfoEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JFRConstantEvents._OSInfoEntryOffset_));
	}

	// VirtualizationInformationEntry VirtualizationInfoEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_VirtualizationInfoEntryOffset_", declaredType="VirtualizationInformationEntry")
	public VirtualizationInformationEntryPointer VirtualizationInfoEntry() throws CorruptDataException {
		return VirtualizationInformationEntryPointer.cast(nonNullFieldEA(JFRConstantEvents._VirtualizationInfoEntryOffset_));
	}

	// VirtualizationInformationEntry VirtualizationInfoEntry
	public PointerPointer VirtualizationInfoEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JFRConstantEvents._VirtualizationInfoEntryOffset_));
	}

	// YoungGenerationConfigurationEntry YoungGenConfigEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_YoungGenConfigEntryOffset_", declaredType="YoungGenerationConfigurationEntry")
	public YoungGenerationConfigurationEntryPointer YoungGenConfigEntry() throws CorruptDataException {
		return YoungGenerationConfigurationEntryPointer.cast(nonNullFieldEA(JFRConstantEvents._YoungGenConfigEntryOffset_));
	}

	// YoungGenerationConfigurationEntry YoungGenConfigEntry
	public PointerPointer YoungGenConfigEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(JFRConstantEvents._YoungGenConfigEntryOffset_));
	}

}
