/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: dl_phdr_infoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the dl_phdr_infoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=dl_phdr_info.class)
public class dl_phdr_infoPointer extends StructurePointer {

	// NULL
	public static final dl_phdr_infoPointer NULL = new dl_phdr_infoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected dl_phdr_infoPointer(long address) {
		super(address);
	}

	public static dl_phdr_infoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static dl_phdr_infoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static dl_phdr_infoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new dl_phdr_infoPointer(address);
	}

	public dl_phdr_infoPointer add(long count) {
		return dl_phdr_infoPointer.cast(address + (dl_phdr_info.SIZEOF * count));
	}

	public dl_phdr_infoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public dl_phdr_infoPointer addOffset(long offset) {
		return dl_phdr_infoPointer.cast(address + offset);
	}

	public dl_phdr_infoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public dl_phdr_infoPointer sub(long count) {
		return dl_phdr_infoPointer.cast(address - (dl_phdr_info.SIZEOF * count));
	}

	public dl_phdr_infoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public dl_phdr_infoPointer subOffset(long offset) {
		return dl_phdr_infoPointer.cast(address - offset);
	}

	public dl_phdr_infoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public dl_phdr_infoPointer untag(long mask) {
		return dl_phdr_infoPointer.cast(address & ~mask);
	}

	public dl_phdr_infoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return dl_phdr_info.SIZEOF;
	}

	// Implementation methods

	// Elf64_Addr dlpi_addr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dlpi_addrOffset_", declaredType="Elf64_Addr")
	public UDATA dlpi_addr() throws CorruptDataException {
		return new U64(getLongAtOffset(dl_phdr_info._dlpi_addrOffset_));
	}

	// Elf64_Addr dlpi_addr
	public UDATAPointer dlpi_addrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(dl_phdr_info._dlpi_addrOffset_));
	}

	// U64 dlpi_adds
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dlpi_addsOffset_", declaredType="U64")
	public UDATA dlpi_adds() throws CorruptDataException {
		return new U64(getLongAtOffset(dl_phdr_info._dlpi_addsOffset_));
	}

	// U64 dlpi_adds
	public UDATAPointer dlpi_addsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(dl_phdr_info._dlpi_addsOffset_));
	}

	// const U8* dlpi_name
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dlpi_nameOffset_", declaredType="const U8*")
	public U8Pointer dlpi_name() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(dl_phdr_info._dlpi_nameOffset_));
	}

	// const U8* dlpi_name
	public PointerPointer dlpi_nameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(dl_phdr_info._dlpi_nameOffset_));
	}

	// const Elf64_Phdr* dlpi_phdr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dlpi_phdrOffset_", declaredType="const Elf64_Phdr*")
	public Elf64_PhdrPointer dlpi_phdr() throws CorruptDataException {
		return Elf64_PhdrPointer.cast(getPointerAtOffset(dl_phdr_info._dlpi_phdrOffset_));
	}

	// const Elf64_Phdr* dlpi_phdr
	public PointerPointer dlpi_phdrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(dl_phdr_info._dlpi_phdrOffset_));
	}

	// Elf64_Half dlpi_phnum
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dlpi_phnumOffset_", declaredType="Elf64_Half")
	public U16 dlpi_phnum() throws CorruptDataException {
		return new U16(getShortAtOffset(dl_phdr_info._dlpi_phnumOffset_));
	}

	// Elf64_Half dlpi_phnum
	public U16Pointer dlpi_phnumEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(dl_phdr_info._dlpi_phnumOffset_));
	}

	// U64 dlpi_subs
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dlpi_subsOffset_", declaredType="U64")
	public UDATA dlpi_subs() throws CorruptDataException {
		return new U64(getLongAtOffset(dl_phdr_info._dlpi_subsOffset_));
	}

	// U64 dlpi_subs
	public UDATAPointer dlpi_subsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(dl_phdr_info._dlpi_subsOffset_));
	}

	// void* dlpi_tls_data
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dlpi_tls_dataOffset_", declaredType="void*")
	public VoidPointer dlpi_tls_data() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(dl_phdr_info._dlpi_tls_dataOffset_));
	}

	// void* dlpi_tls_data
	public PointerPointer dlpi_tls_dataEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(dl_phdr_info._dlpi_tls_dataOffset_));
	}

	// size_t dlpi_tls_modid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dlpi_tls_modidOffset_", declaredType="size_t")
	public UDATA dlpi_tls_modid() throws CorruptDataException {
		return new U64(getLongAtOffset(dl_phdr_info._dlpi_tls_modidOffset_));
	}

	// size_t dlpi_tls_modid
	public UDATAPointer dlpi_tls_modidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(dl_phdr_info._dlpi_tls_modidOffset_));
	}

}
