/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: Elf32_EhdrPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the Elf32_EhdrPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=Elf32_Ehdr.class)
public class Elf32_EhdrPointer extends StructurePointer {

	// NULL
	public static final Elf32_EhdrPointer NULL = new Elf32_EhdrPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected Elf32_EhdrPointer(long address) {
		super(address);
	}

	public static Elf32_EhdrPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static Elf32_EhdrPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static Elf32_EhdrPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new Elf32_EhdrPointer(address);
	}

	public Elf32_EhdrPointer add(long count) {
		return Elf32_EhdrPointer.cast(address + (Elf32_Ehdr.SIZEOF * count));
	}

	public Elf32_EhdrPointer add(Scalar count) {
		return add(count.longValue());
	}

	public Elf32_EhdrPointer addOffset(long offset) {
		return Elf32_EhdrPointer.cast(address + offset);
	}

	public Elf32_EhdrPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public Elf32_EhdrPointer sub(long count) {
		return Elf32_EhdrPointer.cast(address - (Elf32_Ehdr.SIZEOF * count));
	}

	public Elf32_EhdrPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public Elf32_EhdrPointer subOffset(long offset) {
		return Elf32_EhdrPointer.cast(address - offset);
	}

	public Elf32_EhdrPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public Elf32_EhdrPointer untag(long mask) {
		return Elf32_EhdrPointer.cast(address & ~mask);
	}

	public Elf32_EhdrPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return Elf32_Ehdr.SIZEOF;
	}

	// Implementation methods

	// Elf32_Half e_ehsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_ehsizeOffset_", declaredType="Elf32_Half")
	public U16 e_ehsize() throws CorruptDataException {
		return new U16(getShortAtOffset(Elf32_Ehdr._e_ehsizeOffset_));
	}

	// Elf32_Half e_ehsize
	public U16Pointer e_ehsizeEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(Elf32_Ehdr._e_ehsizeOffset_));
	}

	// Elf32_Addr e_entry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_entryOffset_", declaredType="Elf32_Addr")
	public UDATA e_entry() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf32_Ehdr._e_entryOffset_));
	}

	// Elf32_Addr e_entry
	public UDATAPointer e_entryEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf32_Ehdr._e_entryOffset_));
	}

	// Elf32_Word e_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_flagsOffset_", declaredType="Elf32_Word")
	public UDATA e_flags() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf32_Ehdr._e_flagsOffset_));
	}

	// Elf32_Word e_flags
	public UDATAPointer e_flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf32_Ehdr._e_flagsOffset_));
	}

	// U8[] e_ident
	public U8Pointer e_identEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(Elf32_Ehdr._e_identOffset_));
	}

	// Elf32_Half e_machine
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_machineOffset_", declaredType="Elf32_Half")
	public U16 e_machine() throws CorruptDataException {
		return new U16(getShortAtOffset(Elf32_Ehdr._e_machineOffset_));
	}

	// Elf32_Half e_machine
	public U16Pointer e_machineEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(Elf32_Ehdr._e_machineOffset_));
	}

	// Elf32_Half e_phentsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_phentsizeOffset_", declaredType="Elf32_Half")
	public U16 e_phentsize() throws CorruptDataException {
		return new U16(getShortAtOffset(Elf32_Ehdr._e_phentsizeOffset_));
	}

	// Elf32_Half e_phentsize
	public U16Pointer e_phentsizeEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(Elf32_Ehdr._e_phentsizeOffset_));
	}

	// Elf32_Half e_phnum
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_phnumOffset_", declaredType="Elf32_Half")
	public U16 e_phnum() throws CorruptDataException {
		return new U16(getShortAtOffset(Elf32_Ehdr._e_phnumOffset_));
	}

	// Elf32_Half e_phnum
	public U16Pointer e_phnumEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(Elf32_Ehdr._e_phnumOffset_));
	}

	// Elf32_Off e_phoff
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_phoffOffset_", declaredType="Elf32_Off")
	public UDATA e_phoff() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf32_Ehdr._e_phoffOffset_));
	}

	// Elf32_Off e_phoff
	public UDATAPointer e_phoffEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf32_Ehdr._e_phoffOffset_));
	}

	// Elf32_Half e_shentsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_shentsizeOffset_", declaredType="Elf32_Half")
	public U16 e_shentsize() throws CorruptDataException {
		return new U16(getShortAtOffset(Elf32_Ehdr._e_shentsizeOffset_));
	}

	// Elf32_Half e_shentsize
	public U16Pointer e_shentsizeEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(Elf32_Ehdr._e_shentsizeOffset_));
	}

	// Elf32_Half e_shnum
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_shnumOffset_", declaredType="Elf32_Half")
	public U16 e_shnum() throws CorruptDataException {
		return new U16(getShortAtOffset(Elf32_Ehdr._e_shnumOffset_));
	}

	// Elf32_Half e_shnum
	public U16Pointer e_shnumEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(Elf32_Ehdr._e_shnumOffset_));
	}

	// Elf32_Off e_shoff
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_shoffOffset_", declaredType="Elf32_Off")
	public UDATA e_shoff() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf32_Ehdr._e_shoffOffset_));
	}

	// Elf32_Off e_shoff
	public UDATAPointer e_shoffEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf32_Ehdr._e_shoffOffset_));
	}

	// Elf32_Half e_shstrndx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_shstrndxOffset_", declaredType="Elf32_Half")
	public U16 e_shstrndx() throws CorruptDataException {
		return new U16(getShortAtOffset(Elf32_Ehdr._e_shstrndxOffset_));
	}

	// Elf32_Half e_shstrndx
	public U16Pointer e_shstrndxEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(Elf32_Ehdr._e_shstrndxOffset_));
	}

	// Elf32_Half e_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_typeOffset_", declaredType="Elf32_Half")
	public U16 e_type() throws CorruptDataException {
		return new U16(getShortAtOffset(Elf32_Ehdr._e_typeOffset_));
	}

	// Elf32_Half e_type
	public U16Pointer e_typeEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(Elf32_Ehdr._e_typeOffset_));
	}

	// Elf32_Word e_version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_versionOffset_", declaredType="Elf32_Word")
	public UDATA e_version() throws CorruptDataException {
		return new U32(getIntAtOffset(Elf32_Ehdr._e_versionOffset_));
	}

	// Elf32_Word e_version
	public UDATAPointer e_versionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(Elf32_Ehdr._e_versionOffset_));
	}

}
