/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: J9InternalHookRecordPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the J9InternalHookRecordPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=J9InternalHookRecord.class)
public class J9InternalHookRecordPointer extends StructurePointer {

	// NULL
	public static final J9InternalHookRecordPointer NULL = new J9InternalHookRecordPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected J9InternalHookRecordPointer(long address) {
		super(address);
	}

	public static J9InternalHookRecordPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static J9InternalHookRecordPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static J9InternalHookRecordPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new J9InternalHookRecordPointer(address);
	}

	public J9InternalHookRecordPointer add(long count) {
		return J9InternalHookRecordPointer.cast(address + (J9InternalHookRecord.SIZEOF * count));
	}

	public J9InternalHookRecordPointer add(Scalar count) {
		return add(count.longValue());
	}

	public J9InternalHookRecordPointer addOffset(long offset) {
		return J9InternalHookRecordPointer.cast(address + offset);
	}

	public J9InternalHookRecordPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public J9InternalHookRecordPointer sub(long count) {
		return J9InternalHookRecordPointer.cast(address - (J9InternalHookRecord.SIZEOF * count));
	}

	public J9InternalHookRecordPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public J9InternalHookRecordPointer subOffset(long offset) {
		return J9InternalHookRecordPointer.cast(address - offset);
	}

	public J9InternalHookRecordPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public J9InternalHookRecordPointer untag(long mask) {
		return J9InternalHookRecordPointer.cast(address & ~mask);
	}

	public J9InternalHookRecordPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return J9InternalHookRecord.SIZEOF;
	}

	// Implementation methods

	// hookFunc hookFunc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_hookFuncOffset_", declaredType="hookFunc")
	public VoidPointer hookFunc() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(J9InternalHookRecord._hookFuncOffset_));
	}

	// hookFunc hookFunc
	public PointerPointer hookFuncEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9InternalHookRecord._hookFuncOffset_));
	}

	// BOOLEAN includeSubClass
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_includeSubClassOffset_", declaredType="BOOLEAN")
	public UDATA includeSubClass() throws CorruptDataException {
		return new U32(getIntAtOffset(J9InternalHookRecord._includeSubClassOffset_));
	}

	// BOOLEAN includeSubClass
	public UDATAPointer includeSubClassEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9InternalHookRecord._includeSubClassOffset_));
	}

	// J9Pool* instanceObjects
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_instanceObjectsOffset_", declaredType="J9Pool*")
	public J9PoolPointer instanceObjects() throws CorruptDataException {
		return J9PoolPointer.cast(getPointerAtOffset(J9InternalHookRecord._instanceObjectsOffset_));
	}

	// J9Pool* instanceObjects
	public PointerPointer instanceObjectsEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9InternalHookRecord._instanceObjectsOffset_));
	}

	// J9Class* instanceType
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_instanceTypeOffset_", declaredType="J9Class*")
	public J9ClassPointer instanceType() throws CorruptDataException {
		return J9ClassPointer.cast(getPointerAtOffset(J9InternalHookRecord._instanceTypeOffset_));
	}

	// J9Class* instanceType
	public PointerPointer instanceTypeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(J9InternalHookRecord._instanceTypeOffset_));
	}

	// BOOLEAN isRestore
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_isRestoreOffset_", declaredType="BOOLEAN")
	public UDATA isRestore() throws CorruptDataException {
		return new U32(getIntAtOffset(J9InternalHookRecord._isRestoreOffset_));
	}

	// BOOLEAN isRestore
	public UDATAPointer isRestoreEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(J9InternalHookRecord._isRestoreOffset_));
	}

}
