/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: MM_RegionPoolSegregated
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class MM_RegionPoolSegregated {

	// VM Constants

	public static final long SIZEOF;
	public static final long NUM_DEFRAG_BUCKETS;

	// Offsets

	public static final int __arrayletAvailableRegionsOffset_;
	public static final int __arrayletFullRegionsOffset_;
	public static final int __arrayletSweepRegionsOffset_;
	public static final int __coalesceFreeListOffset_;
	public static final int __currentCountOfSweepRegionsOffset_;
	public static final int __currentTotalCountOfSweepRegionsOffset_;
	public static final int __darkMatterCellCountOffset_;
	public static final int __heapRegionManagerOffset_;
	public static final int __initialCountOfSweepRegionsOffset_;
	public static final int __initialTotalCountOfSweepRegionsOffset_;
	public static final int __isSweepingSmallOffset_;
	public static final int __largeFullRegionsOffset_;
	public static final int __largeSweepRegionsOffset_;
	public static final int __multiFreeListOffset_;
	public static final int __regionsInUseOffset_;
	public static final int __singleFreeListOffset_;
	public static final int __skipAvailableRegionForAllocationOffset_;
	public static final int __smallAvailableRegionsOffset_;
	public static final int __smallFullRegionsOffset_;
	public static final int __smallOccupancyOffset_;
	public static final int __smallSweepRegionsOffset_;
	public static final int __splitAvailableListSplitCountOffset_;
	public static final int __sweepSchemeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		NUM_DEFRAG_BUCKETS = 0;
		__arrayletAvailableRegionsOffset_ = 0;
		__arrayletFullRegionsOffset_ = 0;
		__arrayletSweepRegionsOffset_ = 0;
		__coalesceFreeListOffset_ = 0;
		__currentCountOfSweepRegionsOffset_ = 0;
		__currentTotalCountOfSweepRegionsOffset_ = 0;
		__darkMatterCellCountOffset_ = 0;
		__heapRegionManagerOffset_ = 0;
		__initialCountOfSweepRegionsOffset_ = 0;
		__initialTotalCountOfSweepRegionsOffset_ = 0;
		__isSweepingSmallOffset_ = 0;
		__largeFullRegionsOffset_ = 0;
		__largeSweepRegionsOffset_ = 0;
		__multiFreeListOffset_ = 0;
		__regionsInUseOffset_ = 0;
		__singleFreeListOffset_ = 0;
		__skipAvailableRegionForAllocationOffset_ = 0;
		__smallAvailableRegionsOffset_ = 0;
		__smallFullRegionsOffset_ = 0;
		__smallOccupancyOffset_ = 0;
		__smallSweepRegionsOffset_ = 0;
		__splitAvailableListSplitCountOffset_ = 0;
		__sweepSchemeOffset_ = 0;
	}

}
