/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: CompactTableEntryPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the CompactTableEntryPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=CompactTableEntry.class)
public class CompactTableEntryPointer extends StructurePointer {

	// NULL
	public static final CompactTableEntryPointer NULL = new CompactTableEntryPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected CompactTableEntryPointer(long address) {
		super(address);
	}

	public static CompactTableEntryPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static CompactTableEntryPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static CompactTableEntryPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new CompactTableEntryPointer(address);
	}

	public CompactTableEntryPointer add(long count) {
		return CompactTableEntryPointer.cast(address + (CompactTableEntry.SIZEOF * count));
	}

	public CompactTableEntryPointer add(Scalar count) {
		return add(count.longValue());
	}

	public CompactTableEntryPointer addOffset(long offset) {
		return CompactTableEntryPointer.cast(address + offset);
	}

	public CompactTableEntryPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public CompactTableEntryPointer sub(long count) {
		return CompactTableEntryPointer.cast(address - (CompactTableEntry.SIZEOF * count));
	}

	public CompactTableEntryPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public CompactTableEntryPointer subOffset(long offset) {
		return CompactTableEntryPointer.cast(address - offset);
	}

	public CompactTableEntryPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public CompactTableEntryPointer untag(long mask) {
		return CompactTableEntryPointer.cast(address & ~mask);
	}

	public CompactTableEntryPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return CompactTableEntry.SIZEOF;
	}

	// Implementation methods

	// U64 _addr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__addrOffset_", declaredType="U64")
	public UDATA _addr() throws CorruptDataException {
		return new U64(getLongAtOffset(CompactTableEntry.__addrOffset_));
	}

	// U64 _addr
	public UDATAPointer _addrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(CompactTableEntry.__addrOffset_));
	}

	// U64 _bits
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__bitsOffset_", declaredType="U64")
	public UDATA _bits() throws CorruptDataException {
		return new U64(getLongAtOffset(CompactTableEntry.__bitsOffset_));
	}

	// U64 _bits
	public UDATAPointer _bitsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(CompactTableEntry.__bitsOffset_));
	}

}
