/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: eprocPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the eprocPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=eproc.class)
public class eprocPointer extends StructurePointer {

	// NULL
	public static final eprocPointer NULL = new eprocPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected eprocPointer(long address) {
		super(address);
	}

	public static eprocPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static eprocPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static eprocPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new eprocPointer(address);
	}

	public eprocPointer add(long count) {
		return eprocPointer.cast(address + (eproc.SIZEOF * count));
	}

	public eprocPointer add(Scalar count) {
		return add(count.longValue());
	}

	public eprocPointer addOffset(long offset) {
		return eprocPointer.cast(address + offset);
	}

	public eprocPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public eprocPointer sub(long count) {
		return eprocPointer.cast(address - (eproc.SIZEOF * count));
	}

	public eprocPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public eprocPointer subOffset(long offset) {
		return eprocPointer.cast(address - offset);
	}

	public eprocPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public eprocPointer untag(long mask) {
		return eprocPointer.cast(address & ~mask);
	}

	public eprocPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return eproc.SIZEOF;
	}

	// Implementation methods

	// I32 e_flag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_flagOffset_", declaredType="I32")
	public IDATA e_flag() throws CorruptDataException {
		return new I32(getIntAtOffset(eproc._e_flagOffset_));
	}

	// I32 e_flag
	public IDATAPointer e_flagEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(eproc._e_flagOffset_));
	}

	// I16 e_jobc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_jobcOffset_", declaredType="I16")
	public I16 e_jobc() throws CorruptDataException {
		return new I16(getShortAtOffset(eproc._e_jobcOffset_));
	}

	// I16 e_jobc
	public I16Pointer e_jobcEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(eproc._e_jobcOffset_));
	}

	// U8[] e_login
	public U8Pointer e_loginEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(eproc._e_loginOffset_));
	}

	// proc* e_paddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_paddrOffset_", declaredType="proc*")
	public procPointer e_paddr() throws CorruptDataException {
		return procPointer.cast(getPointerAtOffset(eproc._e_paddrOffset_));
	}

	// proc* e_paddr
	public PointerPointer e_paddrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(eproc._e_paddrOffset_));
	}

	// _pcred e_pcred
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_pcredOffset_", declaredType="_pcred")
	public _pcredPointer e_pcred() throws CorruptDataException {
		return _pcredPointer.cast(nonNullFieldEA(eproc._e_pcredOffset_));
	}

	// _pcred e_pcred
	public PointerPointer e_pcredEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(eproc._e_pcredOffset_));
	}

	// pid_t e_pgid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_pgidOffset_", declaredType="pid_t")
	public IDATA e_pgid() throws CorruptDataException {
		return new I32(getIntAtOffset(eproc._e_pgidOffset_));
	}

	// pid_t e_pgid
	public IDATAPointer e_pgidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(eproc._e_pgidOffset_));
	}

	// pid_t e_ppid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_ppidOffset_", declaredType="pid_t")
	public IDATA e_ppid() throws CorruptDataException {
		return new I32(getIntAtOffset(eproc._e_ppidOffset_));
	}

	// pid_t e_ppid
	public IDATAPointer e_ppidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(eproc._e_ppidOffset_));
	}

	// session* e_sess
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_sessOffset_", declaredType="session*")
	public sessionPointer e_sess() throws CorruptDataException {
		return sessionPointer.cast(getPointerAtOffset(eproc._e_sessOffset_));
	}

	// session* e_sess
	public PointerPointer e_sessEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(eproc._e_sessOffset_));
	}

	// I32[] e_spare
	public IDATAPointer e_spareEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(eproc._e_spareOffset_));
	}

	// dev_t e_tdev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_tdevOffset_", declaredType="dev_t")
	public IDATA e_tdev() throws CorruptDataException {
		return new I32(getIntAtOffset(eproc._e_tdevOffset_));
	}

	// dev_t e_tdev
	public IDATAPointer e_tdevEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(eproc._e_tdevOffset_));
	}

	// pid_t e_tpgid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_tpgidOffset_", declaredType="pid_t")
	public IDATA e_tpgid() throws CorruptDataException {
		return new I32(getIntAtOffset(eproc._e_tpgidOffset_));
	}

	// pid_t e_tpgid
	public IDATAPointer e_tpgidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(eproc._e_tpgidOffset_));
	}

	// session* e_tsess
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_tsessOffset_", declaredType="session*")
	public sessionPointer e_tsess() throws CorruptDataException {
		return sessionPointer.cast(getPointerAtOffset(eproc._e_tsessOffset_));
	}

	// session* e_tsess
	public PointerPointer e_tsessEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(eproc._e_tsessOffset_));
	}

	// _ucred e_ucred
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_ucredOffset_", declaredType="_ucred")
	public _ucredPointer e_ucred() throws CorruptDataException {
		return _ucredPointer.cast(nonNullFieldEA(eproc._e_ucredOffset_));
	}

	// _ucred e_ucred
	public PointerPointer e_ucredEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(eproc._e_ucredOffset_));
	}

	// vmspace e_vm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_vmOffset_", declaredType="vmspace")
	public vmspacePointer e_vm() throws CorruptDataException {
		return vmspacePointer.cast(nonNullFieldEA(eproc._e_vmOffset_));
	}

	// vmspace e_vm
	public PointerPointer e_vmEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(eproc._e_vmOffset_));
	}

	// U8[] e_wmesg
	public U8Pointer e_wmesgEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(eproc._e_wmesgOffset_));
	}

	// I16 e_xccount
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_xccountOffset_", declaredType="I16")
	public I16 e_xccount() throws CorruptDataException {
		return new I16(getShortAtOffset(eproc._e_xccountOffset_));
	}

	// I16 e_xccount
	public I16Pointer e_xccountEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(eproc._e_xccountOffset_));
	}

	// I16 e_xrssize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_xrssizeOffset_", declaredType="I16")
	public I16 e_xrssize() throws CorruptDataException {
		return new I16(getShortAtOffset(eproc._e_xrssizeOffset_));
	}

	// I16 e_xrssize
	public I16Pointer e_xrssizeEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(eproc._e_xrssizeOffset_));
	}

	// segsz_t e_xsize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_xsizeOffset_", declaredType="segsz_t")
	public IDATA e_xsize() throws CorruptDataException {
		return new I32(getIntAtOffset(eproc._e_xsizeOffset_));
	}

	// segsz_t e_xsize
	public IDATAPointer e_xsizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(eproc._e_xsizeOffset_));
	}

	// I16 e_xswrss
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_e_xswrssOffset_", declaredType="I16")
	public I16 e_xswrss() throws CorruptDataException {
		return new I16(getShortAtOffset(eproc._e_xswrssOffset_));
	}

	// I16 e_xswrss
	public I16Pointer e_xswrssEA() throws CorruptDataException {
		return I16Pointer.cast(nonNullFieldEA(eproc._e_xswrssOffset_));
	}

}
