/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: vm_region_submap_info_64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the vm_region_submap_info_64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=vm_region_submap_info_64.class)
public class vm_region_submap_info_64Pointer extends StructurePointer {

	// NULL
	public static final vm_region_submap_info_64Pointer NULL = new vm_region_submap_info_64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected vm_region_submap_info_64Pointer(long address) {
		super(address);
	}

	public static vm_region_submap_info_64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static vm_region_submap_info_64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static vm_region_submap_info_64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new vm_region_submap_info_64Pointer(address);
	}

	public vm_region_submap_info_64Pointer add(long count) {
		return vm_region_submap_info_64Pointer.cast(address + (vm_region_submap_info_64.SIZEOF * count));
	}

	public vm_region_submap_info_64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public vm_region_submap_info_64Pointer addOffset(long offset) {
		return vm_region_submap_info_64Pointer.cast(address + offset);
	}

	public vm_region_submap_info_64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public vm_region_submap_info_64Pointer sub(long count) {
		return vm_region_submap_info_64Pointer.cast(address - (vm_region_submap_info_64.SIZEOF * count));
	}

	public vm_region_submap_info_64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public vm_region_submap_info_64Pointer subOffset(long offset) {
		return vm_region_submap_info_64Pointer.cast(address - offset);
	}

	public vm_region_submap_info_64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public vm_region_submap_info_64Pointer untag(long mask) {
		return vm_region_submap_info_64Pointer.cast(address & ~mask);
	}

	public vm_region_submap_info_64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return vm_region_submap_info_64.SIZEOF;
	}

	// Implementation methods

	// vm_behavior_t behavior
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_behaviorOffset_", declaredType="vm_behavior_t")
	public IDATA behavior() throws CorruptDataException {
		return new I32(getIntAtOffset(vm_region_submap_info_64._behaviorOffset_));
	}

	// vm_behavior_t behavior
	public IDATAPointer behaviorEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._behaviorOffset_));
	}

	// U8 external_pager
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_external_pagerOffset_", declaredType="U8")
	public U8 external_pager() throws CorruptDataException {
		return new U8(getByteAtOffset(vm_region_submap_info_64._external_pagerOffset_));
	}

	// U8 external_pager
	public U8Pointer external_pagerEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(vm_region_submap_info_64._external_pagerOffset_));
	}

	// vm_inherit_t inheritance
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_inheritanceOffset_", declaredType="vm_inherit_t")
	public UDATA inheritance() throws CorruptDataException {
		return new U32(getIntAtOffset(vm_region_submap_info_64._inheritanceOffset_));
	}

	// vm_inherit_t inheritance
	public UDATAPointer inheritanceEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._inheritanceOffset_));
	}

	// boolean_t is_submap
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_is_submapOffset_", declaredType="boolean_t")
	public UDATA is_submap() throws CorruptDataException {
		return new U32(getIntAtOffset(vm_region_submap_info_64._is_submapOffset_));
	}

	// boolean_t is_submap
	public UDATAPointer is_submapEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._is_submapOffset_));
	}

	// vm_prot_t max_protection
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_max_protectionOffset_", declaredType="vm_prot_t")
	public IDATA max_protection() throws CorruptDataException {
		return new I32(getIntAtOffset(vm_region_submap_info_64._max_protectionOffset_));
	}

	// vm_prot_t max_protection
	public IDATAPointer max_protectionEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._max_protectionOffset_));
	}

	// vm32_object_id_t object_id
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_object_idOffset_", declaredType="vm32_object_id_t")
	public UDATA object_id() throws CorruptDataException {
		return new U32(getIntAtOffset(vm_region_submap_info_64._object_idOffset_));
	}

	// vm32_object_id_t object_id
	public UDATAPointer object_idEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._object_idOffset_));
	}

	// vm_object_id_t object_id_full
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_object_id_fullOffset_", declaredType="vm_object_id_t")
	public UDATA object_id_full() throws CorruptDataException {
		return new U64(getLongAtOffset(vm_region_submap_info_64._object_id_fullOffset_));
	}

	// vm_object_id_t object_id_full
	public UDATAPointer object_id_fullEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._object_id_fullOffset_));
	}

	// memory_object_offset_t offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_offsetOffset_", declaredType="memory_object_offset_t")
	public UDATA offset() throws CorruptDataException {
		return new U64(getLongAtOffset(vm_region_submap_info_64._offsetOffset_));
	}

	// memory_object_offset_t offset
	public UDATAPointer offsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._offsetOffset_));
	}

	// U32 pages_dirtied
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pages_dirtiedOffset_", declaredType="U32")
	public UDATA pages_dirtied() throws CorruptDataException {
		return new U32(getIntAtOffset(vm_region_submap_info_64._pages_dirtiedOffset_));
	}

	// U32 pages_dirtied
	public UDATAPointer pages_dirtiedEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._pages_dirtiedOffset_));
	}

	// U32 pages_resident
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pages_residentOffset_", declaredType="U32")
	public UDATA pages_resident() throws CorruptDataException {
		return new U32(getIntAtOffset(vm_region_submap_info_64._pages_residentOffset_));
	}

	// U32 pages_resident
	public UDATAPointer pages_residentEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._pages_residentOffset_));
	}

	// U32 pages_reusable
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pages_reusableOffset_", declaredType="U32")
	public UDATA pages_reusable() throws CorruptDataException {
		return new U32(getIntAtOffset(vm_region_submap_info_64._pages_reusableOffset_));
	}

	// U32 pages_reusable
	public UDATAPointer pages_reusableEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._pages_reusableOffset_));
	}

	// U32 pages_shared_now_private
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pages_shared_now_privateOffset_", declaredType="U32")
	public UDATA pages_shared_now_private() throws CorruptDataException {
		return new U32(getIntAtOffset(vm_region_submap_info_64._pages_shared_now_privateOffset_));
	}

	// U32 pages_shared_now_private
	public UDATAPointer pages_shared_now_privateEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._pages_shared_now_privateOffset_));
	}

	// U32 pages_swapped_out
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pages_swapped_outOffset_", declaredType="U32")
	public UDATA pages_swapped_out() throws CorruptDataException {
		return new U32(getIntAtOffset(vm_region_submap_info_64._pages_swapped_outOffset_));
	}

	// U32 pages_swapped_out
	public UDATAPointer pages_swapped_outEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._pages_swapped_outOffset_));
	}

	// vm_prot_t protection
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_protectionOffset_", declaredType="vm_prot_t")
	public IDATA protection() throws CorruptDataException {
		return new I32(getIntAtOffset(vm_region_submap_info_64._protectionOffset_));
	}

	// vm_prot_t protection
	public IDATAPointer protectionEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._protectionOffset_));
	}

	// U32 ref_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ref_countOffset_", declaredType="U32")
	public UDATA ref_count() throws CorruptDataException {
		return new U32(getIntAtOffset(vm_region_submap_info_64._ref_countOffset_));
	}

	// U32 ref_count
	public UDATAPointer ref_countEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._ref_countOffset_));
	}

	// U16 shadow_depth
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shadow_depthOffset_", declaredType="U16")
	public U16 shadow_depth() throws CorruptDataException {
		return new U16(getShortAtOffset(vm_region_submap_info_64._shadow_depthOffset_));
	}

	// U16 shadow_depth
	public U16Pointer shadow_depthEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(vm_region_submap_info_64._shadow_depthOffset_));
	}

	// U8 share_mode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_share_modeOffset_", declaredType="U8")
	public U8 share_mode() throws CorruptDataException {
		return new U8(getByteAtOffset(vm_region_submap_info_64._share_modeOffset_));
	}

	// U8 share_mode
	public U8Pointer share_modeEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(vm_region_submap_info_64._share_modeOffset_));
	}

	// U32 user_tag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_user_tagOffset_", declaredType="U32")
	public UDATA user_tag() throws CorruptDataException {
		return new U32(getIntAtOffset(vm_region_submap_info_64._user_tagOffset_));
	}

	// U32 user_tag
	public UDATAPointer user_tagEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_region_submap_info_64._user_tagOffset_));
	}

	// U16 user_wired_count
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_user_wired_countOffset_", declaredType="U16")
	public U16 user_wired_count() throws CorruptDataException {
		return new U16(getShortAtOffset(vm_region_submap_info_64._user_wired_countOffset_));
	}

	// U16 user_wired_count
	public U16Pointer user_wired_countEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(vm_region_submap_info_64._user_wired_countOffset_));
	}

}
