/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: MM_CompactMemoryPoolStatePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the MM_CompactMemoryPoolStatePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=MM_CompactMemoryPoolState.class)
public class MM_CompactMemoryPoolStatePointer extends MM_BaseVirtualPointer {

	// NULL
	public static final MM_CompactMemoryPoolStatePointer NULL = new MM_CompactMemoryPoolStatePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected MM_CompactMemoryPoolStatePointer(long address) {
		super(address);
	}

	public static MM_CompactMemoryPoolStatePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static MM_CompactMemoryPoolStatePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static MM_CompactMemoryPoolStatePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new MM_CompactMemoryPoolStatePointer(address);
	}

	public MM_CompactMemoryPoolStatePointer add(long count) {
		return MM_CompactMemoryPoolStatePointer.cast(address + (MM_CompactMemoryPoolState.SIZEOF * count));
	}

	public MM_CompactMemoryPoolStatePointer add(Scalar count) {
		return add(count.longValue());
	}

	public MM_CompactMemoryPoolStatePointer addOffset(long offset) {
		return MM_CompactMemoryPoolStatePointer.cast(address + offset);
	}

	public MM_CompactMemoryPoolStatePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public MM_CompactMemoryPoolStatePointer sub(long count) {
		return MM_CompactMemoryPoolStatePointer.cast(address - (MM_CompactMemoryPoolState.SIZEOF * count));
	}

	public MM_CompactMemoryPoolStatePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public MM_CompactMemoryPoolStatePointer subOffset(long offset) {
		return MM_CompactMemoryPoolStatePointer.cast(address - offset);
	}

	public MM_CompactMemoryPoolStatePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public MM_CompactMemoryPoolStatePointer untag(long mask) {
		return MM_CompactMemoryPoolStatePointer.cast(address & ~mask);
	}

	public MM_CompactMemoryPoolStatePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return MM_CompactMemoryPoolState.SIZEOF;
	}

	// Implementation methods

	// U64 _freeBytes
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__freeBytesOffset_", declaredType="U64")
	public UDATA _freeBytes() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_CompactMemoryPoolState.__freeBytesOffset_));
	}

	// U64 _freeBytes
	public UDATAPointer _freeBytesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_CompactMemoryPoolState.__freeBytesOffset_));
	}

	// U64 _freeHoles
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__freeHolesOffset_", declaredType="U64")
	public UDATA _freeHoles() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_CompactMemoryPoolState.__freeHolesOffset_));
	}

	// U64 _freeHoles
	public UDATAPointer _freeHolesEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_CompactMemoryPoolState.__freeHolesOffset_));
	}

	// MM_HeapLinkedFreeHeader* _freeListHead
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__freeListHeadOffset_", declaredType="MM_HeapLinkedFreeHeader*")
	public MM_HeapLinkedFreeHeaderPointer _freeListHead() throws CorruptDataException {
		return MM_HeapLinkedFreeHeaderPointer.cast(getPointerAtOffset(MM_CompactMemoryPoolState.__freeListHeadOffset_));
	}

	// MM_HeapLinkedFreeHeader* _freeListHead
	public PointerPointer _freeListHeadEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_CompactMemoryPoolState.__freeListHeadOffset_));
	}

	// U64 _largestFreeEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__largestFreeEntryOffset_", declaredType="U64")
	public UDATA _largestFreeEntry() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_CompactMemoryPoolState.__largestFreeEntryOffset_));
	}

	// U64 _largestFreeEntry
	public UDATAPointer _largestFreeEntryEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_CompactMemoryPoolState.__largestFreeEntryOffset_));
	}

	// MM_MemoryPool* _memoryPool
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__memoryPoolOffset_", declaredType="MM_MemoryPool*")
	public MM_MemoryPoolPointer _memoryPool() throws CorruptDataException {
		return MM_MemoryPoolPointer.cast(getPointerAtOffset(MM_CompactMemoryPoolState.__memoryPoolOffset_));
	}

	// MM_MemoryPool* _memoryPool
	public PointerPointer _memoryPoolEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_CompactMemoryPoolState.__memoryPoolOffset_));
	}

	// MM_HeapLinkedFreeHeader* _previousFreeEntry
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__previousFreeEntryOffset_", declaredType="MM_HeapLinkedFreeHeader*")
	public MM_HeapLinkedFreeHeaderPointer _previousFreeEntry() throws CorruptDataException {
		return MM_HeapLinkedFreeHeaderPointer.cast(getPointerAtOffset(MM_CompactMemoryPoolState.__previousFreeEntryOffset_));
	}

	// MM_HeapLinkedFreeHeader* _previousFreeEntry
	public PointerPointer _previousFreeEntryEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(MM_CompactMemoryPoolState.__previousFreeEntryOffset_));
	}

	// U64 _previousFreeEntrySize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__previousFreeEntrySizeOffset_", declaredType="U64")
	public UDATA _previousFreeEntrySize() throws CorruptDataException {
		return new U64(getLongAtOffset(MM_CompactMemoryPoolState.__previousFreeEntrySizeOffset_));
	}

	// U64 _previousFreeEntrySize
	public UDATAPointer _previousFreeEntrySizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(MM_CompactMemoryPoolState.__previousFreeEntrySizeOffset_));
	}

}
