/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: GC_ClassFCCSlotIteratorPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the GC_ClassFCCSlotIteratorPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=GC_ClassFCCSlotIterator.class)
public class GC_ClassFCCSlotIteratorPointer extends StructurePointer {

	// NULL
	public static final GC_ClassFCCSlotIteratorPointer NULL = new GC_ClassFCCSlotIteratorPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected GC_ClassFCCSlotIteratorPointer(long address) {
		super(address);
	}

	public static GC_ClassFCCSlotIteratorPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static GC_ClassFCCSlotIteratorPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static GC_ClassFCCSlotIteratorPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new GC_ClassFCCSlotIteratorPointer(address);
	}

	public GC_ClassFCCSlotIteratorPointer add(long count) {
		return GC_ClassFCCSlotIteratorPointer.cast(address + (GC_ClassFCCSlotIterator.SIZEOF * count));
	}

	public GC_ClassFCCSlotIteratorPointer add(Scalar count) {
		return add(count.longValue());
	}

	public GC_ClassFCCSlotIteratorPointer addOffset(long offset) {
		return GC_ClassFCCSlotIteratorPointer.cast(address + offset);
	}

	public GC_ClassFCCSlotIteratorPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public GC_ClassFCCSlotIteratorPointer sub(long count) {
		return GC_ClassFCCSlotIteratorPointer.cast(address - (GC_ClassFCCSlotIterator.SIZEOF * count));
	}

	public GC_ClassFCCSlotIteratorPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public GC_ClassFCCSlotIteratorPointer subOffset(long offset) {
		return GC_ClassFCCSlotIteratorPointer.cast(address - offset);
	}

	public GC_ClassFCCSlotIteratorPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public GC_ClassFCCSlotIteratorPointer untag(long mask) {
		return GC_ClassFCCSlotIteratorPointer.cast(address & ~mask);
	}

	public GC_ClassFCCSlotIteratorPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return GC_ClassFCCSlotIterator.SIZEOF;
	}

	// Implementation methods

	// J9Class* _clazz
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__clazzOffset_", declaredType="J9Class*")
	public J9ClassPointer _clazz() throws CorruptDataException {
		return J9ClassPointer.cast(getPointerAtOffset(GC_ClassFCCSlotIterator.__clazzOffset_));
	}

	// J9Class* _clazz
	public PointerPointer _clazzEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(GC_ClassFCCSlotIterator.__clazzOffset_));
	}

	// UDATA _index
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__indexOffset_", declaredType="UDATA")
	public UDATA _index() throws CorruptDataException {
		return getUDATAAtOffset(GC_ClassFCCSlotIterator.__indexOffset_);
	}

	// UDATA _index
	public UDATAPointer _indexEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GC_ClassFCCSlotIterator.__indexOffset_));
	}

	// UDATA _numberOfFlattenedFields
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="__numberOfFlattenedFieldsOffset_", declaredType="UDATA")
	public UDATA _numberOfFlattenedFields() throws CorruptDataException {
		return getUDATAAtOffset(GC_ClassFCCSlotIterator.__numberOfFlattenedFieldsOffset_);
	}

	// UDATA _numberOfFlattenedFields
	public UDATAPointer _numberOfFlattenedFieldsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(GC_ClassFCCSlotIterator.__numberOfFlattenedFieldsOffset_));
	}

}
