/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: malloc_paramsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the malloc_paramsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=malloc_params.class)
public class malloc_paramsPointer extends StructurePointer {

	// NULL
	public static final malloc_paramsPointer NULL = new malloc_paramsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected malloc_paramsPointer(long address) {
		super(address);
	}

	public static malloc_paramsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static malloc_paramsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static malloc_paramsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new malloc_paramsPointer(address);
	}

	public malloc_paramsPointer add(long count) {
		return malloc_paramsPointer.cast(address + (malloc_params.SIZEOF * count));
	}

	public malloc_paramsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public malloc_paramsPointer addOffset(long offset) {
		return malloc_paramsPointer.cast(address + offset);
	}

	public malloc_paramsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public malloc_paramsPointer sub(long count) {
		return malloc_paramsPointer.cast(address - (malloc_params.SIZEOF * count));
	}

	public malloc_paramsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public malloc_paramsPointer subOffset(long offset) {
		return malloc_paramsPointer.cast(address - offset);
	}

	public malloc_paramsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public malloc_paramsPointer untag(long mask) {
		return malloc_paramsPointer.cast(address & ~mask);
	}

	public malloc_paramsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return malloc_params.SIZEOF;
	}

	// Implementation methods

	// flag_t default_mflags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_default_mflagsOffset_", declaredType="flag_t")
	public UDATA default_mflags() throws CorruptDataException {
		return new U32(getIntAtOffset(malloc_params._default_mflagsOffset_));
	}

	// flag_t default_mflags
	public UDATAPointer default_mflagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_params._default_mflagsOffset_));
	}

	// size_t granularity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_granularityOffset_", declaredType="size_t")
	public UDATA granularity() throws CorruptDataException {
		return new U64(getLongAtOffset(malloc_params._granularityOffset_));
	}

	// size_t granularity
	public UDATAPointer granularityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_params._granularityOffset_));
	}

	// size_t magic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_magicOffset_", declaredType="size_t")
	public UDATA magic() throws CorruptDataException {
		return new U64(getLongAtOffset(malloc_params._magicOffset_));
	}

	// size_t magic
	public UDATAPointer magicEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_params._magicOffset_));
	}

	// size_t mmap_threshold
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_mmap_thresholdOffset_", declaredType="size_t")
	public UDATA mmap_threshold() throws CorruptDataException {
		return new U64(getLongAtOffset(malloc_params._mmap_thresholdOffset_));
	}

	// size_t mmap_threshold
	public UDATAPointer mmap_thresholdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_params._mmap_thresholdOffset_));
	}

	// size_t page_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_page_sizeOffset_", declaredType="size_t")
	public UDATA page_size() throws CorruptDataException {
		return new U64(getLongAtOffset(malloc_params._page_sizeOffset_));
	}

	// size_t page_size
	public UDATAPointer page_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_params._page_sizeOffset_));
	}

	// size_t trim_threshold
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_trim_thresholdOffset_", declaredType="size_t")
	public UDATA trim_threshold() throws CorruptDataException {
		return new U64(getLongAtOffset(malloc_params._trim_thresholdOffset_));
	}

	// size_t trim_threshold
	public UDATAPointer trim_thresholdEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(malloc_params._trim_thresholdOffset_));
	}

}
