/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: sigcontextPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the sigcontextPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=sigcontext.class)
public class sigcontextPointer extends StructurePointer {

	// NULL
	public static final sigcontextPointer NULL = new sigcontextPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected sigcontextPointer(long address) {
		super(address);
	}

	public static sigcontextPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static sigcontextPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static sigcontextPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new sigcontextPointer(address);
	}

	public sigcontextPointer add(long count) {
		return sigcontextPointer.cast(address + (sigcontext.SIZEOF * count));
	}

	public sigcontextPointer add(Scalar count) {
		return add(count.longValue());
	}

	public sigcontextPointer addOffset(long offset) {
		return sigcontextPointer.cast(address + offset);
	}

	public sigcontextPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public sigcontextPointer sub(long count) {
		return sigcontextPointer.cast(address - (sigcontext.SIZEOF * count));
	}

	public sigcontextPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public sigcontextPointer subOffset(long offset) {
		return sigcontextPointer.cast(address - offset);
	}

	public sigcontextPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public sigcontextPointer untag(long mask) {
		return sigcontextPointer.cast(address & ~mask);
	}

	public sigcontextPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return sigcontext.SIZEOF;
	}

	// Implementation methods

	// __u8[] __reserved
	public U8Pointer __reservedEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(sigcontext.___reservedOffset_));
	}

	// __u64 fault_address
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fault_addressOffset_", declaredType="__u64")
	public UDATA fault_address() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._fault_addressOffset_));
	}

	// __u64 fault_address
	public UDATAPointer fault_addressEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._fault_addressOffset_));
	}

	// __u64 pc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pcOffset_", declaredType="__u64")
	public UDATA pc() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._pcOffset_));
	}

	// __u64 pc
	public UDATAPointer pcEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._pcOffset_));
	}

	// __u64 pstate
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pstateOffset_", declaredType="__u64")
	public UDATA pstate() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._pstateOffset_));
	}

	// __u64 pstate
	public UDATAPointer pstateEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._pstateOffset_));
	}

	// __u64[] regs
	public UDATAPointer regsEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(sigcontext._regsOffset_));
	}

	// __u64 sp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_spOffset_", declaredType="__u64")
	public UDATA sp() throws CorruptDataException {
		return new U64(getLongAtOffset(sigcontext._spOffset_));
	}

	// __u64 sp
	public UDATAPointer spEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(sigcontext._spOffset_));
	}

}
