/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: extern_proc
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class extern_proc {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _exit_threadOffset_;
	public static final int _p_acflagOffset_;
	public static final int _p_addrOffset_;
	public static final int _p_commOffset_;
	public static final int _p_cpticksOffset_;
	public static final int _p_debuggerOffset_;
	public static final int _p_dupfdOffset_;
	public static final int _p_estcpuOffset_;
	public static final int _p_flagOffset_;
	public static final int _p_holdcntOffset_;
	public static final int _p_iticksOffset_;
	public static final int _p_niceOffset_;
	public static final int _p_oppidOffset_;
	public static final int _p_pctcpuOffset_;
	public static final int _p_pgrpOffset_;
	public static final int _p_pidOffset_;
	public static final int _p_priorityOffset_;
	public static final int _p_realtimerOffset_;
	public static final int _p_rtimeOffset_;
	public static final int _p_ruOffset_;
	public static final int _p_sigactsOffset_;
	public static final int _p_sigcatchOffset_;
	public static final int _p_sigignoreOffset_;
	public static final int _p_siglistOffset_;
	public static final int _p_sigmaskOffset_;
	public static final int _p_slptimeOffset_;
	public static final int _p_statOffset_;
	public static final int _p_sticksOffset_;
	public static final int _p_swtimeOffset_;
	public static final int _p_textvpOffset_;
	public static final int _p_traceflagOffset_;
	public static final int _p_tracepOffset_;
	public static final int _p_un$__p_starttimeOffset_;
	public static final int _p_un$p_st1$__p_backOffset_;
	public static final int _p_un$p_st1$__p_forwOffset_;
	public static final int _p_usrpriOffset_;
	public static final int _p_uticksOffset_;
	public static final int _p_vmspaceOffset_;
	public static final int _p_wchanOffset_;
	public static final int _p_wmesgOffset_;
	public static final int _p_xstatOffset_;
	public static final int _sigwaitOffset_;
	public static final int _user_stackOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_exit_threadOffset_ = 0;
		_p_acflagOffset_ = 0;
		_p_addrOffset_ = 0;
		_p_commOffset_ = 0;
		_p_cpticksOffset_ = 0;
		_p_debuggerOffset_ = 0;
		_p_dupfdOffset_ = 0;
		_p_estcpuOffset_ = 0;
		_p_flagOffset_ = 0;
		_p_holdcntOffset_ = 0;
		_p_iticksOffset_ = 0;
		_p_niceOffset_ = 0;
		_p_oppidOffset_ = 0;
		_p_pctcpuOffset_ = 0;
		_p_pgrpOffset_ = 0;
		_p_pidOffset_ = 0;
		_p_priorityOffset_ = 0;
		_p_realtimerOffset_ = 0;
		_p_rtimeOffset_ = 0;
		_p_ruOffset_ = 0;
		_p_sigactsOffset_ = 0;
		_p_sigcatchOffset_ = 0;
		_p_sigignoreOffset_ = 0;
		_p_siglistOffset_ = 0;
		_p_sigmaskOffset_ = 0;
		_p_slptimeOffset_ = 0;
		_p_statOffset_ = 0;
		_p_sticksOffset_ = 0;
		_p_swtimeOffset_ = 0;
		_p_textvpOffset_ = 0;
		_p_traceflagOffset_ = 0;
		_p_tracepOffset_ = 0;
		_p_un$__p_starttimeOffset_ = 0;
		_p_un$p_st1$__p_backOffset_ = 0;
		_p_un$p_st1$__p_forwOffset_ = 0;
		_p_usrpriOffset_ = 0;
		_p_uticksOffset_ = 0;
		_p_vmspaceOffset_ = 0;
		_p_wchanOffset_ = 0;
		_p_wmesgOffset_ = 0;
		_p_xstatOffset_ = 0;
		_sigwaitOffset_ = 0;
		_user_stackOffset_ = 0;
	}

}
