/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: J9RemoteDbgInfoConstants
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class J9RemoteDbgInfoConstants {

	// VM Constants

	public static final long SIZEOF;
	public static final long RDBGID_JXE;
	public static final long RDBGID_ROM;
	public static final long RDBGInfoErr_NoInfo;
	public static final long RDBGInfoFlag_ClassInfo;
	public static final long RDBGInfoFlag_Locked;
	public static final long RDBGInfoFlag_MethodInfo;
	public static final long RDBGInfoFlag_SourceDebugExtension;
	public static final long RDBGInfo_Ok;
	public static final long RDBGRequestType_ClassInfoVM;
	public static final long RDBGRequestType_MethodInfoVM;
	public static final long RDBGRequestType_SourceDebugExtension;
	public static final long RDBGRequestType_SymbolFile;
	public static final long RDBGRequestType_TargetName;
	public static final long RDBGRequestType_TranslateClass;


	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		RDBGID_JXE = 0;
		RDBGID_ROM = 0;
		RDBGInfoErr_NoInfo = 0;
		RDBGInfoFlag_ClassInfo = 0;
		RDBGInfoFlag_Locked = 0;
		RDBGInfoFlag_MethodInfo = 0;
		RDBGInfoFlag_SourceDebugExtension = 0;
		RDBGInfo_Ok = 0;
		RDBGRequestType_ClassInfoVM = 0;
		RDBGRequestType_MethodInfoVM = 0;
		RDBGRequestType_SourceDebugExtension = 0;
		RDBGRequestType_SymbolFile = 0;
		RDBGRequestType_TargetName = 0;
		RDBGRequestType_TranslateClass = 0;
	}

}
