/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: shmid_dsPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the shmid_dsPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=shmid_ds.class)
public class shmid_dsPointer extends StructurePointer {

	// NULL
	public static final shmid_dsPointer NULL = new shmid_dsPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected shmid_dsPointer(long address) {
		super(address);
	}

	public static shmid_dsPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static shmid_dsPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static shmid_dsPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new shmid_dsPointer(address);
	}

	public shmid_dsPointer add(long count) {
		return shmid_dsPointer.cast(address + (shmid_ds.SIZEOF * count));
	}

	public shmid_dsPointer add(Scalar count) {
		return add(count.longValue());
	}

	public shmid_dsPointer addOffset(long offset) {
		return shmid_dsPointer.cast(address + offset);
	}

	public shmid_dsPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public shmid_dsPointer sub(long count) {
		return shmid_dsPointer.cast(address - (shmid_ds.SIZEOF * count));
	}

	public shmid_dsPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public shmid_dsPointer subOffset(long offset) {
		return shmid_dsPointer.cast(address - offset);
	}

	public shmid_dsPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public shmid_dsPointer untag(long mask) {
		return shmid_dsPointer.cast(address & ~mask);
	}

	public shmid_dsPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return shmid_ds.SIZEOF;
	}

	// Implementation methods

	// time_t shm_atime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_atimeOffset_", declaredType="time_t")
	public IDATA shm_atime() throws CorruptDataException {
		return new I64(getLongAtOffset(shmid_ds._shm_atimeOffset_));
	}

	// time_t shm_atime
	public IDATAPointer shm_atimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_atimeOffset_));
	}

	// shmatt_t shm_cnattch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_cnattchOffset_", declaredType="shmatt_t")
	public UDATA shm_cnattch() throws CorruptDataException {
		return new U64(getLongAtOffset(shmid_ds._shm_cnattchOffset_));
	}

	// shmatt_t shm_cnattch
	public UDATAPointer shm_cnattchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_cnattchOffset_));
	}

	// pid_t shm_cpid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_cpidOffset_", declaredType="pid_t")
	public IDATA shm_cpid() throws CorruptDataException {
		return new I32(getIntAtOffset(shmid_ds._shm_cpidOffset_));
	}

	// pid_t shm_cpid
	public IDATAPointer shm_cpidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_cpidOffset_));
	}

	// time_t shm_ctime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_ctimeOffset_", declaredType="time_t")
	public IDATA shm_ctime() throws CorruptDataException {
		return new I64(getLongAtOffset(shmid_ds._shm_ctimeOffset_));
	}

	// time_t shm_ctime
	public IDATAPointer shm_ctimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_ctimeOffset_));
	}

	// time_t shm_dtime
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_dtimeOffset_", declaredType="time_t")
	public IDATA shm_dtime() throws CorruptDataException {
		return new I64(getLongAtOffset(shmid_ds._shm_dtimeOffset_));
	}

	// time_t shm_dtime
	public IDATAPointer shm_dtimeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_dtimeOffset_));
	}

	// I32 shm_extshm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_extshmOffset_", declaredType="I32")
	public IDATA shm_extshm() throws CorruptDataException {
		return new I32(getIntAtOffset(shmid_ds._shm_extshmOffset_));
	}

	// I32 shm_extshm
	public IDATAPointer shm_extshmEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_extshmOffset_));
	}

	// __ulong32_t shm_handle
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_handleOffset_", declaredType="__ulong32_t")
	public UDATA shm_handle() throws CorruptDataException {
		return new U32(getIntAtOffset(shmid_ds._shm_handleOffset_));
	}

	// __ulong32_t shm_handle
	public UDATAPointer shm_handleEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_handleOffset_));
	}

	// U64 shm_lba
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_lbaOffset_", declaredType="U64")
	public UDATA shm_lba() throws CorruptDataException {
		return new U64(getLongAtOffset(shmid_ds._shm_lbaOffset_));
	}

	// U64 shm_lba
	public UDATAPointer shm_lbaEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_lbaOffset_));
	}

	// pid_t shm_lpid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_lpidOffset_", declaredType="pid_t")
	public IDATA shm_lpid() throws CorruptDataException {
		return new I32(getIntAtOffset(shmid_ds._shm_lpidOffset_));
	}

	// pid_t shm_lpid
	public IDATAPointer shm_lpidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_lpidOffset_));
	}

	// shmatt_t shm_nattch
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_nattchOffset_", declaredType="shmatt_t")
	public UDATA shm_nattch() throws CorruptDataException {
		return new U64(getLongAtOffset(shmid_ds._shm_nattchOffset_));
	}

	// shmatt_t shm_nattch
	public UDATAPointer shm_nattchEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_nattchOffset_));
	}

	// I64 shm_pagesize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_pagesizeOffset_", declaredType="I64")
	public IDATA shm_pagesize() throws CorruptDataException {
		return new I64(getLongAtOffset(shmid_ds._shm_pagesizeOffset_));
	}

	// I64 shm_pagesize
	public IDATAPointer shm_pagesizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_pagesizeOffset_));
	}

	// ipc_perm shm_perm
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_permOffset_", declaredType="ipc_perm")
	public ipc_permPointer shm_perm() throws CorruptDataException {
		return ipc_permPointer.cast(nonNullFieldEA(shmid_ds._shm_permOffset_));
	}

	// ipc_perm shm_perm
	public PointerPointer shm_permEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(shmid_ds._shm_permOffset_));
	}

	// I64 shm_reserved0
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_reserved0Offset_", declaredType="I64")
	public IDATA shm_reserved0() throws CorruptDataException {
		return new I64(getLongAtOffset(shmid_ds._shm_reserved0Offset_));
	}

	// I64 shm_reserved0
	public IDATAPointer shm_reserved0EA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_reserved0Offset_));
	}

	// I64 shm_reserved1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_reserved1Offset_", declaredType="I64")
	public IDATA shm_reserved1() throws CorruptDataException {
		return new I64(getLongAtOffset(shmid_ds._shm_reserved1Offset_));
	}

	// I64 shm_reserved1
	public IDATAPointer shm_reserved1EA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_reserved1Offset_));
	}

	// size_t shm_segsz
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_shm_segszOffset_", declaredType="size_t")
	public UDATA shm_segsz() throws CorruptDataException {
		return new U64(getLongAtOffset(shmid_ds._shm_segszOffset_));
	}

	// size_t shm_segsz
	public UDATAPointer shm_segszEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(shmid_ds._shm_segszOffset_));
	}

}
