/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: __context64Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the __context64Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=__context64.class)
public class __context64Pointer extends StructurePointer {

	// NULL
	public static final __context64Pointer NULL = new __context64Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected __context64Pointer(long address) {
		super(address);
	}

	public static __context64Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static __context64Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static __context64Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new __context64Pointer(address);
	}

	public __context64Pointer add(long count) {
		return __context64Pointer.cast(address + (__context64.SIZEOF * count));
	}

	public __context64Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public __context64Pointer addOffset(long offset) {
		return __context64Pointer.cast(address + offset);
	}

	public __context64Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public __context64Pointer sub(long count) {
		return __context64Pointer.cast(address - (__context64.SIZEOF * count));
	}

	public __context64Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public __context64Pointer subOffset(long offset) {
		return __context64Pointer.cast(address - offset);
	}

	public __context64Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public __context64Pointer untag(long mask) {
		return __context64Pointer.cast(address & ~mask);
	}

	public __context64Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return __context64.SIZEOF;
	}

	// Implementation methods

	// U32 cr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_crOffset_", declaredType="U32")
	public UDATA cr() throws CorruptDataException {
		return new U32(getIntAtOffset(__context64._crOffset_));
	}

	// U32 cr
	public UDATAPointer crEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__context64._crOffset_));
	}

	// U64 ctr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_ctrOffset_", declaredType="U64")
	public UDATA ctr() throws CorruptDataException {
		return new U64(getLongAtOffset(__context64._ctrOffset_));
	}

	// U64 ctr
	public UDATAPointer ctrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__context64._ctrOffset_));
	}

	// U64[] except
	public UDATAPointer exceptEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(__context64._exceptOffset_));
	}

	// I32 excp_type
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_excp_typeOffset_", declaredType="I32")
	public IDATA excp_type() throws CorruptDataException {
		return new I32(getIntAtOffset(__context64._excp_typeOffset_));
	}

	// I32 excp_type
	public IDATAPointer excp_typeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(__context64._excp_typeOffset_));
	}

	// U8 fpeu
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpeuOffset_", declaredType="U8")
	public U8 fpeu() throws CorruptDataException {
		return new U8(getByteAtOffset(__context64._fpeuOffset_));
	}

	// U8 fpeu
	public U8Pointer fpeuEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(__context64._fpeuOffset_));
	}

	// U8 fpinfo
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpinfoOffset_", declaredType="U8")
	public U8 fpinfo() throws CorruptDataException {
		return new U8(getByteAtOffset(__context64._fpinfoOffset_));
	}

	// U8 fpinfo
	public U8Pointer fpinfoEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(__context64._fpinfoOffset_));
	}

	// double[] fpr
	public DoublePointer fprEA() throws CorruptDataException {
		return DoublePointer.cast(nonNullFieldEA(__context64._fprOffset_));
	}

	// U32 fpscr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpscrOffset_", declaredType="U32")
	public UDATA fpscr() throws CorruptDataException {
		return new U32(getIntAtOffset(__context64._fpscrOffset_));
	}

	// U32 fpscr
	public UDATAPointer fpscrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__context64._fpscrOffset_));
	}

	// U8 fpscr24_31
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpscr24_31Offset_", declaredType="U8")
	public U8 fpscr24_31() throws CorruptDataException {
		return new U8(getByteAtOffset(__context64._fpscr24_31Offset_));
	}

	// U8 fpscr24_31
	public U8Pointer fpscr24_31EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(__context64._fpscr24_31Offset_));
	}

	// U32 fpscrx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_fpscrxOffset_", declaredType="U32")
	public UDATA fpscrx() throws CorruptDataException {
		return new U32(getIntAtOffset(__context64._fpscrxOffset_));
	}

	// U32 fpscrx
	public UDATAPointer fpscrxEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__context64._fpscrxOffset_));
	}

	// U64[] gpr
	public UDATAPointer gprEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(__context64._gprOffset_));
	}

	// U64 iar
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_iarOffset_", declaredType="U64")
	public UDATA iar() throws CorruptDataException {
		return new U64(getLongAtOffset(__context64._iarOffset_));
	}

	// U64 iar
	public UDATAPointer iarEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__context64._iarOffset_));
	}

	// U64 lr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lrOffset_", declaredType="U64")
	public UDATA lr() throws CorruptDataException {
		return new U64(getLongAtOffset(__context64._lrOffset_));
	}

	// U64 lr
	public UDATAPointer lrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__context64._lrOffset_));
	}

	// U64 msr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_msrOffset_", declaredType="U64")
	public UDATA msr() throws CorruptDataException {
		return new U64(getLongAtOffset(__context64._msrOffset_));
	}

	// U64 msr
	public UDATAPointer msrEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__context64._msrOffset_));
	}

	// U8[] pad
	public U8Pointer padEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(__context64._padOffset_));
	}

	// U32 xer
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_xerOffset_", declaredType="U32")
	public UDATA xer() throws CorruptDataException {
		return new U32(getIntAtOffset(__context64._xerOffset_));
	}

	// U32 xer
	public UDATAPointer xerEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__context64._xerOffset_));
	}

}
