/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: __vftTypeGCCV3Pointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the __vftTypeGCCV3Pointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=__vftTypeGCCV3.class)
public class __vftTypeGCCV3Pointer extends StructurePointer {

	// NULL
	public static final __vftTypeGCCV3Pointer NULL = new __vftTypeGCCV3Pointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected __vftTypeGCCV3Pointer(long address) {
		super(address);
	}

	public static __vftTypeGCCV3Pointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static __vftTypeGCCV3Pointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static __vftTypeGCCV3Pointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new __vftTypeGCCV3Pointer(address);
	}

	public __vftTypeGCCV3Pointer add(long count) {
		return __vftTypeGCCV3Pointer.cast(address + (__vftTypeGCCV3.SIZEOF * count));
	}

	public __vftTypeGCCV3Pointer add(Scalar count) {
		return add(count.longValue());
	}

	public __vftTypeGCCV3Pointer addOffset(long offset) {
		return __vftTypeGCCV3Pointer.cast(address + offset);
	}

	public __vftTypeGCCV3Pointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public __vftTypeGCCV3Pointer sub(long count) {
		return __vftTypeGCCV3Pointer.cast(address - (__vftTypeGCCV3.SIZEOF * count));
	}

	public __vftTypeGCCV3Pointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public __vftTypeGCCV3Pointer subOffset(long offset) {
		return __vftTypeGCCV3Pointer.cast(address - offset);
	}

	public __vftTypeGCCV3Pointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public __vftTypeGCCV3Pointer untag(long mask) {
		return __vftTypeGCCV3Pointer.cast(address & ~mask);
	}

	public __vftTypeGCCV3Pointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return __vftTypeGCCV3.SIZEOF;
	}

	// Implementation methods

	// void* __faddr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___faddrOffset_", declaredType="void*")
	public VoidPointer __faddr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(__vftTypeGCCV3.___faddrOffset_));
	}

	// void* __faddr
	public PointerPointer __faddrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(__vftTypeGCCV3.___faddrOffset_));
	}

	// U64 __offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___offsetOffset_", declaredType="U64")
	public UDATA __offset() throws CorruptDataException {
		return new U64(getLongAtOffset(__vftTypeGCCV3.___offsetOffset_));
	}

	// U64 __offset
	public UDATAPointer __offsetEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(__vftTypeGCCV3.___offsetOffset_));
	}

}
