/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: coredumpinfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the coredumpinfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=coredumpinfo.class)
public class coredumpinfoPointer extends StructurePointer {

	// NULL
	public static final coredumpinfoPointer NULL = new coredumpinfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected coredumpinfoPointer(long address) {
		super(address);
	}

	public static coredumpinfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static coredumpinfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static coredumpinfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new coredumpinfoPointer(address);
	}

	public coredumpinfoPointer add(long count) {
		return coredumpinfoPointer.cast(address + (coredumpinfo.SIZEOF * count));
	}

	public coredumpinfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public coredumpinfoPointer addOffset(long offset) {
		return coredumpinfoPointer.cast(address + offset);
	}

	public coredumpinfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public coredumpinfoPointer sub(long count) {
		return coredumpinfoPointer.cast(address - (coredumpinfo.SIZEOF * count));
	}

	public coredumpinfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public coredumpinfoPointer subOffset(long offset) {
		return coredumpinfoPointer.cast(address - offset);
	}

	public coredumpinfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public coredumpinfoPointer untag(long mask) {
		return coredumpinfoPointer.cast(address & ~mask);
	}

	public coredumpinfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return coredumpinfo.SIZEOF;
	}

	// Implementation methods

	// I32 flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_flagsOffset_", declaredType="I32")
	public IDATA flags() throws CorruptDataException {
		return new I32(getIntAtOffset(coredumpinfo._flagsOffset_));
	}

	// I32 flags
	public IDATAPointer flagsEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(coredumpinfo._flagsOffset_));
	}

	// I32 length
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lengthOffset_", declaredType="I32")
	public IDATA length() throws CorruptDataException {
		return new I32(getIntAtOffset(coredumpinfo._lengthOffset_));
	}

	// I32 length
	public IDATAPointer lengthEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(coredumpinfo._lengthOffset_));
	}

	// U8* name
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_nameOffset_", declaredType="U8*")
	public U8Pointer name() throws CorruptDataException {
		return U8Pointer.cast(getPointerAtOffset(coredumpinfo._nameOffset_));
	}

	// U8* name
	public PointerPointer nameEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(coredumpinfo._nameOffset_));
	}

	// I32 pad
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_padOffset_", declaredType="I32")
	public IDATA pad() throws CorruptDataException {
		return new I32(getIntAtOffset(coredumpinfo._padOffset_));
	}

	// I32 pad
	public IDATAPointer padEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(coredumpinfo._padOffset_));
	}

	// pid_t pid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pidOffset_", declaredType="pid_t")
	public IDATA pid() throws CorruptDataException {
		return new I32(getIntAtOffset(coredumpinfo._pidOffset_));
	}

	// pid_t pid
	public IDATAPointer pidEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(coredumpinfo._pidOffset_));
	}

	// I32[] reserved
	public IDATAPointer reservedEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(coredumpinfo._reservedOffset_));
	}

}
