/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ipc_permPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ipc_permPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ipc_perm.class)
public class ipc_permPointer extends StructurePointer {

	// NULL
	public static final ipc_permPointer NULL = new ipc_permPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ipc_permPointer(long address) {
		super(address);
	}

	public static ipc_permPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ipc_permPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ipc_permPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ipc_permPointer(address);
	}

	public ipc_permPointer add(long count) {
		return ipc_permPointer.cast(address + (ipc_perm.SIZEOF * count));
	}

	public ipc_permPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ipc_permPointer addOffset(long offset) {
		return ipc_permPointer.cast(address + offset);
	}

	public ipc_permPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ipc_permPointer sub(long count) {
		return ipc_permPointer.cast(address - (ipc_perm.SIZEOF * count));
	}

	public ipc_permPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ipc_permPointer subOffset(long offset) {
		return ipc_permPointer.cast(address - offset);
	}

	public ipc_permPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ipc_permPointer untag(long mask) {
		return ipc_permPointer.cast(address & ~mask);
	}

	public ipc_permPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ipc_perm.SIZEOF;
	}

	// Implementation methods

	// U16 __reserved
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___reservedOffset_", declaredType="U16")
	public U16 __reserved() throws CorruptDataException {
		return new U16(getShortAtOffset(ipc_perm.___reservedOffset_));
	}

	// U16 __reserved
	public U16Pointer __reservedEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(ipc_perm.___reservedOffset_));
	}

	// gid_t cgid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cgidOffset_", declaredType="gid_t")
	public UDATA cgid() throws CorruptDataException {
		return new U32(getIntAtOffset(ipc_perm._cgidOffset_));
	}

	// gid_t cgid
	public UDATAPointer cgidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ipc_perm._cgidOffset_));
	}

	// uid_t cuid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_cuidOffset_", declaredType="uid_t")
	public UDATA cuid() throws CorruptDataException {
		return new U32(getIntAtOffset(ipc_perm._cuidOffset_));
	}

	// uid_t cuid
	public UDATAPointer cuidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ipc_perm._cuidOffset_));
	}

	// gid_t gid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_gidOffset_", declaredType="gid_t")
	public UDATA gid() throws CorruptDataException {
		return new U32(getIntAtOffset(ipc_perm._gidOffset_));
	}

	// gid_t gid
	public UDATAPointer gidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ipc_perm._gidOffset_));
	}

	// key_t key
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_keyOffset_", declaredType="key_t")
	public IDATA key() throws CorruptDataException {
		return new I32(getIntAtOffset(ipc_perm._keyOffset_));
	}

	// key_t key
	public IDATAPointer keyEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ipc_perm._keyOffset_));
	}

	// mode_t mode
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_modeOffset_", declaredType="mode_t")
	public UDATA mode() throws CorruptDataException {
		return new U32(getIntAtOffset(ipc_perm._modeOffset_));
	}

	// mode_t mode
	public UDATAPointer modeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ipc_perm._modeOffset_));
	}

	// U16 seq
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_seqOffset_", declaredType="U16")
	public U16 seq() throws CorruptDataException {
		return new U16(getShortAtOffset(ipc_perm._seqOffset_));
	}

	// U16 seq
	public U16Pointer seqEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(ipc_perm._seqOffset_));
	}

	// uid_t uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uidOffset_", declaredType="uid_t")
	public UDATA uid() throws CorruptDataException {
		return new U32(getIntAtOffset(ipc_perm._uidOffset_));
	}

	// uid_t uid
	public UDATAPointer uidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(ipc_perm._uidOffset_));
	}

}
