/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: lpar_info_format2_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the lpar_info_format2_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=lpar_info_format2_t.class)
public class lpar_info_format2_tPointer extends StructurePointer {

	// NULL
	public static final lpar_info_format2_tPointer NULL = new lpar_info_format2_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected lpar_info_format2_tPointer(long address) {
		super(address);
	}

	public static lpar_info_format2_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static lpar_info_format2_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static lpar_info_format2_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new lpar_info_format2_tPointer(address);
	}

	public lpar_info_format2_tPointer add(long count) {
		return lpar_info_format2_tPointer.cast(address + (lpar_info_format2_t.SIZEOF * count));
	}

	public lpar_info_format2_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public lpar_info_format2_tPointer addOffset(long offset) {
		return lpar_info_format2_tPointer.cast(address + offset);
	}

	public lpar_info_format2_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public lpar_info_format2_tPointer sub(long count) {
		return lpar_info_format2_tPointer.cast(address - (lpar_info_format2_t.SIZEOF * count));
	}

	public lpar_info_format2_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public lpar_info_format2_tPointer subOffset(long offset) {
		return lpar_info_format2_tPointer.cast(address - offset);
	}

	public lpar_info_format2_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public lpar_info_format2_tPointer untag(long mask) {
		return lpar_info_format2_tPointer.cast(address & ~mask);
	}

	public lpar_info_format2_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return lpar_info_format2_t.SIZEOF;
	}

	// Implementation methods

	// U64 dispatch_latency
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_dispatch_latencyOffset_", declaredType="U64")
	public UDATA dispatch_latency() throws CorruptDataException {
		return new U64(getLongAtOffset(lpar_info_format2_t._dispatch_latencyOffset_));
	}

	// U64 dispatch_latency
	public UDATAPointer dispatch_latencyEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._dispatch_latencyOffset_));
	}

	// uint entitled_capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_entitled_capacityOffset_", declaredType="uint")
	public UDATA entitled_capacity() throws CorruptDataException {
		return new U32(getIntAtOffset(lpar_info_format2_t._entitled_capacityOffset_));
	}

	// uint entitled_capacity
	public UDATAPointer entitled_capacityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._entitled_capacityOffset_));
	}

	// ushort group_id
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_group_idOffset_", declaredType="ushort")
	public U16 group_id() throws CorruptDataException {
		return new U16(getShortAtOffset(lpar_info_format2_t._group_idOffset_));
	}

	// ushort group_id
	public U16Pointer group_idEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(lpar_info_format2_t._group_idOffset_));
	}

	// uint lpar_flags
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_lpar_flagsOffset_", declaredType="uint")
	public UDATA lpar_flags() throws CorruptDataException {
		return new U32(getIntAtOffset(lpar_info_format2_t._lpar_flagsOffset_));
	}

	// uint lpar_flags
	public UDATAPointer lpar_flagsEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._lpar_flagsOffset_));
	}

	// uint min_req_vcpu_capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_min_req_vcpu_capacityOffset_", declaredType="uint")
	public UDATA min_req_vcpu_capacity() throws CorruptDataException {
		return new U32(getIntAtOffset(lpar_info_format2_t._min_req_vcpu_capacityOffset_));
	}

	// uint min_req_vcpu_capacity
	public UDATAPointer min_req_vcpu_capacityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._min_req_vcpu_capacityOffset_));
	}

	// uint online_lcpus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_online_lcpusOffset_", declaredType="uint")
	public UDATA online_lcpus() throws CorruptDataException {
		return new U32(getIntAtOffset(lpar_info_format2_t._online_lcpusOffset_));
	}

	// uint online_lcpus
	public UDATAPointer online_lcpusEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._online_lcpusOffset_));
	}

	// U64 online_memory
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_online_memoryOffset_", declaredType="U64")
	public UDATA online_memory() throws CorruptDataException {
		return new U64(getLongAtOffset(lpar_info_format2_t._online_memoryOffset_));
	}

	// U64 online_memory
	public UDATAPointer online_memoryEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._online_memoryOffset_));
	}

	// uint online_vcpus
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_online_vcpusOffset_", declaredType="uint")
	public UDATA online_vcpus() throws CorruptDataException {
		return new U32(getIntAtOffset(lpar_info_format2_t._online_vcpusOffset_));
	}

	// uint online_vcpus
	public UDATAPointer online_vcpusEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._online_vcpusOffset_));
	}

	// I32 pad0
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pad0Offset_", declaredType="I32")
	public IDATA pad0() throws CorruptDataException {
		return new I32(getIntAtOffset(lpar_info_format2_t._pad0Offset_));
	}

	// I32 pad0
	public IDATAPointer pad0EA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._pad0Offset_));
	}

	// U8[] pad1
	public U8Pointer pad1EA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(lpar_info_format2_t._pad1Offset_));
	}

	// uint pcpus_in_pool
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pcpus_in_poolOffset_", declaredType="uint")
	public UDATA pcpus_in_pool() throws CorruptDataException {
		return new U32(getIntAtOffset(lpar_info_format2_t._pcpus_in_poolOffset_));
	}

	// uint pcpus_in_pool
	public UDATAPointer pcpus_in_poolEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._pcpus_in_poolOffset_));
	}

	// uint pcpus_in_sys
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pcpus_in_sysOffset_", declaredType="uint")
	public UDATA pcpus_in_sys() throws CorruptDataException {
		return new U32(getIntAtOffset(lpar_info_format2_t._pcpus_in_sysOffset_));
	}

	// uint pcpus_in_sys
	public UDATAPointer pcpus_in_sysEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._pcpus_in_sysOffset_));
	}

	// ushort pool_id
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pool_idOffset_", declaredType="ushort")
	public U16 pool_id() throws CorruptDataException {
		return new U16(getShortAtOffset(lpar_info_format2_t._pool_idOffset_));
	}

	// ushort pool_id
	public U16Pointer pool_idEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(lpar_info_format2_t._pool_idOffset_));
	}

	// U64 pool_idle_time
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pool_idle_timeOffset_", declaredType="U64")
	public UDATA pool_idle_time() throws CorruptDataException {
		return new U64(getLongAtOffset(lpar_info_format2_t._pool_idle_timeOffset_));
	}

	// U64 pool_idle_time
	public UDATAPointer pool_idle_timeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._pool_idle_timeOffset_));
	}

	// U64 tot_dispatch_time
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_tot_dispatch_timeOffset_", declaredType="U64")
	public UDATA tot_dispatch_time() throws CorruptDataException {
		return new U64(getLongAtOffset(lpar_info_format2_t._tot_dispatch_timeOffset_));
	}

	// U64 tot_dispatch_time
	public UDATAPointer tot_dispatch_timeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._tot_dispatch_timeOffset_));
	}

	// uint unalloc_capacity
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_unalloc_capacityOffset_", declaredType="uint")
	public UDATA unalloc_capacity() throws CorruptDataException {
		return new U32(getIntAtOffset(lpar_info_format2_t._unalloc_capacityOffset_));
	}

	// uint unalloc_capacity
	public UDATAPointer unalloc_capacityEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._unalloc_capacityOffset_));
	}

	// uint unalloc_weight
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_unalloc_weightOffset_", declaredType="uint")
	public UDATA unalloc_weight() throws CorruptDataException {
		return new U32(getIntAtOffset(lpar_info_format2_t._unalloc_weightOffset_));
	}

	// uint unalloc_weight
	public UDATAPointer unalloc_weightEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._unalloc_weightOffset_));
	}

	// uint variable_weight
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_variable_weightOffset_", declaredType="uint")
	public UDATA variable_weight() throws CorruptDataException {
		return new U32(getIntAtOffset(lpar_info_format2_t._variable_weightOffset_));
	}

	// uint variable_weight
	public UDATAPointer variable_weightEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._variable_weightOffset_));
	}

	// I32 version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_versionOffset_", declaredType="I32")
	public IDATA version() throws CorruptDataException {
		return new I32(getIntAtOffset(lpar_info_format2_t._versionOffset_));
	}

	// I32 version
	public IDATAPointer versionEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(lpar_info_format2_t._versionOffset_));
	}

}
