/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: psinfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the psinfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=psinfo.class)
public class psinfoPointer extends StructurePointer {

	// NULL
	public static final psinfoPointer NULL = new psinfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected psinfoPointer(long address) {
		super(address);
	}

	public static psinfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static psinfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static psinfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new psinfoPointer(address);
	}

	public psinfoPointer add(long count) {
		return psinfoPointer.cast(address + (psinfo.SIZEOF * count));
	}

	public psinfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public psinfoPointer addOffset(long offset) {
		return psinfoPointer.cast(address + offset);
	}

	public psinfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public psinfoPointer sub(long count) {
		return psinfoPointer.cast(address - (psinfo.SIZEOF * count));
	}

	public psinfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public psinfoPointer subOffset(long offset) {
		return psinfoPointer.cast(address - offset);
	}

	public psinfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public psinfoPointer untag(long mask) {
		return psinfoPointer.cast(address & ~mask);
	}

	public psinfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return psinfo.SIZEOF;
	}

	// Implementation methods

	// U64[] pr__pad
	public UDATAPointer pr__padEA() throws CorruptDataException {
		return U64Pointer.cast(nonNullFieldEA(psinfo._pr__padOffset_));
	}

	// U32 pr__pad1
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr__pad1Offset_", declaredType="U32")
	public UDATA pr__pad1() throws CorruptDataException {
		return new U32(getIntAtOffset(psinfo._pr__pad1Offset_));
	}

	// U32 pr__pad1
	public UDATAPointer pr__pad1EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr__pad1Offset_));
	}

	// ushort_t pr__pad2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr__pad2Offset_", declaredType="ushort_t")
	public U16 pr__pad2() throws CorruptDataException {
		return new U16(getShortAtOffset(psinfo._pr__pad2Offset_));
	}

	// ushort_t pr__pad2
	public U16Pointer pr__pad2EA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(psinfo._pr__pad2Offset_));
	}

	// prptr64_t pr_addr
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_addrOffset_", declaredType="prptr64_t")
	public VoidPointer pr_addr() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(psinfo._pr_addrOffset_));
	}

	// prptr64_t pr_addr
	public PointerPointer pr_addrEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(psinfo._pr_addrOffset_));
	}

	// U32 pr_argc
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_argcOffset_", declaredType="U32")
	public UDATA pr_argc() throws CorruptDataException {
		return new U32(getIntAtOffset(psinfo._pr_argcOffset_));
	}

	// U32 pr_argc
	public UDATAPointer pr_argcEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_argcOffset_));
	}

	// prptr64_t pr_argv
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_argvOffset_", declaredType="prptr64_t")
	public VoidPointer pr_argv() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(psinfo._pr_argvOffset_));
	}

	// prptr64_t pr_argv
	public PointerPointer pr_argvEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(psinfo._pr_argvOffset_));
	}

	// cid_t pr_cid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_cidOffset_", declaredType="cid_t")
	public U16 pr_cid() throws CorruptDataException {
		return new U16(getShortAtOffset(psinfo._pr_cidOffset_));
	}

	// cid_t pr_cid
	public U16Pointer pr_cidEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(psinfo._pr_cidOffset_));
	}

	// U64 pr_egid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_egidOffset_", declaredType="U64")
	public UDATA pr_egid() throws CorruptDataException {
		return new U64(getLongAtOffset(psinfo._pr_egidOffset_));
	}

	// U64 pr_egid
	public UDATAPointer pr_egidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_egidOffset_));
	}

	// prptr64_t pr_envp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_envpOffset_", declaredType="prptr64_t")
	public VoidPointer pr_envp() throws CorruptDataException {
		return VoidPointer.cast(getPointerAtOffset(psinfo._pr_envpOffset_));
	}

	// prptr64_t pr_envp
	public PointerPointer pr_envpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(psinfo._pr_envpOffset_));
	}

	// U64 pr_euid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_euidOffset_", declaredType="U64")
	public UDATA pr_euid() throws CorruptDataException {
		return new U64(getLongAtOffset(psinfo._pr_euidOffset_));
	}

	// U64 pr_euid
	public UDATAPointer pr_euidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_euidOffset_));
	}

	// U32 pr_flag
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_flagOffset_", declaredType="U32")
	public UDATA pr_flag() throws CorruptDataException {
		return new U32(getIntAtOffset(psinfo._pr_flagOffset_));
	}

	// U32 pr_flag
	public UDATAPointer pr_flagEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_flagOffset_));
	}

	// U32 pr_flag2
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_flag2Offset_", declaredType="U32")
	public UDATA pr_flag2() throws CorruptDataException {
		return new U32(getIntAtOffset(psinfo._pr_flag2Offset_));
	}

	// U32 pr_flag2
	public UDATAPointer pr_flag2EA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_flag2Offset_));
	}

	// U8[] pr_fname
	public U8Pointer pr_fnameEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(psinfo._pr_fnameOffset_));
	}

	// U64 pr_gid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_gidOffset_", declaredType="U64")
	public UDATA pr_gid() throws CorruptDataException {
		return new U64(getLongAtOffset(psinfo._pr_gidOffset_));
	}

	// U64 pr_gid
	public UDATAPointer pr_gidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_gidOffset_));
	}

	// lwpsinfo pr_lwp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_lwpOffset_", declaredType="lwpsinfo")
	public lwpsinfoPointer pr_lwp() throws CorruptDataException {
		return lwpsinfoPointer.cast(nonNullFieldEA(psinfo._pr_lwpOffset_));
	}

	// lwpsinfo pr_lwp
	public PointerPointer pr_lwpEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(psinfo._pr_lwpOffset_));
	}

	// U32 pr_nlwp
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_nlwpOffset_", declaredType="U32")
	public UDATA pr_nlwp() throws CorruptDataException {
		return new U32(getIntAtOffset(psinfo._pr_nlwpOffset_));
	}

	// U32 pr_nlwp
	public UDATAPointer pr_nlwpEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_nlwpOffset_));
	}

	// U64 pr_pgid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_pgidOffset_", declaredType="U64")
	public UDATA pr_pgid() throws CorruptDataException {
		return new U64(getLongAtOffset(psinfo._pr_pgidOffset_));
	}

	// U64 pr_pgid
	public UDATAPointer pr_pgidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_pgidOffset_));
	}

	// U64 pr_pid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_pidOffset_", declaredType="U64")
	public UDATA pr_pid() throws CorruptDataException {
		return new U64(getLongAtOffset(psinfo._pr_pidOffset_));
	}

	// U64 pr_pid
	public UDATAPointer pr_pidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_pidOffset_));
	}

	// U64 pr_ppid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_ppidOffset_", declaredType="U64")
	public UDATA pr_ppid() throws CorruptDataException {
		return new U64(getLongAtOffset(psinfo._pr_ppidOffset_));
	}

	// U64 pr_ppid
	public UDATAPointer pr_ppidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_ppidOffset_));
	}

	// U8[] pr_psargs
	public U8Pointer pr_psargsEA() throws CorruptDataException {
		return U8Pointer.cast(nonNullFieldEA(psinfo._pr_psargsOffset_));
	}

	// U64 pr_rssize
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_rssizeOffset_", declaredType="U64")
	public UDATA pr_rssize() throws CorruptDataException {
		return new U64(getLongAtOffset(psinfo._pr_rssizeOffset_));
	}

	// U64 pr_rssize
	public UDATAPointer pr_rssizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_rssizeOffset_));
	}

	// U64 pr_sid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_sidOffset_", declaredType="U64")
	public UDATA pr_sid() throws CorruptDataException {
		return new U64(getLongAtOffset(psinfo._pr_sidOffset_));
	}

	// U64 pr_sid
	public UDATAPointer pr_sidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_sidOffset_));
	}

	// U64 pr_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_sizeOffset_", declaredType="U64")
	public UDATA pr_size() throws CorruptDataException {
		return new U64(getLongAtOffset(psinfo._pr_sizeOffset_));
	}

	// U64 pr_size
	public UDATAPointer pr_sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_sizeOffset_));
	}

	// pr_timestruc64_t pr_start
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_startOffset_", declaredType="pr_timestruc64_t")
	public pr_timestruc64Pointer pr_start() throws CorruptDataException {
		return pr_timestruc64Pointer.cast(nonNullFieldEA(psinfo._pr_startOffset_));
	}

	// pr_timestruc64_t pr_start
	public PointerPointer pr_startEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(psinfo._pr_startOffset_));
	}

	// pr_timestruc64_t pr_time
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_timeOffset_", declaredType="pr_timestruc64_t")
	public pr_timestruc64Pointer pr_time() throws CorruptDataException {
		return pr_timestruc64Pointer.cast(nonNullFieldEA(psinfo._pr_timeOffset_));
	}

	// pr_timestruc64_t pr_time
	public PointerPointer pr_timeEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(psinfo._pr_timeOffset_));
	}

	// U64 pr_ttydev
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_ttydevOffset_", declaredType="U64")
	public UDATA pr_ttydev() throws CorruptDataException {
		return new U64(getLongAtOffset(psinfo._pr_ttydevOffset_));
	}

	// U64 pr_ttydev
	public UDATAPointer pr_ttydevEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_ttydevOffset_));
	}

	// U64 pr_uid
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_pr_uidOffset_", declaredType="U64")
	public UDATA pr_uid() throws CorruptDataException {
		return new U64(getLongAtOffset(psinfo._pr_uidOffset_));
	}

	// U64 pr_uid
	public UDATAPointer pr_uidEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(psinfo._pr_uidOffset_));
	}

}
