/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: subrangePointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the subrangePointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=subrange.class)
public class subrangePointer extends StructurePointer {

	// NULL
	public static final subrangePointer NULL = new subrangePointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected subrangePointer(long address) {
		super(address);
	}

	public static subrangePointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static subrangePointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static subrangePointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new subrangePointer(address);
	}

	public subrangePointer add(long count) {
		return subrangePointer.cast(address + (subrange.SIZEOF * count));
	}

	public subrangePointer add(Scalar count) {
		return add(count.longValue());
	}

	public subrangePointer addOffset(long offset) {
		return subrangePointer.cast(address + offset);
	}

	public subrangePointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public subrangePointer sub(long count) {
		return subrangePointer.cast(address - (subrange.SIZEOF * count));
	}

	public subrangePointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public subrangePointer subOffset(long offset) {
		return subrangePointer.cast(address - offset);
	}

	public subrangePointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public subrangePointer untag(long mask) {
		return subrangePointer.cast(address & ~mask);
	}

	public subrangePointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return subrange.SIZEOF;
	}

	// Implementation methods

	// size64_t su_length
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_su_lengthOffset_", declaredType="size64_t")
	public UDATA su_length() throws CorruptDataException {
		return new U64(getLongAtOffset(subrange._su_lengthOffset_));
	}

	// size64_t su_length
	public UDATAPointer su_lengthEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(subrange._su_lengthOffset_));
	}

	// off64_t su_offset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_su_offsetOffset_", declaredType="off64_t")
	public IDATA su_offset() throws CorruptDataException {
		return new I64(getLongAtOffset(subrange._su_offsetOffset_));
	}

	// off64_t su_offset
	public IDATAPointer su_offsetEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(subrange._su_offsetOffset_));
	}

	// uint_t su_policy
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_su_policyOffset_", declaredType="uint_t")
	public UDATA su_policy() throws CorruptDataException {
		return new U32(getIntAtOffset(subrange._su_policyOffset_));
	}

	// uint_t su_policy
	public UDATAPointer su_policyEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(subrange._su_policyOffset_));
	}

	// size64_t su_rslength
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_su_rslengthOffset_", declaredType="size64_t")
	public UDATA su_rslength() throws CorruptDataException {
		return new U64(getLongAtOffset(subrange._su_rslengthOffset_));
	}

	// size64_t su_rslength
	public UDATAPointer su_rslengthEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(subrange._su_rslengthOffset_));
	}

	// off64_t su_rsoffset
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_su_rsoffsetOffset_", declaredType="off64_t")
	public IDATA su_rsoffset() throws CorruptDataException {
		return new I64(getLongAtOffset(subrange._su_rsoffsetOffset_));
	}

	// off64_t su_rsoffset
	public IDATAPointer su_rsoffsetEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(subrange._su_rsoffsetOffset_));
	}

	// rstype_t su_rstype
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_su_rstypeOffset_", declaredType="rstype_t")
	public IDATA su_rstype() throws CorruptDataException {
		return new I32(getIntAtOffset(subrange._su_rstypeOffset_));
	}

	// rstype_t su_rstype
	public IDATAPointer su_rstypeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(subrange._su_rstypeOffset_));
	}

}
