/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: ucontext_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the ucontext_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=ucontext_t.class)
public class ucontext_tPointer extends StructurePointer {

	// NULL
	public static final ucontext_tPointer NULL = new ucontext_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected ucontext_tPointer(long address) {
		super(address);
	}

	public static ucontext_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static ucontext_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static ucontext_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new ucontext_tPointer(address);
	}

	public ucontext_tPointer add(long count) {
		return ucontext_tPointer.cast(address + (ucontext_t.SIZEOF * count));
	}

	public ucontext_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public ucontext_tPointer addOffset(long offset) {
		return ucontext_tPointer.cast(address + offset);
	}

	public ucontext_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public ucontext_tPointer sub(long count) {
		return ucontext_tPointer.cast(address - (ucontext_t.SIZEOF * count));
	}

	public ucontext_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public ucontext_tPointer subOffset(long offset) {
		return ucontext_tPointer.cast(address - offset);
	}

	public ucontext_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public ucontext_tPointer untag(long mask) {
		return ucontext_tPointer.cast(address & ~mask);
	}

	public ucontext_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return ucontext_t.SIZEOF;
	}

	// Implementation methods

	// __extctx_t* __extctx
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___extctxOffset_", declaredType="__extctx_t*")
	public __extctxPointer __extctx() throws CorruptDataException {
		return __extctxPointer.cast(getPointerAtOffset(ucontext_t.___extctxOffset_));
	}

	// __extctx_t* __extctx
	public PointerPointer __extctxEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucontext_t.___extctxOffset_));
	}

	// I32 __extctx_magic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___extctx_magicOffset_", declaredType="I32")
	public IDATA __extctx_magic() throws CorruptDataException {
		return new I32(getIntAtOffset(ucontext_t.___extctx_magicOffset_));
	}

	// I32 __extctx_magic
	public IDATAPointer __extctx_magicEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ucontext_t.___extctx_magicOffset_));
	}

	// I32[] __pad
	public IDATAPointer __padEA() throws CorruptDataException {
		return I32Pointer.cast(nonNullFieldEA(ucontext_t.___padOffset_));
	}

	// I32 __sc_onstack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___sc_onstackOffset_", declaredType="I32")
	public IDATA __sc_onstack() throws CorruptDataException {
		return new I32(getIntAtOffset(ucontext_t.___sc_onstackOffset_));
	}

	// I32 __sc_onstack
	public IDATAPointer __sc_onstackEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ucontext_t.___sc_onstackOffset_));
	}

	// I32 __sc_uerror
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___sc_uerrorOffset_", declaredType="I32")
	public IDATA __sc_uerror() throws CorruptDataException {
		return new I32(getIntAtOffset(ucontext_t.___sc_uerrorOffset_));
	}

	// I32 __sc_uerror
	public IDATAPointer __sc_uerrorEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(ucontext_t.___sc_uerrorOffset_));
	}

	// __extctx_t __x
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___xOffset_", declaredType="__extctx_t")
	public __extctxPointer __x() throws CorruptDataException {
		return __extctxPointer.cast(nonNullFieldEA(ucontext_t.___xOffset_));
	}

	// __extctx_t __x
	public PointerPointer __xEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucontext_t.___xOffset_));
	}

	// ucontext_t* uc_link
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_linkOffset_", declaredType="ucontext_t*")
	public ucontext_tPointer uc_link() throws CorruptDataException {
		return ucontext_tPointer.cast(getPointerAtOffset(ucontext_t._uc_linkOffset_));
	}

	// ucontext_t* uc_link
	public PointerPointer uc_linkEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucontext_t._uc_linkOffset_));
	}

	// mcontext_t uc_mcontext
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_mcontextOffset_", declaredType="mcontext_t")
	public __jmpbufPointer uc_mcontext() throws CorruptDataException {
		return __jmpbufPointer.cast(nonNullFieldEA(ucontext_t._uc_mcontextOffset_));
	}

	// mcontext_t uc_mcontext
	public PointerPointer uc_mcontextEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucontext_t._uc_mcontextOffset_));
	}

	// sigset_t uc_sigmask
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_sigmaskOffset_", declaredType="sigset_t")
	public sigset_tPointer uc_sigmask() throws CorruptDataException {
		return sigset_tPointer.cast(nonNullFieldEA(ucontext_t._uc_sigmaskOffset_));
	}

	// sigset_t uc_sigmask
	public PointerPointer uc_sigmaskEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucontext_t._uc_sigmaskOffset_));
	}

	// stack_t uc_stack
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_uc_stackOffset_", declaredType="stack_t")
	public stack_tPointer uc_stack() throws CorruptDataException {
		return stack_tPointer.cast(nonNullFieldEA(ucontext_t._uc_stackOffset_));
	}

	// stack_t uc_stack
	public PointerPointer uc_stackEA() throws CorruptDataException {
		return PointerPointer.cast(nonNullFieldEA(ucontext_t._uc_stackOffset_));
	}

}
