/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: vm_srad_meminfoPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the vm_srad_meminfoPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=vm_srad_meminfo.class)
public class vm_srad_meminfoPointer extends StructurePointer {

	// NULL
	public static final vm_srad_meminfoPointer NULL = new vm_srad_meminfoPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected vm_srad_meminfoPointer(long address) {
		super(address);
	}

	public static vm_srad_meminfoPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static vm_srad_meminfoPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static vm_srad_meminfoPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new vm_srad_meminfoPointer(address);
	}

	public vm_srad_meminfoPointer add(long count) {
		return vm_srad_meminfoPointer.cast(address + (vm_srad_meminfo.SIZEOF * count));
	}

	public vm_srad_meminfoPointer add(Scalar count) {
		return add(count.longValue());
	}

	public vm_srad_meminfoPointer addOffset(long offset) {
		return vm_srad_meminfoPointer.cast(address + offset);
	}

	public vm_srad_meminfoPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public vm_srad_meminfoPointer sub(long count) {
		return vm_srad_meminfoPointer.cast(address - (vm_srad_meminfo.SIZEOF * count));
	}

	public vm_srad_meminfoPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public vm_srad_meminfoPointer subOffset(long offset) {
		return vm_srad_meminfoPointer.cast(address - offset);
	}

	public vm_srad_meminfoPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public vm_srad_meminfoPointer untag(long mask) {
		return vm_srad_meminfoPointer.cast(address & ~mask);
	}

	public vm_srad_meminfoPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return vm_srad_meminfo.SIZEOF;
	}

	// Implementation methods

	// I32 vmsrad_aff_avail_pct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmsrad_aff_avail_pctOffset_", declaredType="I32")
	public IDATA vmsrad_aff_avail_pct() throws CorruptDataException {
		return new I32(getIntAtOffset(vm_srad_meminfo._vmsrad_aff_avail_pctOffset_));
	}

	// I32 vmsrad_aff_avail_pct
	public IDATAPointer vmsrad_aff_avail_pctEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vm_srad_meminfo._vmsrad_aff_avail_pctOffset_));
	}

	// I32 vmsrad_aff_priv_pct
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmsrad_aff_priv_pctOffset_", declaredType="I32")
	public IDATA vmsrad_aff_priv_pct() throws CorruptDataException {
		return new I32(getIntAtOffset(vm_srad_meminfo._vmsrad_aff_priv_pctOffset_));
	}

	// I32 vmsrad_aff_priv_pct
	public IDATAPointer vmsrad_aff_priv_pctEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vm_srad_meminfo._vmsrad_aff_priv_pctOffset_));
	}

	// size64_t vmsrad_file
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmsrad_fileOffset_", declaredType="size64_t")
	public UDATA vmsrad_file() throws CorruptDataException {
		return new U64(getLongAtOffset(vm_srad_meminfo._vmsrad_fileOffset_));
	}

	// size64_t vmsrad_file
	public UDATAPointer vmsrad_fileEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_srad_meminfo._vmsrad_fileOffset_));
	}

	// size64_t vmsrad_free_nonpg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmsrad_free_nonpgOffset_", declaredType="size64_t")
	public UDATA vmsrad_free_nonpg() throws CorruptDataException {
		return new U64(getLongAtOffset(vm_srad_meminfo._vmsrad_free_nonpgOffset_));
	}

	// size64_t vmsrad_free_nonpg
	public UDATAPointer vmsrad_free_nonpgEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_srad_meminfo._vmsrad_free_nonpgOffset_));
	}

	// size64_t vmsrad_free_pg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmsrad_free_pgOffset_", declaredType="size64_t")
	public UDATA vmsrad_free_pg() throws CorruptDataException {
		return new U64(getLongAtOffset(vm_srad_meminfo._vmsrad_free_pgOffset_));
	}

	// size64_t vmsrad_free_pg
	public UDATAPointer vmsrad_free_pgEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_srad_meminfo._vmsrad_free_pgOffset_));
	}

	// I32 vmsrad_in_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmsrad_in_sizeOffset_", declaredType="I32")
	public IDATA vmsrad_in_size() throws CorruptDataException {
		return new I32(getIntAtOffset(vm_srad_meminfo._vmsrad_in_sizeOffset_));
	}

	// I32 vmsrad_in_size
	public IDATAPointer vmsrad_in_sizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vm_srad_meminfo._vmsrad_in_sizeOffset_));
	}

	// I32 vmsrad_out_size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmsrad_out_sizeOffset_", declaredType="I32")
	public IDATA vmsrad_out_size() throws CorruptDataException {
		return new I32(getIntAtOffset(vm_srad_meminfo._vmsrad_out_sizeOffset_));
	}

	// I32 vmsrad_out_size
	public IDATAPointer vmsrad_out_sizeEA() throws CorruptDataException {
		return IDATAPointer.cast(nonNullFieldEA(vm_srad_meminfo._vmsrad_out_sizeOffset_));
	}

	// size64_t vmsrad_total_nonpg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmsrad_total_nonpgOffset_", declaredType="size64_t")
	public UDATA vmsrad_total_nonpg() throws CorruptDataException {
		return new U64(getLongAtOffset(vm_srad_meminfo._vmsrad_total_nonpgOffset_));
	}

	// size64_t vmsrad_total_nonpg
	public UDATAPointer vmsrad_total_nonpgEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_srad_meminfo._vmsrad_total_nonpgOffset_));
	}

	// size64_t vmsrad_total_pg
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="_vmsrad_total_pgOffset_", declaredType="size64_t")
	public UDATA vmsrad_total_pg() throws CorruptDataException {
		return new U64(getLongAtOffset(vm_srad_meminfo._vmsrad_total_pgOffset_));
	}

	// size64_t vmsrad_total_pg
	public UDATAPointer vmsrad_total_pgEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(vm_srad_meminfo._vmsrad_total_pgOffset_));
	}

}
