/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */
package com.ibm.j9ddr.vm29.structure;

/**
 * Structure: procsinfo
 *
 * This stub class represents a class that can return in memory offsets
 * to VM C and C++ structures.
 *
 * This particular implementation exists only to allow StructurePointer code to
 * compile at development time.  This is never loaded at run time.
 *
 * At runtime generated byte codes returning actual offset values from the core file
 * will be loaded by the StructureClassLoader.
 */
public final class procsinfo {

	// VM Constants

	public static final long SIZEOF;

	// Offsets

	public static final int _pi_acctflagsOffset_;
	public static final int _pi_adspaceOffset_;
	public static final int _pi_cdirOffset_;
	public static final int _pi_cidOffset_;
	public static final int _pi_classnameOffset_;
	public static final int _pi_cmaskOffset_;
	public static final int _pi_commOffset_;
	public static final int _pi_cpuOffset_;
	public static final int _pi_credOffset_;
	public static final int _pi_cruOffset_;
	public static final int _pi_data_l2psizeOffset_;
	public static final int _pi_drssOffset_;
	public static final int _pi_dsizeOffset_;
	public static final int _pi_dvmOffset_;
	public static final int _pi_flagsOffset_;
	public static final int _pi_flags2Offset_;
	public static final int _pi_iochOffset_;
	public static final int _pi_irssOffset_;
	public static final int _pi_majfltOffset_;
	public static final int _pi_maxofileOffset_;
	public static final int _pi_minfltOffset_;
	public static final int _pi_niceOffset_;
	public static final int _pi_pad4Offset_;
	public static final int _pi_pgrpOffset_;
	public static final int _pi_pidOffset_;
	public static final int _pi_policyOffset_;
	public static final int _pi_ppidOffset_;
	public static final int _pi_ppriOffset_;
	public static final int _pi_priOffset_;
	public static final int _pi_prmOffset_;
	public static final int _pi_projidOffset_;
	public static final int _pi_r1Offset_;
	public static final int _pi_r2Offset_;
	public static final int _pi_rdirOffset_;
	public static final int _pi_repageOffset_;
	public static final int _pi_resvdOffset_;
	public static final int _pi_rlimitOffset_;
	public static final int _pi_ruOffset_;
	public static final int _pi_sdsizeOffset_;
	public static final int _pi_shm_l2psizeOffset_;
	public static final int _pi_sidOffset_;
	public static final int _pi_sigOffset_;
	public static final int _pi_sigflagsOffset_;
	public static final int _pi_signalOffset_;
	public static final int _pi_sizeOffset_;
	public static final int _pi_stack_l2psizeOffset_;
	public static final int _pi_startOffset_;
	public static final int _pi_stateOffset_;
	public static final int _pi_stimeOffset_;
	public static final int _pi_subprojOffset_;
	public static final int _pi_suidOffset_;
	public static final int _pi_tagOffset_;
	public static final int _pi_text_l2psizeOffset_;
	public static final int _pi_thcountOffset_;
	public static final int _pi_trssOffset_;
	public static final int _pi_tsizeOffset_;
	public static final int _pi_ttydOffset_;
	public static final int _pi_ttympxOffset_;
	public static final int _pi_ttypOffset_;
	public static final int _pi_uidOffset_;
	public static final int _pi_utimeOffset_;

	// Static Initializer

	private static final boolean RUNTIME = false;

	static {
		if (!RUNTIME) {
			throw new IllegalArgumentException("This stub class should not be on your classpath");
		}

		SIZEOF = 0;
		_pi_acctflagsOffset_ = 0;
		_pi_adspaceOffset_ = 0;
		_pi_cdirOffset_ = 0;
		_pi_cidOffset_ = 0;
		_pi_classnameOffset_ = 0;
		_pi_cmaskOffset_ = 0;
		_pi_commOffset_ = 0;
		_pi_cpuOffset_ = 0;
		_pi_credOffset_ = 0;
		_pi_cruOffset_ = 0;
		_pi_data_l2psizeOffset_ = 0;
		_pi_drssOffset_ = 0;
		_pi_dsizeOffset_ = 0;
		_pi_dvmOffset_ = 0;
		_pi_flagsOffset_ = 0;
		_pi_flags2Offset_ = 0;
		_pi_iochOffset_ = 0;
		_pi_irssOffset_ = 0;
		_pi_majfltOffset_ = 0;
		_pi_maxofileOffset_ = 0;
		_pi_minfltOffset_ = 0;
		_pi_niceOffset_ = 0;
		_pi_pad4Offset_ = 0;
		_pi_pgrpOffset_ = 0;
		_pi_pidOffset_ = 0;
		_pi_policyOffset_ = 0;
		_pi_ppidOffset_ = 0;
		_pi_ppriOffset_ = 0;
		_pi_priOffset_ = 0;
		_pi_prmOffset_ = 0;
		_pi_projidOffset_ = 0;
		_pi_r1Offset_ = 0;
		_pi_r2Offset_ = 0;
		_pi_rdirOffset_ = 0;
		_pi_repageOffset_ = 0;
		_pi_resvdOffset_ = 0;
		_pi_rlimitOffset_ = 0;
		_pi_ruOffset_ = 0;
		_pi_sdsizeOffset_ = 0;
		_pi_shm_l2psizeOffset_ = 0;
		_pi_sidOffset_ = 0;
		_pi_sigOffset_ = 0;
		_pi_sigflagsOffset_ = 0;
		_pi_signalOffset_ = 0;
		_pi_sizeOffset_ = 0;
		_pi_stack_l2psizeOffset_ = 0;
		_pi_startOffset_ = 0;
		_pi_stateOffset_ = 0;
		_pi_stimeOffset_ = 0;
		_pi_subprojOffset_ = 0;
		_pi_suidOffset_ = 0;
		_pi_tagOffset_ = 0;
		_pi_text_l2psizeOffset_ = 0;
		_pi_thcountOffset_ = 0;
		_pi_trssOffset_ = 0;
		_pi_tsizeOffset_ = 0;
		_pi_ttydOffset_ = 0;
		_pi_ttympxOffset_ = 0;
		_pi_ttypOffset_ = 0;
		_pi_uidOffset_ = 0;
		_pi_utimeOffset_ = 0;
	}

}
