/*
 * Copyright IBM Corp. and others 1991
 *
 * This program and the accompanying materials are made available under
 * the terms of the Eclipse Public License 2.0 which accompanies this
 * distribution and is available at https://www.eclipse.org/legal/epl-2.0/
 * or the Apache License, Version 2.0 which accompanies this distribution
 * and is available at https://www.apache.org/licenses/LICENSE-2.0.
 *
 * This Source Code may also be made available under the following
 * Secondary Licenses when the conditions for such availability set
 * forth in the Eclipse Public License, v. 2.0 are satisfied: GNU
 * General Public License, version 2 with the GNU Classpath
 * Exception [1] and GNU General Public License, version 2 with the
 * OpenJDK Assembly Exception [2].
 *
 * [1] https://www.gnu.org/software/classpath/license.html
 * [2] https://openjdk.org/legal/assembly-exception.html
 *
 * SPDX-License-Identifier: EPL-2.0 OR Apache-2.0 OR GPL-2.0-only WITH Classpath-exception-2.0 OR GPL-2.0-only WITH OpenJDK-assembly-exception-1.0
 */

/*
 * WARNING!!! GENERATED FILE
 *
 * This class is generated.
 * Do not use the Eclipse "Organize Imports" feature on this class.
 *
 * It can contain user content, but that content must be delimited with the
 * the tags
 * [BEGIN USER IMPORTS]
 * [END USER IMPORTS]
 *
 * or
 *
 * [BEGIN USER CODE]
 * [END USER CODE]
 *
 * These tags are entered as comments.  Characters before [ and after ] are ignored.
 * Lines between the tags are inserted into the newly generated file.
 *
 * IMPORTS are combined and inserted above newly generated imports.  CODE is combined
 * and inserted immediately after the class declaration
 *
 * All lines outside these tags are lost and replaced with newly generated code.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

/*[BEGIN USER IMPORTS]*/
/*[END USER IMPORTS]*/

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.vm29.pointer.*;
import com.ibm.j9ddr.vm29.structure.*;
import com.ibm.j9ddr.vm29.types.*;

/**
 * Structure: _LC_object_tPointer
 *
 * A generated implementation of a VM structure
 *
 * This class contains generated code and MAY contain hand written user code.
 *
 * Hand written user code must be contained at the top of
 * the class file, specifically above
 * the comment line containing WARNING!!! GENERATED CODE
 *
 * ALL code below the GENERATED warning will be replaced with new generated code
 * each time the PointerGenerator utility is run.
 *
 * The generated code will provide getters for all elements in the _LC_object_tPointer
 * structure.  Where possible, meaningful return types are inferred.
 *
 * The user may add methods to provide meaningful return types where only pointers
 * could be automatically inferred.
 */
@com.ibm.j9ddr.GeneratedPointerClass(structureClass=_LC_object_t.class)
public class _LC_object_tPointer extends StructurePointer {

	// NULL
	public static final _LC_object_tPointer NULL = new _LC_object_tPointer(0);

/*[BEGIN USER CODE]*/
/*[END USER CODE]*/

	// Do not call this constructor.  Use static method cast instead.
	protected _LC_object_tPointer(long address) {
		super(address);
	}

	public static _LC_object_tPointer cast(AbstractPointer structure) {
		return cast(structure.getAddress());
	}

	public static _LC_object_tPointer cast(UDATA udata) {
		return cast(udata.longValue());
	}

	public static _LC_object_tPointer cast(long address) {
		if (address == 0) {
			return NULL;
		}
		return new _LC_object_tPointer(address);
	}

	public _LC_object_tPointer add(long count) {
		return _LC_object_tPointer.cast(address + (_LC_object_t.SIZEOF * count));
	}

	public _LC_object_tPointer add(Scalar count) {
		return add(count.longValue());
	}

	public _LC_object_tPointer addOffset(long offset) {
		return _LC_object_tPointer.cast(address + offset);
	}

	public _LC_object_tPointer addOffset(Scalar offset) {
		return addOffset(offset.longValue());
	}

	public _LC_object_tPointer sub(long count) {
		return _LC_object_tPointer.cast(address - (_LC_object_t.SIZEOF * count));
	}

	public _LC_object_tPointer sub(Scalar count) {
		return sub(count.longValue());
	}

	public _LC_object_tPointer subOffset(long offset) {
		return _LC_object_tPointer.cast(address - offset);
	}

	public _LC_object_tPointer subOffset(Scalar offset) {
		return subOffset(offset.longValue());
	}

	public _LC_object_tPointer untag(long mask) {
		return _LC_object_tPointer.cast(address & ~mask);
	}

	public _LC_object_tPointer untag() {
		return untag(UDATA.SIZEOF - 1);
	}

	protected long sizeOfBaseType() {
		return _LC_object_t.SIZEOF;
	}

	// Implementation methods

	// U16 __magic
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___magicOffset_", declaredType="U16")
	public U16 __magic() throws CorruptDataException {
		return new U16(getShortAtOffset(_LC_object_t.___magicOffset_));
	}

	// U16 __magic
	public U16Pointer __magicEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_LC_object_t.___magicOffset_));
	}

	// size_t __size
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___sizeOffset_", declaredType="size_t")
	public UDATA __size() throws CorruptDataException {
		return new U64(getLongAtOffset(_LC_object_t.___sizeOffset_));
	}

	// size_t __size
	public UDATAPointer __sizeEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_LC_object_t.___sizeOffset_));
	}

	// U16 __type_id
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___type_idOffset_", declaredType="U16")
	public U16 __type_id() throws CorruptDataException {
		return new U16(getShortAtOffset(_LC_object_t.___type_idOffset_));
	}

	// U16 __type_id
	public U16Pointer __type_idEA() throws CorruptDataException {
		return U16Pointer.cast(nonNullFieldEA(_LC_object_t.___type_idOffset_));
	}

	// U64 __version
	@com.ibm.j9ddr.GeneratedFieldAccessor(offsetFieldName="___versionOffset_", declaredType="U64")
	public UDATA __version() throws CorruptDataException {
		return new U64(getLongAtOffset(_LC_object_t.___versionOffset_));
	}

	// U64 __version
	public UDATAPointer __versionEA() throws CorruptDataException {
		return UDATAPointer.cast(nonNullFieldEA(_LC_object_t.___versionOffset_));
	}

}
